/*
 * Decompiled with CFR 0.152.
 */
package com.prezi.haxe.gradle;

import com.google.common.base.Throwables;
import com.prezi.haxe.gradle.EmbeddedResourceEncoding;
import groovy.lang.Closure;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.commons.io.IOUtils;
import org.gradle.api.Action;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.FileCopyDetails;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.file.copy.CopySpecInternal;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.java.archives.Manifest;
import org.gradle.api.java.archives.internal.DefaultManifest;
import org.gradle.api.tasks.bundling.Zip;
import org.gradle.util.ConfigureUtil;

public class Har
extends Zip {
    public static final String DEFAULT_EXTENSION = "har";
    public static final String MANIFEST_ATTR_LIBRARY_VERSION = "Library-Version";
    public static final String MANIFEST_ATTR_EMBEDDED_RESOURCES = "Embedded-Resources";
    private Manifest manifest;
    private Map<String, File> embeddedResources = new LinkedHashMap<String, File>();
    private final CopySpecInternal metaInf;

    public Har() {
        this.setExtension(DEFAULT_EXTENSION);
        this.manifest = new DefaultManifest((FileResolver)this.getServices().get(FileResolver.class));
        this.metaInf = this.getRootSpec().addFirst();
        this.metaInf.into((Object)"META-INF");
        this.metaInf.addChild().from(new Object[]{new Callable<File>(){

            @Override
            public File call() throws Exception {
                File manifestFile = new File(Har.this.getTemporaryDir(), "MANIFEST.MF");
                FileOutputStream output = null;
                try {
                    output = new FileOutputStream(manifestFile);
                    Manifest manifest = Har.this.getManifest();
                    if (manifest == null) {
                        manifest = new DefaultManifest(null);
                    }
                    manifest.writeTo((Writer)new OutputStreamWriter(output));
                }
                catch (FileNotFoundException e) {
                    try {
                        throw Throwables.propagate((Throwable)e);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(output);
                        throw throwable;
                    }
                }
                IOUtils.closeQuietly((OutputStream)output);
                return manifestFile;
            }
        }});
        this.getMainSpec().eachFile((Action)new Action<FileCopyDetails>(){

            public void execute(FileCopyDetails details) {
                if (details.getPath().equalsIgnoreCase("META-INF/MANIFEST.MF")) {
                    details.exclude();
                }
            }
        });
    }

    public Manifest getManifest() {
        return this.manifest;
    }

    public void setManifest(Manifest manifest) {
        this.manifest = manifest;
    }

    public Har manifest(Closure configureClosure) {
        if (this.getManifest() == null) {
            this.manifest = new DefaultManifest(((ProjectInternal)this.getProject()).getFileResolver());
        }
        ConfigureUtil.configure((Closure)configureClosure, (Object)this.getManifest());
        return this;
    }

    public CopySpec getMetaInf() {
        return this.metaInf.addChild();
    }

    public CopySpec metaInf(Closure configureClosure) {
        return (CopySpec)ConfigureUtil.configure((Closure)configureClosure, (Object)this.getMetaInf());
    }

    protected void copy() {
        this.getManifest().getAttributes().put((Object)MANIFEST_ATTR_LIBRARY_VERSION, (Object)"1.0");
        Map<String, File> embeddedResources = this.getEmbeddedResources();
        if (!embeddedResources.isEmpty()) {
            this.getManifest().getAttributes().put((Object)MANIFEST_ATTR_EMBEDDED_RESOURCES, (Object)EmbeddedResourceEncoding.encode(embeddedResources));
        }
        super.copy();
    }

    public Map<String, File> getEmbeddedResources() {
        return this.embeddedResources;
    }

    public void setEmbeddedResources(Map<String, File> embeddedResources) {
        this.embeddedResources = embeddedResources;
    }
}

