/*
 * Decompiled with CFR 0.152.
 */
package com.prezi.haxe.gradle;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Maps;
import com.prezi.haxe.gradle.AbstractHaxeCompileTask;
import com.prezi.haxe.gradle.CheckHaxeVersion;
import com.prezi.haxe.gradle.DefaultHaxeResourceSet;
import com.prezi.haxe.gradle.DefaultHaxeSourceSet;
import com.prezi.haxe.gradle.Flavor;
import com.prezi.haxe.gradle.Har;
import com.prezi.haxe.gradle.HaxeBinary;
import com.prezi.haxe.gradle.HaxeBinaryBase;
import com.prezi.haxe.gradle.HaxeCompile;
import com.prezi.haxe.gradle.HaxeCompilerParameters;
import com.prezi.haxe.gradle.HaxeExtension;
import com.prezi.haxe.gradle.HaxeResourceSet;
import com.prezi.haxe.gradle.HaxeSourceSet;
import com.prezi.haxe.gradle.HaxeTestBinary;
import com.prezi.haxe.gradle.HaxeTestCompile;
import com.prezi.haxe.gradle.MUnit;
import com.prezi.haxe.gradle.MUnitNode;
import com.prezi.haxe.gradle.TargetPlatform;
import com.prezi.haxe.gradle.incubating.BinaryContainer;
import com.prezi.haxe.gradle.incubating.BinaryInternal;
import com.prezi.haxe.gradle.incubating.BinaryNamingScheme;
import com.prezi.haxe.gradle.incubating.DefaultResourceSet;
import com.prezi.haxe.gradle.incubating.FunctionalSourceSet;
import com.prezi.haxe.gradle.incubating.LanguageSourceSet;
import com.prezi.haxe.gradle.incubating.ProjectSourceSet;
import com.prezi.haxe.gradle.incubating.ResourceSet;
import com.prezi.haxe.gradle.nodetest.HaxeNodeTestCompile;
import java.io.File;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.DomainObjectCollection;
import org.gradle.api.DomainObjectSet;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.DuplicatesStrategy;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.internal.DefaultDomainObjectSet;
import org.gradle.api.internal.artifacts.publish.ArchivePublishArtifact;
import org.gradle.api.internal.file.DefaultSourceDirectorySet;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.plugins.BasePlugin;
import org.gradle.internal.reflect.Instantiator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HaxeBasePlugin
implements Plugin<Project> {
    private static final Logger logger = LoggerFactory.getLogger(HaxeBasePlugin.class);
    public static final String HAXE_SOURCE_SET_NAME = "haxe";
    public static final String RESOURCE_SET_NAME = "resources";
    public static final String HAXE_RESOURCE_SET_NAME = "haxeResources";
    public static final String CHECK_HAXE_VERSION_TASK_NAME = "checkHaxeVersion";
    public static final String COMPILE_TASK_NAME = "compile";
    public static final String COMPILE_TASKS_GROUP = "compile";
    public static final String CHECK_TASK_NAME = "check";
    public static final String BUILD_TASK_NAME = "build";
    public static final String TEST_TASK_NAME = "test";
    public static final String VERIFICATION_GROUP = "verification";
    private final Instantiator instantiator;
    private final FileResolver fileResolver;

    @Inject
    public HaxeBasePlugin(Instantiator instantiator, FileResolver fileResolver) {
        this.instantiator = instantiator;
        this.fileResolver = fileResolver;
    }

    public void apply(final Project project) {
        project.getPlugins().apply(BasePlugin.class);
        final HaxeExtension extension = (HaxeExtension)project.getExtensions().create(HAXE_SOURCE_SET_NAME, HaxeExtension.class, new Object[]{project, this.instantiator});
        final ProjectSourceSet projectSourceSet = extension.getSources();
        final FunctionalSourceSet main = (FunctionalSourceSet)projectSourceSet.maybeCreate("main");
        final FunctionalSourceSet test = (FunctionalSourceSet)projectSourceSet.maybeCreate(TEST_TASK_NAME);
        logger.debug("Created {} and {} in {}", new Object[]{main, test, project.getPath()});
        final Configuration mainCompile = HaxeBasePlugin.maybeCreateCompileConfigurationFor(project, "main");
        final Configuration testCompile = HaxeBasePlugin.maybeCreateCompileConfigurationFor(project, TEST_TASK_NAME);
        testCompile.extendsFrom(new Configuration[]{mainCompile});
        logger.debug("Created {} and {} in {}", new Object[]{mainCompile, testCompile, project.getPath()});
        projectSourceSet.all((Action)new Action<FunctionalSourceSet>(){

            public void execute(FunctionalSourceSet functionalSourceSet) {
                Configuration compileConfiguration = project.getConfigurations().getByName(functionalSourceSet.getName());
                DefaultHaxeSourceSet haxeSourceSet = (DefaultHaxeSourceSet)HaxeBasePlugin.this.instantiator.newInstance(DefaultHaxeSourceSet.class, new Object[]{HaxeBasePlugin.HAXE_SOURCE_SET_NAME, functionalSourceSet, compileConfiguration, HaxeBasePlugin.this.fileResolver});
                haxeSourceSet.getSource().srcDir((Object)String.format("src/%s/haxe", functionalSourceSet.getName()));
                functionalSourceSet.add(haxeSourceSet);
                logger.debug("Added {} in {}", (Object)haxeSourceSet, (Object)project.getPath());
                if (functionalSourceSet.findByName(HaxeBasePlugin.RESOURCE_SET_NAME) == null) {
                    DefaultSourceDirectorySet resourcesDirectorySet = (DefaultSourceDirectorySet)HaxeBasePlugin.this.instantiator.newInstance(DefaultSourceDirectorySet.class, new Object[]{String.format("%s resources", functionalSourceSet.getName()), HaxeBasePlugin.this.fileResolver});
                    resourcesDirectorySet.srcDir((Object)String.format("src/%s/resources", functionalSourceSet.getName()));
                    DefaultResourceSet resourceSet = (DefaultResourceSet)HaxeBasePlugin.this.instantiator.newInstance(DefaultResourceSet.class, new Object[]{HaxeBasePlugin.RESOURCE_SET_NAME, resourcesDirectorySet, functionalSourceSet});
                    functionalSourceSet.add(resourceSet);
                    logger.debug("Added {} in {}", (Object)resourceSet, (Object)project.getPath());
                }
                DefaultHaxeResourceSet haxeResourceSet = (DefaultHaxeResourceSet)HaxeBasePlugin.this.instantiator.newInstance(DefaultHaxeResourceSet.class, new Object[]{HaxeBasePlugin.HAXE_RESOURCE_SET_NAME, functionalSourceSet, HaxeBasePlugin.this.fileResolver});
                functionalSourceSet.add(haxeResourceSet);
                logger.debug("Added {} in {}", (Object)haxeResourceSet, (Object)project.getPath());
            }
        });
        NamedDomainObjectContainer<TargetPlatform> targetPlatforms = extension.getTargetPlatforms();
        targetPlatforms.all((Action)new Action<TargetPlatform>(){

            public void execute(final TargetPlatform targetPlatform) {
                logger.debug("Configuring {} in {}", (Object)targetPlatform, (Object)project.getPath());
                final Configuration platformMainCompile = HaxeBasePlugin.maybeCreateCompileConfigurationFor(project, targetPlatform.getName());
                final Configuration platformTestCompile = HaxeBasePlugin.maybeCreateCompileConfigurationFor(project, targetPlatform.getName() + "Test");
                platformMainCompile.extendsFrom(new Configuration[]{mainCompile});
                platformTestCompile.extendsFrom(new Configuration[]{testCompile});
                platformTestCompile.extendsFrom(new Configuration[]{platformMainCompile});
                logger.debug("Added {} and {} in {}", new Object[]{platformMainCompile, platformTestCompile, project.getPath()});
                final FunctionalSourceSet platformMain = (FunctionalSourceSet)projectSourceSet.maybeCreate(targetPlatform.getName());
                final FunctionalSourceSet platformTest = (FunctionalSourceSet)projectSourceSet.maybeCreate(targetPlatform.getName() + "Test");
                logger.debug("Added {} and {} in {}", new Object[]{platformMain, platformTest, project.getPath()});
                DomainObjectSet mainLanguageSets = HaxeBasePlugin.getLanguageSets(new FunctionalSourceSet[]{main, platformMain});
                DomainObjectSet testLanguageSets = HaxeBasePlugin.getLanguageSets(new FunctionalSourceSet[]{test, platformTest});
                HaxeBasePlugin.createBinaries(project, targetPlatform.getName(), targetPlatform, null, (DomainObjectSet<LanguageSourceSet>)mainLanguageSets, (DomainObjectSet<LanguageSourceSet>)testLanguageSets, platformMainCompile, platformTestCompile);
                targetPlatform.getFlavors().all((Action)new Action<Flavor>(){

                    public void execute(Flavor flavor) {
                        logger.debug("Configuring {} with {} in {}", new Object[]{targetPlatform, flavor, project.getPath()});
                        String flavorName = targetPlatform.getName() + Character.toUpperCase(flavor.getName().charAt(0)) + flavor.getName().substring(1);
                        Configuration flavorMainCompile = HaxeBasePlugin.maybeCreateCompileConfigurationFor(project, flavorName);
                        Configuration flavorTestCompile = HaxeBasePlugin.maybeCreateCompileConfigurationFor(project, flavorName + "Test");
                        flavorMainCompile.extendsFrom(new Configuration[]{platformMainCompile});
                        flavorTestCompile.extendsFrom(new Configuration[]{platformTestCompile});
                        flavorTestCompile.extendsFrom(new Configuration[]{flavorMainCompile});
                        logger.debug("Added {} and {} in {}", new Object[]{flavorMainCompile, flavorTestCompile, project.getPath()});
                        FunctionalSourceSet flavorMain = (FunctionalSourceSet)projectSourceSet.maybeCreate(flavorName);
                        FunctionalSourceSet flavorTest = (FunctionalSourceSet)projectSourceSet.maybeCreate(flavorName + "Test");
                        logger.debug("Added {} and {} in {}", new Object[]{flavorMain, flavorTest, project.getPath()});
                        DomainObjectSet flavorMainLanguageSets = HaxeBasePlugin.getLanguageSets(new FunctionalSourceSet[]{main, platformMain, flavorMain});
                        DomainObjectSet flavorTestLanguageSets = HaxeBasePlugin.getLanguageSets(new FunctionalSourceSet[]{test, platformTest, flavorTest});
                        HaxeBasePlugin.createBinaries(project, flavorName, targetPlatform, flavor, (DomainObjectSet<LanguageSourceSet>)flavorMainLanguageSets, (DomainObjectSet<LanguageSourceSet>)flavorTestLanguageSets, flavorMainCompile, flavorTestCompile);
                    }
                });
            }
        });
        final CheckHaxeVersion checkVersionTask = (CheckHaxeVersion)project.getTasks().create(CHECK_HAXE_VERSION_TASK_NAME, CheckHaxeVersion.class);
        checkVersionTask.getConventionMapping().map("compilerVersions", (Callable)new Callable<Set<Object>>(){

            @Override
            public Set<Object> call() throws Exception {
                return extension.getCompilerVersions();
            }
        });
        checkVersionTask.setDescription("Checks if Haxe compiler is the right version.");
        checkVersionTask.setGroup(VERIFICATION_GROUP);
        project.getTasks().withType(AbstractHaxeCompileTask.class).all((Action)new Action<AbstractHaxeCompileTask>(){

            public void execute(AbstractHaxeCompileTask compileTask) {
                compileTask.dependsOn(new Object[]{checkVersionTask});
            }
        });
        Task compileTask = (Task)project.getTasks().findByName("compile");
        if (compileTask == null) {
            compileTask = project.getTasks().create("compile");
            compileTask.setGroup("compile");
            compileTask.setDescription("Compile all Haxe artifacts");
        }
        final Task _compileTask = compileTask;
        project.getTasks().withType(HaxeCompile.class).all((Action)new Action<HaxeCompile>(){

            public void execute(HaxeCompile task) {
                task.setGroup("compile");
                _compileTask.dependsOn(new Object[]{task});
            }
        });
        Task testTask = (Task)project.getTasks().findByName(TEST_TASK_NAME);
        if (testTask == null) {
            testTask = project.getTasks().create(TEST_TASK_NAME);
            testTask.setGroup(VERIFICATION_GROUP);
            testTask.setDescription("Runs all unit tests.");
        }
        final Task _testTask = testTask;
        Task checkTask = (Task)project.getTasks().findByName(CHECK_TASK_NAME);
        if (checkTask == null) {
            checkTask = project.getTasks().create(CHECK_TASK_NAME);
            checkTask.setGroup(VERIFICATION_GROUP);
            checkTask.setDescription("Runs all checks.");
        }
        checkTask.dependsOn(new Object[]{testTask});
        project.getTasks().withType(MUnit.class).all((Action)new Action<MUnit>(){

            public void execute(MUnit task) {
                task.setGroup(HaxeBasePlugin.VERIFICATION_GROUP);
                if (task.shouldRunAutomatically()) {
                    _testTask.dependsOn(new Object[]{task});
                }
            }
        });
        Task buildTask = (Task)project.getTasks().findByName(BUILD_TASK_NAME);
        if (buildTask == null) {
            buildTask = project.getTasks().create(BUILD_TASK_NAME);
            buildTask.setDescription("Assembles and tests this project.");
            buildTask.setGroup(BUILD_TASK_NAME);
        }
        buildTask.dependsOn(new Object[]{"assemble"});
        buildTask.dependsOn(new Object[]{checkTask});
    }

    private static void createBinaries(Project project, String name, TargetPlatform targetPlatform, Flavor flavor, DomainObjectSet<LanguageSourceSet> mainLanguageSets, DomainObjectSet<LanguageSourceSet> testLanguageSets, Configuration mainConfiguration, Configuration testConfiguration) {
        BinaryContainer binaryContainer = ((HaxeExtension)project.getExtensions().getByType(HaxeExtension.class)).getBinaries();
        final HaxeBinary compileBinary = new HaxeBinary(name, mainConfiguration, targetPlatform, flavor);
        final HaxeTestBinary testBinary = new HaxeTestBinary(name, testConfiguration, targetPlatform, flavor, HaxeTestCompile.class);
        final HaxeTestBinary nodeTestBinary = new HaxeTestBinary("node" + name, testConfiguration, targetPlatform, flavor, HaxeNodeTestCompile.class);
        mainLanguageSets.all((Action)new Action<LanguageSourceSet>(){

            public void execute(LanguageSourceSet it) {
                compileBinary.getSource().add((Object)it);
                testBinary.getSource().add((Object)it);
                nodeTestBinary.getSource().add((Object)it);
            }
        });
        testLanguageSets.all((Action)new Action<LanguageSourceSet>(){

            public void execute(LanguageSourceSet it) {
                testBinary.getSource().add((Object)it);
                nodeTestBinary.getSource().add((Object)it);
            }
        });
        binaryContainer.add(compileBinary);
        binaryContainer.add(testBinary);
        binaryContainer.add(nodeTestBinary);
        logger.debug("Added binaries {} and {} in {}", new Object[]{compileBinary, testBinary, project.getPath()});
    }

    private static DomainObjectSet<LanguageSourceSet> getLanguageSets(FunctionalSourceSet ... functionalSourceSets) {
        DefaultDomainObjectSet result = new DefaultDomainObjectSet(LanguageSourceSet.class);
        for (FunctionalSourceSet functionalSourceSet : functionalSourceSets) {
            result.add(functionalSourceSet.getByName(HAXE_SOURCE_SET_NAME));
            result.add(functionalSourceSet.getByName(RESOURCE_SET_NAME));
            result.add(functionalSourceSet.getByName(HAXE_RESOURCE_SET_NAME));
        }
        return result;
    }

    private static Configuration maybeCreateCompileConfigurationFor(Project project, String name) {
        Configuration config = (Configuration)project.getConfigurations().findByName(name);
        if (config == null) {
            config = (Configuration)project.getConfigurations().create(name);
            config.setVisible(false);
            config.setDescription("Compile classpath for " + name + ".");
        }
        return config;
    }

    public static <T extends HaxeTestCompile> T createTestCompileTask(final Project project, final HaxeTestBinary binary, Class<T> compileType) {
        HaxeTestCompile compileTask = HaxeBasePlugin.createCompileTask(project, binary, compileType);
        compileTask.getConventionMapping().map("workingDirectory", (Callable)new Callable<File>(){

            @Override
            public File call() throws Exception {
                return project.file((Object)(project.getBuildDir() + "/haxe-test-compile/" + binary.getName()));
            }
        });
        return (T)compileTask;
    }

    public static <T extends HaxeCompile> T createCompileTask(Project project, HaxeBinaryBase<? super T> binary, Class<T> compileType) {
        BinaryNamingScheme namingScheme = ((BinaryInternal)((Object)binary)).getNamingScheme();
        String compileTaskName = namingScheme.getTaskName("compile");
        T compileTask = HaxeBasePlugin.createCompileTaskInternal(project, binary, compileType, compileTaskName);
        project.getTasks().getByName(namingScheme.getLifecycleTaskName()).dependsOn(new Object[]{compileTask});
        binary.setCompileTask(compileTask);
        binary.builtBy(compileTask);
        logger.debug("Created compile task {} for {} in {}", new Object[]{compileTask, binary, project.getPath()});
        return compileTask;
    }

    public static <T extends HaxeCompile> T createCompileTaskInternal(final Project project, final HaxeBinaryBase<? super T> binary, Class<T> compileType, String compileTaskName) {
        final HaxeCompile compileTask = (HaxeCompile)project.getTasks().create(compileTaskName, compileType);
        compileTask.setDescription("Compiles " + binary);
        compileTask.getConventionMapping().map("embeddedResources", (Callable)new Callable<Map<String, File>>(){

            @Override
            public Map<String, File> call() throws Exception {
                return HaxeBasePlugin.gatherEmbeddedResources(binary.getSource());
            }
        });
        compileTask.getConventionMapping().map("outputFile", (Callable)new Callable<File>(){

            @Override
            public File call() throws Exception {
                return HaxeBasePlugin.getDefaultCompileTarget(project, binary);
            }
        });
        compileTask.getConventionMapping().map("targetPlatform", (Callable)new Callable<String>(){

            @Override
            public String call() throws Exception {
                return binary.getTargetPlatform().getName();
            }
        });
        compileTask.setConventionMapping((HaxeCompilerParameters)project.getExtensions().getByType(HaxeExtension.class), binary.getTargetPlatform(), binary.getFlavor());
        binary.getSource().all((Action)new Action<LanguageSourceSet>(){

            public void execute(LanguageSourceSet it) {
                compileTask.source(it);
            }
        });
        compileTask.dependsOn(new Object[]{binary.getConfiguration()});
        compileTask.dependsOn(new Object[]{binary.getSource()});
        return (T)compileTask;
    }

    private static File getDefaultCompileTarget(Project project, HaxeBinaryBase binary) {
        BinaryNamingScheme namingScheme = ((BinaryInternal)((Object)binary)).getNamingScheme();
        return project.file((Object)(project.getBuildDir() + "/compiled-haxe/" + namingScheme.getOutputDirectoryBase() + "/compiled." + binary.getTargetPlatform().getName()));
    }

    public static <T extends MUnit> T createMUnitTask(Project project, HaxeTestBinary binary, Class<T> munitType) {
        BinaryNamingScheme namingScheme = binary.getNamingScheme();
        String munitTaskName = namingScheme.getTaskName("run");
        MUnit munitTask = (MUnit)project.getTasks().create(munitTaskName, munitType);
        munitTask.setDescription("Runs MUnit on " + binary);
        HaxeBasePlugin.setMunitTaskProperties(project, binary, munitTask);
        munitTask.dependsOn(new Object[]{binary.getCompileTask()});
        project.getTasks().getByName(namingScheme.getLifecycleTaskName()).dependsOn(new Object[]{munitTask});
        logger.debug("Created munit task {} for {} in {}", new Object[]{munitTask, binary, project.getPath()});
        return (T)((Object)munitTask);
    }

    private static void setMunitTaskProperties(final Project project, final HaxeTestBinary binary, ConventionTask munitTask) {
        munitTask.getConventionMapping().map("workingDirectory", (Callable)new Callable<File>(){

            @Override
            public File call() throws Exception {
                return project.file((Object)(project.getBuildDir() + "/munit/" + binary.getName()));
            }
        });
        munitTask.getConventionMapping().map("targetPlatform", (Callable)new Callable<String>(){

            @Override
            public String call() throws Exception {
                return binary.getTargetPlatform().getName();
            }
        });
        munitTask.getConventionMapping().map("inputFile", (Callable)new Callable<File>(){

            @Override
            public File call() throws Exception {
                return ((HaxeTestCompile)binary.getCompileTask()).getOutputFile();
            }
        });
        if (munitTask instanceof MUnitNode) {
            munitTask.getConventionMapping().map("nodeModulesDirectory", (Callable)new Callable<File>(){

                @Override
                public File call() throws Exception {
                    return ((HaxeExtension)project.getExtensions().getByType(HaxeExtension.class)).getMunitNodeModuleInstallDir();
                }
            });
        }
    }

    public static <T extends Har> T createSourceTask(final Project project, final HaxeBinaryBase<?> binary, Class<T> harType) {
        final BinaryNamingScheme namingScheme = ((BinaryInternal)((Object)binary)).getNamingScheme();
        String sourceTaskName = namingScheme.getTaskName("bundle", "source");
        Har sourceTask = (Har)project.getTasks().create(sourceTaskName, harType);
        sourceTask.setDescription("Bundles the sources of " + binary);
        sourceTask.getConventionMapping().map("baseName", (Callable)new Callable<String>(){

            @Override
            public String call() throws Exception {
                return project.getName();
            }
        });
        sourceTask.getConventionMapping().map("destinationDir", (Callable)new Callable<File>(){

            @Override
            public File call() throws Exception {
                return project.file((Object)(project.getBuildDir() + "/haxe-source/" + namingScheme.getOutputDirectoryBase()));
            }
        });
        sourceTask.getConventionMapping().map("embeddedResources", (Callable)new Callable<Map<String, File>>(){

            @Override
            public Map<String, File> call() throws Exception {
                return HaxeBasePlugin.gatherEmbeddedResources(binary.getSource());
            }
        });
        CopySpec sources = sourceTask.getRootSpec().addChild().into((Object)"sources");
        sources.setDuplicatesStrategy(DuplicatesStrategy.EXCLUDE);
        sources.from(new Object[]{HaxeBasePlugin.getSources(HaxeSourceSet.class, binary)});
        CopySpec resources = sourceTask.getRootSpec().addChild().into((Object)RESOURCE_SET_NAME);
        resources.setDuplicatesStrategy(DuplicatesStrategy.EXCLUDE);
        resources.from(new Object[]{HaxeBasePlugin.getSources(ResourceSet.class, binary)});
        CopySpec embedded = sourceTask.getRootSpec().addChild().into((Object)"embedded");
        embedded.setDuplicatesStrategy(DuplicatesStrategy.EXCLUDE);
        embedded.from(new Object[]{Collections2.transform((Collection)binary.getSource().withType(HaxeResourceSet.class), (Function)new Function<HaxeResourceSet, Collection<File>>(){

            public Collection<File> apply(HaxeResourceSet resourceSet) {
                return resourceSet.getEmbeddedResources().values();
            }
        })});
        sourceTask.dependsOn(new Object[]{binary.getSource()});
        project.getTasks().getByName(namingScheme.getLifecycleTaskName()).dependsOn(new Object[]{sourceTask});
        binary.setSourceHarTask(sourceTask);
        binary.builtBy(new Object[]{sourceTask});
        ArchivePublishArtifact artifact = (ArchivePublishArtifact)project.getArtifacts().add(binary.getConfiguration().getName(), (Object)sourceTask);
        artifact.setName(project.getName() + "-" + binary.getName());
        artifact.setType("har");
        logger.debug("Created source source task {} for {} in {}", new Object[]{sourceTask, binary, project.getPath()});
        return (T)((Object)sourceTask);
    }

    private static Collection<SourceDirectorySet> getSources(Class<? extends LanguageSourceSet> type, HaxeBinaryBase<?> binary) {
        return Collections2.transform((Collection)binary.getSource().withType(type), (Function)new Function<LanguageSourceSet, SourceDirectorySet>(){

            public SourceDirectorySet apply(LanguageSourceSet sourceSet) {
                return sourceSet.getSource();
            }
        });
    }

    public static Map<String, File> gatherEmbeddedResources(DomainObjectCollection<LanguageSourceSet> source) {
        LinkedHashMap result = Maps.newLinkedHashMap();
        for (HaxeResourceSet resourceSet : source.withType(HaxeResourceSet.class)) {
            result.putAll(resourceSet.getEmbeddedResources());
        }
        return result;
    }
}

