/*
 * Decompiled with CFR 0.152.
 */
package com.prezi.haxe.gradle;

import com.google.common.collect.Lists;
import com.prezi.haxe.gradle.incubating.BinaryNamingScheme;
import java.util.List;
import org.gradle.api.Nullable;

public class HaxeBinaryNamingScheme
implements BinaryNamingScheme {
    private final String parentName;
    private final String collapsedName;

    public HaxeBinaryNamingScheme(String parentName) {
        this.parentName = parentName;
        this.collapsedName = HaxeBinaryNamingScheme.collapseMain(this.parentName);
    }

    private static String collapseMain(String name) {
        return name.equals("main") ? "" : name;
    }

    @Override
    public String getDescription() {
        return String.format("%s binary", this.parentName);
    }

    @Override
    public String getLifecycleTaskName() {
        return this.getTaskName(null, null);
    }

    @Override
    public String getTaskName(@Nullable String verb) {
        return this.getTaskName(verb, null);
    }

    @Override
    public String getTaskName(@Nullable String verb, @Nullable String target) {
        return HaxeBinaryNamingScheme.makeName(verb, this.collapsedName, target);
    }

    private static String makeName(String ... words) {
        StringBuilder builder = new StringBuilder();
        for (String word : words) {
            if (word == null || word.length() == 0) continue;
            if (builder.length() == 0) {
                HaxeBinaryNamingScheme.appendUncapitalized(builder, word);
                continue;
            }
            HaxeBinaryNamingScheme.appendCapitalized(builder, word);
        }
        return builder.toString();
    }

    private static void appendCapitalized(StringBuilder builder, String word) {
        builder.append(Character.toTitleCase(word.charAt(0))).append(word.substring(1));
    }

    private static void appendUncapitalized(StringBuilder builder, String word) {
        builder.append(Character.toLowerCase(word.charAt(0))).append(word.substring(1));
    }

    @Override
    public String getOutputDirectoryBase() {
        return this.parentName;
    }

    @Override
    public List<String> getVariantDimensions() {
        return Lists.newArrayList();
    }
}

