/*
 * Decompiled with CFR 0.152.
 */
package com.prezi.haxe.gradle;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.prezi.haxe.gradle.HaxeSourceSet;
import com.prezi.haxe.gradle.HaxelibDependencyExtractor;
import com.prezi.haxe.gradle.incubating.LanguageSourceSet;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.api.Project;
import org.gradle.api.file.FileCollection;

public class HaxeCommandBuilder {
    private final HaxelibDependencyExtractor extractor;
    private final List<String> cmd;

    public HaxeCommandBuilder(Project project, String ... cmd) {
        this.extractor = new HaxelibDependencyExtractor(project);
        this.cmd = Lists.newArrayList(Arrays.asList(cmd));
    }

    public List<String> build() {
        return this.cmd;
    }

    public void append(Object ... what) {
        for (Object it : what) {
            this.cmd.add(String.valueOf(it));
        }
    }

    public HaxeCommandBuilder withMain(String main) {
        if (!Strings.isNullOrEmpty((String)main)) {
            this.append("-main", main);
        }
        return this;
    }

    public HaxeCommandBuilder withTarget(String target, File output) {
        this.append("-" + target, output);
        if (target.equals("swf")) {
            this.append("-swf-version", 11);
        }
        return this;
    }

    public HaxeCommandBuilder withIncludes(Iterable<?> inlcudes) {
        for (Object it : inlcudes) {
            this.append("--macro", "include('" + String.valueOf(it) + "')");
        }
        return this;
    }

    public HaxeCommandBuilder withExcludes(Iterable<?> excludes) {
        for (Object it : excludes) {
            this.append("--macro", "exclude('" + String.valueOf(it) + "')");
        }
        return this;
    }

    public HaxeCommandBuilder withMacros(Iterable<?> macros) {
        for (Object it : macros) {
            this.append("--macro", it);
        }
        return this;
    }

    private HaxeCommandBuilder withEmbeddedResources(Map<String, File> embeddedResources) {
        for (Map.Entry<String, File> entry : embeddedResources.entrySet()) {
            String name = entry.getKey();
            File file = entry.getValue();
            String filePath = file.getAbsolutePath();
            this.append("-resource", filePath + "@" + name);
        }
        return this;
    }

    public HaxeCommandBuilder withSources(Iterable<File> sources) {
        for (File it : sources) {
            this.append("-cp", it);
        }
        return this;
    }

    public HaxeCommandBuilder withSourceSets(Set<LanguageSourceSet> sources, Map<String, File> embeddedResources) {
        LinkedHashSet sourcePath = Sets.newLinkedHashSet();
        LinkedHashSet resourcePath = Sets.newLinkedHashSet();
        LinkedHashMap allEmbeddedResources = Maps.newLinkedHashMap();
        allEmbeddedResources.putAll(embeddedResources);
        for (LanguageSourceSet source : sources) {
            if (!(source instanceof HaxeSourceSet)) continue;
            this.extractor.extractDependenciesFrom((FileCollection)((HaxeSourceSet)source).getCompileClassPath(), sourcePath, resourcePath, allEmbeddedResources);
        }
        this.withSources(sourcePath);
        this.withSources(resourcePath);
        this.withEmbeddedResources(allEmbeddedResources);
        return this;
    }

    public HaxeCommandBuilder withFlags(Iterable<String> flags) {
        for (String flag : flags) {
            for (String flagPart : flag.split(" ")) {
                this.append(flagPart);
            }
        }
        return this;
    }

    public HaxeCommandBuilder withDebugFlags(boolean debug) {
        if (debug) {
            this.withFlags(new ArrayList<String>(Arrays.asList("-D fdb", "-debug")));
        }
        return this;
    }
}

