/*
 * Decompiled with CFR 0.152.
 */
package com.prezi.haxe.gradle;

import com.prezi.haxe.gradle.AbstractHaxeCompileTask;
import com.prezi.haxe.gradle.CommandExecutor;
import com.prezi.haxe.gradle.DefaultExecutionResultHandler;
import com.prezi.haxe.gradle.HaxeCommandBuilder;
import com.prezi.haxe.gradle.incubating.LanguageSourceSet;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.gradle.api.DomainObjectSet;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;

public class HaxeCompile
extends AbstractHaxeCompileTask {
    private File outputFile;
    private File outputDirectory;

    @TaskAction
    public void compile() throws IOException, InterruptedException {
        List<String> cmd = this.getHaxeCommandToExecute();
        CommandExecutor.execute(cmd, this.getProject().getProjectDir(), new DefaultExecutionResultHandler(cmd));
    }

    public List<String> getHaxeCommandToExecute() throws IOException {
        return this.configureHaxeCommandBuilder(this.getAndRecreateOutput(), this.getSourceSets()).build();
    }

    protected HaxeCommandBuilder configureHaxeCommandBuilder(File output, DomainObjectSet<LanguageSourceSet> sources) {
        return new HaxeCommandBuilder(this.getProject(), "haxe").withMain(this.getMainClass()).withTarget(this.getTargetPlatform(), output).withSources(this.getSourceDirectories(sources)).withSourceSets((Set<LanguageSourceSet>)sources, this.getEmbeddedResources()).withMacros(this.getMacros()).withIncludes(this.getIncludes()).withExcludes(this.getExcludes()).withFlags(this.getFlagList()).withDebugFlags(this.isDebug());
    }

    protected Set<File> getSourceDirectories(DomainObjectSet<LanguageSourceSet> sources) {
        return AbstractHaxeCompileTask.getAllSourceDirectories(sources);
    }

    protected String getMainClass() {
        return this.getMain();
    }

    @OutputFile
    @Optional
    public File getOutputFile() {
        return this.outputFile;
    }

    public void setOutputFile(Object file) {
        this.outputFile = this.getProject().file(file);
    }

    public void outputFile(Object file) {
        this.setOutputFile(file);
    }

    @OutputDirectory
    @Optional
    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    public void setOutputDirectory(Object directory) {
        this.outputDirectory = this.getProject().file(directory);
    }

    public void outputDirectory(Object directory) {
        this.setOutputDirectory(directory);
    }

    private File getAndRecreateOutput() throws IOException {
        File dirToMake;
        File output;
        if (this.isOutputInADirectory()) {
            output = this.getOutputDirectory();
            FileUtils.deleteDirectory((File)output);
            dirToMake = output;
        } else {
            output = this.getOutputFile();
            output.delete();
            dirToMake = output.getParentFile();
        }
        FileUtils.forceMkdir((File)dirToMake);
        return output;
    }

    private boolean isOutputInADirectory() {
        if (this.getOutputFile() != null) {
            return false;
        }
        if (this.getOutputDirectory() != null) {
            return true;
        }
        throw new RuntimeException("Neither output file or directory is set");
    }
}

