/*
 * Decompiled with CFR 0.152.
 */
package com.prezi.haxe.gradle;

import com.google.common.collect.Sets;
import com.prezi.haxe.gradle.DefaultHaxeCompilerParameters;
import com.prezi.haxe.gradle.DefaultTargetPlatform;
import com.prezi.haxe.gradle.TargetPlatform;
import com.prezi.haxe.gradle.incubating.BinaryContainer;
import com.prezi.haxe.gradle.incubating.BinaryInternal;
import com.prezi.haxe.gradle.incubating.DefaultBinaryContainer;
import com.prezi.haxe.gradle.incubating.DefaultProjectSourceSet;
import com.prezi.haxe.gradle.incubating.ProjectSourceSet;
import java.io.File;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.NamedDomainObjectFactory;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.internal.reflect.Instantiator;

public class HaxeExtension
extends DefaultHaxeCompilerParameters
implements Serializable {
    private final NamedDomainObjectContainer<TargetPlatform> targetPlatforms;
    private final ProjectSourceSet sources;
    private final BinaryContainer binaries;
    private final Set<Object> compilerVersions = Sets.newLinkedHashSet();
    private File munitNodeModuleInstallDir;

    public HaxeExtension(final Project project, Instantiator instantiator) {
        this.sources = (ProjectSourceSet)instantiator.newInstance(DefaultProjectSourceSet.class, new Object[]{instantiator});
        this.binaries = (BinaryContainer)instantiator.newInstance(DefaultBinaryContainer.class, new Object[]{instantiator});
        this.targetPlatforms = project.container(TargetPlatform.class, (NamedDomainObjectFactory)new TargetPlatformNamedDomainObjectFactory(project));
        this.binaries.withType(BinaryInternal.class).all((Action)new Action<BinaryInternal>(){

            public void execute(BinaryInternal binary) {
                Task binaryLifecycleTask = project.task(binary.getNamingScheme().getLifecycleTaskName());
                binaryLifecycleTask.setGroup("build");
                binaryLifecycleTask.setDescription(String.format("Assembles %s.", binary));
                binary.setBuildTask(binaryLifecycleTask);
            }
        });
    }

    public File getMunitNodeModuleInstallDir() {
        return this.munitNodeModuleInstallDir;
    }

    public void setMunitNodeModuleInstallDir(File munitNodeModuleInstallDir) {
        this.munitNodeModuleInstallDir = munitNodeModuleInstallDir;
    }

    public ProjectSourceSet getSources() {
        return this.sources;
    }

    public void sources(Action<ProjectSourceSet> action) {
        action.execute((Object)this.sources);
    }

    public BinaryContainer getBinaries() {
        return this.binaries;
    }

    public void binaries(Action<BinaryContainer> action) {
        action.execute((Object)this.binaries);
    }

    public NamedDomainObjectContainer<TargetPlatform> getTargetPlatforms() {
        return this.targetPlatforms;
    }

    public void targetPlatforms(Action<? super NamedDomainObjectContainer<TargetPlatform>> action) {
        action.execute(this.targetPlatforms);
    }

    public void setCompilerVersions(Object ... versions) {
        this.compilerVersions.addAll(Arrays.asList(versions));
    }

    public void setCompilerVersion(Object ... versions) {
        this.setCompilerVersions(versions);
    }

    public void compilerVersions(Object ... versions) {
        this.setCompilerVersions(versions);
    }

    public void compilerVersion(Object ... versions) {
        this.setCompilerVersions(versions);
    }

    public Set<Object> getCompilerVersions() {
        return this.compilerVersions;
    }

    private static class TargetPlatformNamedDomainObjectFactory
    implements NamedDomainObjectFactory<TargetPlatform>,
    Serializable {
        private final Project project;

        public TargetPlatformNamedDomainObjectFactory(Project project) {
            this.project = project;
        }

        public TargetPlatform create(String platformName) {
            return new DefaultTargetPlatform(platformName, this.project);
        }
    }
}

