/*
 * Decompiled with CFR 0.152.
 */
package com.prezi.haxe.gradle;

import com.prezi.haxe.gradle.Har;
import com.prezi.haxe.gradle.HaxeBasePlugin;
import com.prezi.haxe.gradle.HaxeBinary;
import com.prezi.haxe.gradle.HaxeCompile;
import com.prezi.haxe.gradle.HaxeExtension;
import com.prezi.haxe.gradle.HaxeTestBinary;
import com.prezi.haxe.gradle.HaxeTestCompile;
import com.prezi.haxe.gradle.MUnit;
import com.prezi.haxe.gradle.incubating.BinaryContainer;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;

public class HaxePlugin
implements Plugin<Project> {
    public void apply(final Project project) {
        project.getPlugins().apply(HaxeBasePlugin.class);
        BinaryContainer binaryContainer = ((HaxeExtension)project.getExtensions().getByType(HaxeExtension.class)).getBinaries();
        binaryContainer.withType(HaxeBinary.class).all((Action)new Action<HaxeBinary>(){

            public void execute(HaxeBinary binary) {
                HaxeBasePlugin.createCompileTask(project, binary, HaxeCompile.class);
                HaxeBasePlugin.createSourceTask(project, binary, Har.class);
            }
        });
        binaryContainer.withType(HaxeTestBinary.class).all((Action)new Action<HaxeTestBinary>(){

            public void execute(HaxeTestBinary binary) {
                HaxeBasePlugin.createTestCompileTask(project, binary, HaxeTestCompile.class);
                HaxeBasePlugin.createSourceTask(project, binary, Har.class);
                HaxeBasePlugin.createMUnitTask(project, binary, MUnit.class);
            }
        });
    }
}

