/*
 * Decompiled with CFR 0.152.
 */
package com.prezi.haxe.gradle;

import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import com.google.common.io.Files;
import com.prezi.haxe.gradle.CommandExecutor;
import com.prezi.haxe.gradle.DefaultExecutionResultHandler;
import com.prezi.haxe.gradle.HaxeCommandBuilder;
import com.prezi.haxe.gradle.HaxeCompile;
import com.prezi.haxe.gradle.incubating.LanguageSourceSet;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.gradle.api.DomainObjectSet;

public class HaxeTestCompile
extends HaxeCompile {
    private static final Pattern EXAMPLE_TEST_LINE = Pattern.compile("(import |\\s*add\\()ExampleTest\\)?;");
    private static final Pattern NO_JUNIT_CLIENT = Pattern.compile("\\s+runner.addResultClient.*;");
    private static final Pattern JUNIT_CLIENT = Pattern.compile("\\s+//\\s*runner.addResultClient.*;");
    private File workingDirectory;

    @Override
    public void compile() throws IOException, InterruptedException {
        File workDir = this.getWorkingDirectory();
        FileUtils.deleteDirectory((File)workDir);
        FileUtils.forceMkdir((File)workDir);
        File testsDir = this.getTestsDirectory();
        for (File sourceDir : super.getSourceDirectories(this.getSourceSets())) {
            if (!sourceDir.exists()) continue;
            FileUtils.copyDirectory((File)sourceDir, (File)testsDir);
        }
        List<String> cmd = Arrays.asList("haxelib", "run", "munit", "gen", testsDir.getName());
        CommandExecutor.execute(cmd, workDir, new DefaultExecutionResultHandler(cmd));
        this.postProcessGeneratedSources(testsDir);
        super.compile();
    }

    protected void postProcessGeneratedSources(File testsDir) throws IOException {
        File main;
        FileUtils.deleteQuietly((File)new File(testsDir, "ExampleTest.hx"));
        File suite = new File(testsDir, "TestSuite.hx");
        if (suite.exists()) {
            List suiteText = Files.readLines((File)suite, (Charset)Charsets.UTF_8);
            FileUtils.deleteQuietly((File)suite);
            Files.write((CharSequence)Joiner.on((String)"\n").join(Iterables.transform((Iterable)suiteText, (Function)new Function<String, String>(){

                public String apply(String line) {
                    String result = EXAMPLE_TEST_LINE.matcher(line).matches() ? "// " + line : line;
                    return result;
                }
            })), (File)suite, (Charset)Charsets.UTF_8);
        }
        if ((main = new File(testsDir, "TestMain.hx")).exists()) {
            List mainText = Files.readLines((File)main, (Charset)Charsets.UTF_8);
            FileUtils.deleteQuietly((File)main);
            Files.write((CharSequence)Joiner.on((String)"\n").join(Iterables.transform((Iterable)mainText, (Function)new Function<String, String>(){

                public String apply(String line) {
                    String result = NO_JUNIT_CLIENT.matcher(line).matches() ? "// " + line : (JUNIT_CLIENT.matcher(line).matches() ? line.replaceFirst("//", "") : line);
                    return result;
                }
            })), (File)main, (Charset)Charsets.UTF_8);
        }
    }

    @Override
    protected HaxeCommandBuilder configureHaxeCommandBuilder(File output, DomainObjectSet<LanguageSourceSet> sources) {
        HaxeCommandBuilder builder = super.configureHaxeCommandBuilder(output, sources);
        if (this.getProject().hasProperty("munit.debug")) {
            builder.withFlags(new ArrayList<String>(Arrays.asList("-D testDebug")));
        }
        return builder;
    }

    @Override
    protected String getMainClass() {
        return "TestMain";
    }

    @Override
    protected Set<File> getSourceDirectories(DomainObjectSet<LanguageSourceSet> sources) {
        return Collections.singleton(this.getTestsDirectory());
    }

    public File getTestsDirectory() {
        return new File(this.getWorkingDirectory(), "tests");
    }

    public void workingDirectory(Object workingDirectory) {
        this.setWorkingDirectory(workingDirectory);
    }

    public File getWorkingDirectory() {
        return this.workingDirectory;
    }

    public void setWorkingDirectory(Object workingDirectory) {
        this.workingDirectory = this.getProject().file(workingDirectory);
    }
}

