/*
 * Decompiled with CFR 0.152.
 */
package com.prezi.haxe.gradle;

import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.prezi.haxe.gradle.EmbeddedResourceEncoding;
import com.prezi.haxe.gradle.HaxelibType;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.jar.Manifest;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.internal.file.FileOperations;
import org.gradle.api.internal.project.ProjectInternal;

public class HaxelibDependencyExtractor {
    private static final String EXTRACTED_HAXELIBS_DIR = "haxelibs";
    private final Project project;

    public HaxelibDependencyExtractor(Project project) {
        this.project = project;
    }

    public void extractDependenciesFrom(FileCollection classPath, Set<File> sourcePath, Set<File> resourcePath, Map<String, File> embeds) {
        if (classPath instanceof Configuration) {
            for (Configuration config : ((Configuration)classPath).getHierarchy()) {
                this.extractDependenciesFromInternal(config, sourcePath, resourcePath, embeds);
            }
        } else {
            for (File file : classPath.getFiles()) {
                this.extractFile(file.getName(), file, sourcePath, resourcePath, embeds);
            }
        }
    }

    private void extractDependenciesFromInternal(Configuration configuration, Set<File> sourcePath, Set<File> resourcePath, Map<String, File> embeds) {
        for (Dependency dependency : configuration.getAllDependencies()) {
            if (dependency instanceof ProjectDependency) {
                ProjectDependency projectDependency = (ProjectDependency)dependency;
                Configuration dependentConfiguration = projectDependency.getProjectConfiguration();
                this.extractDependenciesFromInternal(dependentConfiguration, sourcePath, resourcePath, embeds);
                Iterable harArtifacts = Iterables.filter((Iterable)dependentConfiguration.getAllArtifacts(), (Predicate)new Predicate<PublishArtifact>(){

                    public boolean apply(PublishArtifact artifact) {
                        return artifact.getType().equals("har");
                    }
                });
                for (PublishArtifact artifact : harArtifacts) {
                    String libName = artifact.getName() + (!Strings.isNullOrEmpty((String)artifact.getClassifier()) ? "-" + artifact.getClassifier() : "");
                    this.extractFile(libName, artifact.getFile(), sourcePath, resourcePath, embeds);
                }
                continue;
            }
            for (File file : configuration.files(new Dependency[]{dependency})) {
                this.extractFile(file.getName(), file, sourcePath, resourcePath, embeds);
            }
        }
    }

    private void extractFile(String libName, File file, Set<File> sourcePath, Set<File> resourcePath, Map<String, File> embeddedResources) {
        final File targetPath = this.project.file((Object)(String.valueOf(this.project.getBuildDir()) + "/" + EXTRACTED_HAXELIBS_DIR + "/" + libName));
        this.project.getLogger().debug("Extracting Haxe library file: {} into {}", (Object)file, (Object)targetPath);
        final FileTree zip = this.project.zipTree((Object)file);
        ((FileOperations)((ProjectInternal)this.project).getServices().get(FileOperations.class)).sync((Action)new Action<CopySpec>(){

            public void execute(CopySpec copySpec) {
                copySpec.from(new Object[]{zip});
                copySpec.into((Object)targetPath);
            }
        });
        HaxelibTypeDetector typeDetector = new HaxelibTypeDetector(targetPath);
        zip.visit((FileVisitor)typeDetector);
        File libraryRoot = typeDetector.getLibraryRoot();
        Manifest manifest = typeDetector.getManifest();
        HaxelibType type = typeDetector.getType();
        if (type == null) {
            this.project.getLogger().warn("Unsupported library type: " + file);
        } else {
            switch (type) {
                case VERSION_1_0: {
                    File sources = new File(libraryRoot, "sources");
                    File resources = new File(libraryRoot, "resources");
                    File embedded = new File(libraryRoot, "embedded");
                    if (sources.exists()) {
                        this.project.getLogger().debug("Prezi Haxelib 1.0, adding sources at {}", (Object)sources);
                        sourcePath.add(sources);
                    }
                    if (resources.exists()) {
                        this.project.getLogger().debug("Prezi Haxelib 1.0, adding resources at {}", (Object)resources);
                        resourcePath.add(resources);
                    }
                    if (!embedded.exists()) break;
                    this.project.getLogger().debug("Prezi Haxelib 1.0, adding embedded resources at {}", (Object)embedded);
                    resourcePath.add(embedded);
                    embeddedResources.putAll(EmbeddedResourceEncoding.decode(manifest.getMainAttributes().getValue("Embedded-Resources"), embedded));
                    break;
                }
                case HAXELIB: {
                    this.project.getLogger().debug("Official Haxelib, adding root at {}", (Object)libraryRoot);
                    sourcePath.add(libraryRoot);
                }
            }
        }
    }

    private static class HaxelibTypeDetector
    implements FileVisitor {
        private File libraryRoot;
        private Manifest manifest;
        private HaxelibType type;

        public HaxelibTypeDetector(File targetPath) {
            this.libraryRoot = targetPath;
        }

        public void visitDir(FileVisitDetails details) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void visitFile(FileVisitDetails details) {
            String path = details.getPath();
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            if (path.equals("META-INF/MANIFEST.MF")) {
                try {
                    FileInputStream fis = new FileInputStream(details.getFile());
                    try {
                        this.manifest = new Manifest(fis);
                        if (!"1.0".equals(this.manifest.getMainAttributes().getValue("Library-Version"))) return;
                        this.type = HaxelibType.VERSION_1_0;
                        details.stopVisiting();
                        return;
                    }
                    finally {
                        fis.close();
                    }
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            } else {
                if (!details.getName().equals("haxelib.json") && !details.getName().equals("haxelib.xml") || details.getRelativePath().getParent() == null) return;
                this.type = HaxelibType.HAXELIB;
                this.libraryRoot = details.getRelativePath().getParent().getFile(this.libraryRoot);
                details.stopVisiting();
            }
        }

        public File getLibraryRoot() {
            return this.libraryRoot;
        }

        public Manifest getManifest() {
            return this.manifest;
        }

        public HaxelibType getType() {
            return this.type;
        }
    }
}

