/*
 * Decompiled with CFR 0.152.
 */
package com.prezi.haxe.gradle;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import com.google.common.io.InputSupplier;
import com.google.common.io.Resources;
import com.prezi.haxe.gradle.CommandExecutor;
import com.prezi.haxe.gradle.DefaultExecutionResultHandler;
import com.prezi.haxe.gradle.MUnitCommandBuilder;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.TaskAction;

public class MUnit
extends ConventionTask {
    private static final Pattern SUCCESSFUL_TEST_PATTERN = Pattern.compile("(?m)^PLATFORMS TESTED: \\d+, PASSED: \\d+, FAILED: 0, ERRORS: 0, TIME:");
    private String targetPlatform;
    private File inputFile;
    private File workingDirectory;

    @Input
    public String getTargetPlatform() {
        return this.targetPlatform;
    }

    public void setTargetPlatform(String targetPlatform) {
        this.targetPlatform = targetPlatform;
    }

    public void targetPlatform(String targetPlatform) {
        this.targetPlatform = targetPlatform;
    }

    @InputFile
    public File getInputFile() {
        return this.inputFile;
    }

    public void setInputFile(Object file) {
        this.inputFile = this.getProject().file(file);
    }

    public void inputFile(Object file) {
        this.setInputFile(file);
    }

    @TaskAction
    public void munit() throws IOException, InterruptedException {
        File workDir = this.getWorkingDirectory();
        FileUtils.deleteDirectory((File)workDir);
        FileUtils.forceMkdir((File)workDir);
        this.prepareEnvironment(workDir);
        if (this.getProject().hasProperty("munit.skiprunner")) {
            return;
        }
        List<String> cmd = this.getMUnitCommandLine();
        CommandExecutor.execute(cmd, this.getWorkingDirectory(), new DefaultExecutionResultHandler(cmd){

            @Override
            public void handleResult(int exitValue, String output) {
                super.handleResult(exitValue, output);
                if (!this.isTestSuccessful(output)) {
                    throw new RuntimeException("There are failing tests");
                }
            }

            @Override
            protected boolean shouldPrintResult(int exitValue, String output) {
                return super.shouldPrintResult(exitValue, output) || !this.isTestSuccessful(output);
            }

            private boolean isTestSuccessful(String output) {
                return SUCCESSFUL_TEST_PATTERN.matcher(output).find();
            }
        });
    }

    protected List<String> getMUnitCommandLine() {
        return new MUnitCommandBuilder(this.getProject()).build();
    }

    protected void prepareEnvironment(File workDir) throws IOException {
        String testBinaryName = this.copyCompiledTest(workDir);
        File testHxml = new File(workDir, "test.hxml");
        Files.write((CharSequence)("-" + this.getTargetPlatform() + " " + testBinaryName + "\n"), (File)testHxml, (Charset)Charsets.UTF_8);
        File munitConfig = new File(workDir, ".munit");
        Files.write((CharSequence)"bin=.\nreport=report\nhxml=test.hxml\nresources=.\n", (File)munitConfig, (Charset)Charsets.UTF_8);
        if (this.getTargetPlatform().equals("js")) {
            Files.append((CharSequence)"templates=templates\n", (File)munitConfig, (Charset)Charsets.UTF_8);
            File templatesDir = new File(workDir, "templates");
            FileUtils.forceMkdir((File)templatesDir);
            File jsRunnerTemplate = new File(templatesDir, "js_runner-html.mtt");
            Files.copy((InputSupplier)Resources.newInputStreamSupplier((URL)this.getMUnitJsHtmlTemplate()), (File)jsRunnerTemplate);
        }
    }

    protected String copyCompiledTest(File workDir) throws IOException {
        String testBinaryName = this.getTargetPlatform() + "_test.js";
        File testFile = new File(workDir, testBinaryName);
        this.getLogger().debug("Copying test file from {} to {}", (Object)this.getInputFile(), (Object)testFile);
        Files.copy((File)this.getInputFile(), (File)testFile);
        return testBinaryName;
    }

    public File getWorkingDirectory() {
        return this.workingDirectory;
    }

    public void setWorkingDirectory(Object workingDirectory) {
        this.workingDirectory = this.getProject().file(workingDirectory);
    }

    public void workingDirectory(Object workingDirectory) {
        this.setWorkingDirectory(workingDirectory);
    }

    protected URL getMUnitJsHtmlTemplate() {
        return ((Object)((Object)this)).getClass().getResource("/js_runner-html.mtt");
    }

    public boolean shouldRunAutomatically() {
        return !this.getProject().hasProperty("munit.usenode") || this.getProject().property("munit.usenode").equals("false");
    }
}

