/*
 * Decompiled with CFR 0.152.
 */
package com.prezi.haxe.gradle;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import org.gradle.api.Project;

public class MUnitCommandBuilder {
    private final Project project;
    private final List<String> cmd;

    public MUnitCommandBuilder(Project project) {
        this.project = project;
        this.cmd = Lists.newArrayList();
    }

    public List<String> build() {
        if (this.project.hasProperty("munit.haxeRunner")) {
            this.cmd.addAll(Arrays.asList("haxe", "--run", "tools.haxelib.Main"));
        } else {
            this.cmd.add("haxelib");
        }
        this.cmd.addAll(Arrays.asList("run", "munit", "run"));
        this.processCommandLineOptions();
        return this.cmd;
    }

    private void processCommandLineOptions() {
        if (this.project.hasProperty("munit.platform")) {
            this.cmd.add("-" + this.project.property("munit.platform"));
        }
        if (this.project.hasProperty("munit.browser")) {
            this.cmd.addAll(Arrays.asList("-browser", String.valueOf(this.project.property("munit.browser"))));
        }
        if (this.project.hasProperty("munit.kill-browser")) {
            this.cmd.add("-kill-browser");
        }
    }
}

