/*
 * Decompiled with CFR 0.152.
 */
package com.prezi.haxe.gradle;

import com.google.common.io.Resources;
import com.prezi.haxe.gradle.MUnit;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import javax.inject.Inject;
import org.apache.commons.io.FileUtils;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.gradle.process.internal.ExecAction;
import org.gradle.process.internal.ExecActionFactory;

public class MUnitNode
extends MUnit {
    public static final String MUNIT_NODE_RUNNER_JS = "munit_node_runner.js";
    private final ExecActionFactory execActionFactory;
    private File nodeModulesDirectory;

    @InputDirectory
    public File getNodeModulesDirectory() {
        return this.nodeModulesDirectory;
    }

    public void setNodeModulesDirectory(Object nodeModulesDirectory) {
        this.nodeModulesDirectory = this.getProject().file(nodeModulesDirectory);
    }

    public void nodeModulesDirectory(Object nodeModulesDirectory) {
        this.setNodeModulesDirectory(nodeModulesDirectory);
    }

    @Inject
    public MUnitNode(ExecActionFactory execActionFactory) {
        this.execActionFactory = execActionFactory;
    }

    @Override
    protected void prepareEnvironment(File workDir) throws IOException {
        this.copyCompiledTest(workDir);
        this.setupRunner(workDir);
    }

    @Override
    @TaskAction
    public void munit() throws IOException, InterruptedException {
        File workDir = this.getWorkingDirectory();
        FileUtils.deleteDirectory((File)workDir);
        FileUtils.forceMkdir((File)workDir);
        this.prepareEnvironment(workDir);
        File munitNodeRunner = new File(workDir, MUNIT_NODE_RUNNER_JS);
        munitNodeRunner.setExecutable(true);
        ExecAction exec = this.execActionFactory.newExecAction();
        exec.workingDir((Object)workDir);
        exec.commandLine(new Object[]{"./" + munitNodeRunner.getName()});
        exec.environment("NODE_PATH", (Object)this.getNodeModulesDirectory());
        exec.execute();
    }

    private void setupRunner(File workDir) throws IOException {
        Resources.copy((URL)Resources.getResource(MUnitNode.class, (String)"/munit_node_resources/munit_node_runner.js"), (OutputStream)new FileOutputStream(new File(workDir, MUNIT_NODE_RUNNER_JS)));
    }

    @Override
    public boolean shouldRunAutomatically() {
        return this.getProject().hasProperty("munit.usenode") && !this.getProject().property("munit.usenode").equals("false");
    }
}

