/*
 * Decompiled with CFR 0.152.
 */
package com.prezi.haxe.gradle.incubating;

import com.prezi.haxe.gradle.incubating.FunctionalSourceSet;
import com.prezi.haxe.gradle.incubating.LanguageSourceSet;
import com.prezi.haxe.gradle.incubating.typeconversion.NotationParser;
import com.prezi.haxe.gradle.incubating.typeconversion.NotationParserBuilder;
import com.prezi.haxe.gradle.incubating.typeconversion.TypeInfo;
import com.prezi.haxe.gradle.incubating.typeconversion.TypedNotationParser;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

public class SourceSetNotationParser {
    public static NotationParser<Object, Set<LanguageSourceSet>> parser() {
        return NotationParserBuilder.toType(new TypeInfo(Set.class)).parser(new FunctionalSourceSetConverter()).parser(new SingleLanguageSourceSetConverter()).parser(new LanguageSourceSetCollectionConverter()).toComposite();
    }

    private static class LanguageSourceSetCollectionConverter
    extends TypedNotationParser<Collection<LanguageSourceSet>, Set<LanguageSourceSet>> {
        private LanguageSourceSetCollectionConverter() {
            super(new TypeInfo(Collection.class));
        }

        @Override
        protected Set<LanguageSourceSet> parseType(Collection<LanguageSourceSet> notation) {
            return new LinkedHashSet<LanguageSourceSet>(notation);
        }
    }

    private static class SingleLanguageSourceSetConverter
    extends TypedNotationParser<LanguageSourceSet, Set<LanguageSourceSet>> {
        private SingleLanguageSourceSetConverter() {
            super(LanguageSourceSet.class);
        }

        @Override
        protected Set<LanguageSourceSet> parseType(LanguageSourceSet notation) {
            return Collections.singleton(notation);
        }
    }

    private static class FunctionalSourceSetConverter
    extends TypedNotationParser<FunctionalSourceSet, Set<LanguageSourceSet>> {
        private FunctionalSourceSetConverter() {
            super(FunctionalSourceSet.class);
        }

        @Override
        protected Set<LanguageSourceSet> parseType(FunctionalSourceSet notation) {
            return notation;
        }
    }
}

