/*
 * Decompiled with CFR 0.152.
 */
package com.prezi.haxe.gradle.incubating.typeconversion;

import com.prezi.haxe.gradle.incubating.typeconversion.NotationConvertResult;
import com.prezi.haxe.gradle.incubating.typeconversion.NotationConverter;
import com.prezi.haxe.gradle.incubating.typeconversion.TypeConversionException;
import java.util.Collection;

class CharSequenceNotationConverter<N, T>
implements NotationConverter<N, T> {
    private final NotationConverter<String, ? extends T> delegate;

    public CharSequenceNotationConverter(NotationConverter<String, ? extends T> delegate) {
        this.delegate = delegate;
    }

    @Override
    public void convert(N notation, NotationConvertResult<? super T> result) throws TypeConversionException {
        if (notation instanceof CharSequence) {
            CharSequence charSequence = (CharSequence)notation;
            this.delegate.convert(charSequence.toString(), result);
        }
    }

    @Override
    public void describe(Collection<String> candidateFormats) {
        this.delegate.describe(candidateFormats);
    }
}

