/*
 * Decompiled with CFR 0.152.
 */
package com.prezi.haxe.gradle.incubating.typeconversion;

import com.prezi.haxe.gradle.incubating.typeconversion.NotationConvertResult;
import com.prezi.haxe.gradle.incubating.typeconversion.NotationConverter;
import com.prezi.haxe.gradle.incubating.typeconversion.TypeConversionException;
import java.util.Collection;
import java.util.List;

public class CompositeNotationConverter<N, T>
implements NotationConverter<N, T> {
    private final List<NotationConverter<N, ? extends T>> converters;

    public CompositeNotationConverter(List<NotationConverter<N, ? extends T>> converters) {
        this.converters = converters;
    }

    @Override
    public void convert(N notation, NotationConvertResult<? super T> result) throws TypeConversionException {
        for (int i = 0; !result.hasResult() && i < this.converters.size(); ++i) {
            NotationConverter<N, T> converter = this.converters.get(i);
            converter.convert(notation, result);
        }
    }

    @Override
    public void describe(Collection<String> candidateFormats) {
        for (NotationConverter<N, T> converter : this.converters) {
            converter.describe(candidateFormats);
        }
    }
}

