/*
 * Decompiled with CFR 0.152.
 */
package com.prezi.haxe.gradle.incubating.typeconversion;

import com.prezi.haxe.gradle.incubating.typeconversion.NotationParser;
import com.prezi.haxe.gradle.incubating.typeconversion.UnsupportedNotationException;
import java.util.Collection;

public class CompositeNotationParser<N, T>
implements NotationParser<N, T> {
    private final Collection<? extends NotationParser<? super N, ? extends T>> delegates;

    public CompositeNotationParser(Collection<? extends NotationParser<? super N, ? extends T>> delegates) {
        assert (delegates != null) : "delegates cannot be null!";
        this.delegates = delegates;
    }

    @Override
    public void describe(Collection<String> candidateFormats) {
        for (NotationParser<N, T> delegate : this.delegates) {
            delegate.describe(candidateFormats);
        }
    }

    @Override
    public T parseNotation(N notation) {
        for (NotationParser<N, T> delegate : this.delegates) {
            try {
                return delegate.parseNotation(notation);
            }
            catch (UnsupportedNotationException e) {
            }
        }
        throw new UnsupportedNotationException(notation);
    }
}

