/*
 * Decompiled with CFR 0.152.
 */
package com.prezi.haxe.gradle.incubating.typeconversion;

import com.prezi.haxe.gradle.incubating.typeconversion.TypeConversionException;
import com.prezi.haxe.gradle.incubating.typeconversion.UnsupportedNotationException;
import com.prezi.haxe.gradle.incubating.typeconversion.ValueAwareNotationParser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.gradle.api.specs.Spec;
import org.gradle.util.CollectionUtils;
import org.gradle.util.GUtil;

public class EnumFromCharSequenceNotationParser<T extends Enum>
implements ValueAwareNotationParser<T> {
    private final Class<? extends T> type;

    public EnumFromCharSequenceNotationParser(Class<? extends T> enumType) {
        assert (enumType.isEnum()) : "resultingType must be enum";
        this.type = enumType;
    }

    @Override
    public T parseNotation(CharSequence notation) throws UnsupportedNotationException, TypeConversionException {
        final String enumString = notation.toString();
        List<T> enumConstants = Arrays.asList(this.type.getEnumConstants());
        Enum match = (Enum)CollectionUtils.findFirst(enumConstants, (Spec)new Spec<T>(){

            public boolean isSatisfiedBy(T enumValue) {
                return ((Enum)enumValue).name().equalsIgnoreCase(enumString);
            }
        });
        if (match == null) {
            throw new TypeConversionException(String.format("Cannot coerce string value '%s' to an enum value of type '%s' (valid case insensitive values: %s)", enumString, this.type.getName(), CollectionUtils.toStringList(Arrays.asList(this.type.getEnumConstants()))));
        }
        return (T)match;
    }

    @Override
    public void describe(Collection<String> candidateFormats) {
        ArrayList<String> values = new ArrayList<String>();
        this.describeValues(values);
        candidateFormats.add(String.format("One of the following values: %s", GUtil.toString(values)));
    }

    @Override
    public void describeValues(Collection<String> collector) {
        Enum[] enumConstants;
        for (Enum enumConstant : enumConstants = (Enum[])this.type.getEnumConstants()) {
            collector.add(enumConstant.name());
        }
    }
}

