/*
 * Decompiled with CFR 0.152.
 */
package com.prezi.haxe.gradle.incubating.typeconversion;

import com.prezi.haxe.gradle.incubating.typeconversion.NotationConvertResult;
import com.prezi.haxe.gradle.incubating.typeconversion.NotationConverter;
import com.prezi.haxe.gradle.incubating.typeconversion.NotationParser;
import com.prezi.haxe.gradle.incubating.typeconversion.TypeConversionException;
import com.prezi.haxe.gradle.incubating.typeconversion.UnsupportedNotationException;
import java.util.Collection;

class NotationConverterToNotationParserAdapter<N, T>
implements NotationParser<N, T> {
    private final NotationConverter<N, ? extends T> converter;

    public NotationConverterToNotationParserAdapter(NotationConverter<N, ? extends T> converter) {
        this.converter = converter;
    }

    @Override
    public T parseNotation(N notation) throws UnsupportedNotationException, TypeConversionException {
        ResultImpl result = new ResultImpl();
        this.converter.convert(notation, result);
        if (!result.hasResult) {
            throw new UnsupportedNotationException(notation);
        }
        return (T)result.result;
    }

    @Override
    public void describe(Collection<String> candidateFormats) {
        this.converter.describe(candidateFormats);
    }

    private static class ResultImpl<T>
    implements NotationConvertResult<T> {
        private boolean hasResult;
        private T result;

        private ResultImpl() {
        }

        @Override
        public boolean hasResult() {
            return this.hasResult;
        }

        @Override
        public void converted(T result) {
            this.hasResult = true;
            this.result = result;
        }
    }
}

