/*
 * Decompiled with CFR 0.152.
 */
package com.prezi.haxe.gradle.incubating.typeconversion;

import com.prezi.haxe.gradle.incubating.typeconversion.CharSequenceNotationConverter;
import com.prezi.haxe.gradle.incubating.typeconversion.CharSequenceNotationParser;
import com.prezi.haxe.gradle.incubating.typeconversion.CompositeNotationConverter;
import com.prezi.haxe.gradle.incubating.typeconversion.ErrorHandlingNotationParser;
import com.prezi.haxe.gradle.incubating.typeconversion.FlatteningNotationParser;
import com.prezi.haxe.gradle.incubating.typeconversion.JustReturningParser;
import com.prezi.haxe.gradle.incubating.typeconversion.NotationConvertResult;
import com.prezi.haxe.gradle.incubating.typeconversion.NotationConverter;
import com.prezi.haxe.gradle.incubating.typeconversion.NotationConverterToNotationParserAdapter;
import com.prezi.haxe.gradle.incubating.typeconversion.NotationParser;
import com.prezi.haxe.gradle.incubating.typeconversion.TypeConversionException;
import com.prezi.haxe.gradle.incubating.typeconversion.TypeFilteringNotationConverter;
import com.prezi.haxe.gradle.incubating.typeconversion.TypeInfo;
import com.prezi.haxe.gradle.incubating.typeconversion.UnsupportedNotationException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Set;

public class NotationParserBuilder<T> {
    private TypeInfo<T> resultingType;
    private String invalidNotationMessage;
    private String typeDisplayName;
    private boolean implicitConverters = true;
    private boolean allowNullInput;
    private final Collection<NotationConverter<Object, ? extends T>> notationParsers = new LinkedList<NotationConverter<Object, ? extends T>>();

    public static <T> NotationParserBuilder<T> toType(Class<T> resultingType) {
        return new NotationParserBuilder(new TypeInfo(resultingType));
    }

    public static <T> NotationParserBuilder<T> toType(TypeInfo<T> resultingType) {
        return new NotationParserBuilder<T>(resultingType);
    }

    private NotationParserBuilder(TypeInfo<T> resultingType) {
        this.resultingType = resultingType;
        this.typeDisplayName = resultingType.getTargetType().equals(String.class) ? "a String" : String.format("an object of type %s", resultingType.getTargetType().getSimpleName());
    }

    public NotationParserBuilder<T> parser(NotationParser<Object, ? extends T> parser) {
        this.notationParsers.add(new NotationParserToNotationConverterAdapter(parser));
        return this;
    }

    public NotationParserBuilder<T> typeDisplayName(String name) {
        this.typeDisplayName = name;
        return this;
    }

    public NotationParserBuilder<T> noImplicitConverters() {
        this.implicitConverters = false;
        return this;
    }

    public NotationParserBuilder<T> allowNullInput() {
        this.allowNullInput = true;
        return this;
    }

    public NotationParserBuilder<T> converter(NotationConverter<Object, ? extends T> converter) {
        this.notationParsers.add(converter);
        return this;
    }

    public <S> NotationParserBuilder<T> fromType(Class<S> notationType, NotationConverter<? super S, ? extends T> converter) {
        this.notationParsers.add(new TypeFilteringNotationConverter(notationType, converter));
        return this;
    }

    public NotationParserBuilder<T> fromCharSequence(NotationConverter<String, ? extends T> converter) {
        this.notationParsers.add(new CharSequenceNotationConverter(converter));
        return this;
    }

    public NotationParserBuilder<T> fromCharSequence() {
        if (!this.resultingType.getTargetType().equals(String.class)) {
            throw new UnsupportedOperationException("Can only convert from CharSequence when the target type is String.");
        }
        CharSequenceNotationParser notationParser = new CharSequenceNotationParser();
        this.fromCharSequence(notationParser);
        return this;
    }

    public NotationParserBuilder<T> invalidNotationMessage(String invalidNotationMessage) {
        this.invalidNotationMessage = invalidNotationMessage;
        return this;
    }

    public NotationParserBuilder<T> parsers(Iterable<? extends NotationParser<Object, ? extends T>> notationParsers) {
        for (NotationParser<Object, T> notationParser : notationParsers) {
            this.parser(notationParser);
        }
        return this;
    }

    public NotationParser<Object, Set<T>> toFlatteningComposite() {
        return this.wrapInErrorHandling(new FlatteningNotationParser<T>(this.create()));
    }

    public NotationParser<Object, T> toComposite() {
        return this.wrapInErrorHandling(this.create());
    }

    private <S> NotationParser<Object, S> wrapInErrorHandling(NotationParser<Object, S> parser) {
        return new ErrorHandlingNotationParser<Object, S>(this.typeDisplayName, this.invalidNotationMessage, this.allowNullInput, parser);
    }

    private NotationParser<Object, T> create() {
        LinkedList composites = new LinkedList();
        if (!this.resultingType.getTargetType().equals(Object.class) && this.implicitConverters) {
            composites.add(new NotationParserToNotationConverterAdapter(new JustReturningParser(this.resultingType.getTargetType())));
        }
        composites.addAll(this.notationParsers);
        return new NotationConverterToNotationParserAdapter(new CompositeNotationConverter(composites));
    }

    private static class NotationParserToNotationConverterAdapter<N, T>
    implements NotationConverter<N, T> {
        private final NotationParser<N, ? extends T> parser;

        private NotationParserToNotationConverterAdapter(NotationParser<N, ? extends T> parser) {
            this.parser = parser;
        }

        @Override
        public void convert(N notation, NotationConvertResult<? super T> result) throws TypeConversionException {
            T t;
            try {
                t = this.parser.parseNotation(notation);
            }
            catch (UnsupportedNotationException e) {
                return;
            }
            result.converted(t);
        }

        @Override
        public void describe(Collection<String> candidateFormats) {
            this.parser.describe(candidateFormats);
        }
    }
}

