/*
 * Decompiled with CFR 0.152.
 */
package com.prezi.haxe.gradle.incubating.typeconversion;

import com.prezi.haxe.gradle.incubating.typeconversion.NotationConvertResult;
import com.prezi.haxe.gradle.incubating.typeconversion.NotationConverter;
import com.prezi.haxe.gradle.incubating.typeconversion.TypeConversionException;
import java.util.Collection;

class TypeFilteringNotationConverter<N, S, T>
implements NotationConverter<N, T> {
    private final Class<S> type;
    private final NotationConverter<? super S, ? extends T> delegate;

    public TypeFilteringNotationConverter(Class<S> type, NotationConverter<? super S, ? extends T> delegate) {
        this.type = type;
        this.delegate = delegate;
    }

    @Override
    public void convert(N notation, NotationConvertResult<? super T> result) throws TypeConversionException {
        if (this.type.isInstance(notation)) {
            this.delegate.convert(this.type.cast(notation), result);
        }
    }

    @Override
    public void describe(Collection<String> candidateFormats) {
        this.delegate.describe(candidateFormats);
    }
}

