/*
 * Decompiled with CFR 0.152.
 */
package com.prezi.haxe.gradle.incubating.typeconversion;

import com.prezi.haxe.gradle.incubating.typeconversion.NotationParser;
import com.prezi.haxe.gradle.incubating.typeconversion.TypeInfo;
import com.prezi.haxe.gradle.incubating.typeconversion.UnsupportedNotationException;
import java.util.Collection;

public abstract class TypedNotationParser<N, T>
implements NotationParser<Object, T> {
    private final Class<N> typeToken;

    public TypedNotationParser(Class<N> typeToken) {
        assert (typeToken != null) : "typeToken cannot be null";
        this.typeToken = typeToken;
    }

    public TypedNotationParser(TypeInfo<N> typeToken) {
        assert (typeToken != null) : "typeToken cannot be null";
        this.typeToken = typeToken.getTargetType();
    }

    @Override
    public void describe(Collection<String> candidateFormats) {
        candidateFormats.add(String.format("Instances of %s.", this.typeToken.getSimpleName()));
    }

    @Override
    public T parseNotation(Object notation) {
        if (!this.typeToken.isInstance(notation)) {
            throw new UnsupportedNotationException(notation);
        }
        return this.parseType(this.typeToken.cast(notation));
    }

    protected abstract T parseType(N var1);
}

