/*
 * Decompiled with CFR 0.152.
 */
package com.princexml.wrapper;

import com.princexml.wrapper.CommandLine;
import com.princexml.wrapper.FileAttachment;
import com.princexml.wrapper.enums.AuthMethod;
import com.princexml.wrapper.enums.AuthScheme;
import com.princexml.wrapper.enums.InputType;
import com.princexml.wrapper.enums.KeyBits;
import com.princexml.wrapper.enums.PdfEvent;
import com.princexml.wrapper.enums.PdfProfile;
import com.princexml.wrapper.enums.SslType;
import com.princexml.wrapper.enums.SslVersion;
import com.princexml.wrapper.events.MessageType;
import com.princexml.wrapper.events.PrinceEvents;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

abstract class AbstractPrince {
    private final String princePath;
    private final PrinceEvents events;
    private boolean verbose;
    private boolean debug;
    private String log;
    private boolean noWarnCssUnknown;
    private boolean noWarnCssUnsupported;
    protected InputType inputType;
    protected String baseUrl;
    protected boolean iframes;
    protected boolean xInclude;
    protected boolean xmlExternalEntities;
    private boolean noNetwork;
    private boolean noRedirects;
    private String authUser;
    private String authPassword;
    private String authServer;
    private AuthScheme authScheme;
    private final List<AuthMethod> authMethods = new ArrayList<AuthMethod>();
    private boolean noAuthPreemptive;
    private String httpProxy;
    private int httpTimeout;
    private final List<String> cookies = new ArrayList<String>();
    private String cookieJar;
    private String sslCaCert;
    private String sslCaPath;
    private String sslCert;
    private SslType sslCertType;
    private String sslKey;
    private SslType sslKeyType;
    private String sslKeyPassword;
    private SslVersion sslVersion;
    private boolean insecure;
    private boolean noParallelDownloads;
    protected boolean javaScript;
    protected final List<String> scripts = new ArrayList<String>();
    protected int maxPasses;
    protected final List<String> styleSheets = new ArrayList<String>();
    protected String media;
    protected boolean noAuthorStyle;
    protected boolean noDefaultStyle;
    protected String pdfId;
    protected String pdfLang;
    protected PdfProfile pdfProfile;
    protected String pdfOutputIntent;
    protected String pdfScript;
    protected Map<PdfEvent, String> pdfEventScripts = new HashMap<PdfEvent, String>();
    protected final List<FileAttachment> fileAttachments = new ArrayList<FileAttachment>();
    protected boolean noArtificialFonts;
    protected boolean noEmbedFonts;
    protected boolean noSubsetFonts;
    protected boolean forceIdentityEncoding;
    protected boolean noCompress;
    protected boolean noObjectStreams;
    protected boolean convertColors;
    protected String fallbackCmykProfile;
    protected boolean taggedPdf;
    protected boolean pdfForms;
    protected String pdfTitle;
    protected String pdfSubject;
    protected String pdfAuthor;
    protected String pdfKeywords;
    protected String pdfCreator;
    protected String xmp;
    protected boolean encrypt;
    protected KeyBits keyBits;
    protected String userPassword;
    protected String ownerPassword;
    protected boolean disallowPrint;
    protected boolean disallowCopy;
    protected boolean allowCopyForAccessibility;
    protected boolean disallowAnnotate;
    protected boolean disallowModify;
    protected boolean allowAssembly;
    private String licenseFile;
    private String licenseKey;
    private boolean failDroppedContent;
    private boolean failMissingResources;
    private boolean failStrippedTransparency;
    private boolean failMissingGlyphs;
    private boolean failPdfProfileError;
    private boolean failPdfTagError;
    private boolean failInvalidLicense;

    protected AbstractPrince(String princePath) {
        this(princePath, null);
    }

    protected AbstractPrince(String princePath, PrinceEvents events) {
        this.princePath = princePath;
        this.events = events;
    }

    public abstract boolean convert(String var1, OutputStream var2) throws IOException;

    public abstract boolean convert(List<String> var1, OutputStream var2) throws IOException;

    public abstract boolean convert(InputStream var1, OutputStream var2) throws IOException;

    public abstract boolean convertString(String var1, OutputStream var2) throws IOException;

    protected List<String> getBaseCommandLine() {
        ArrayList<String> cmdLine = new ArrayList<String>();
        cmdLine.add(this.princePath);
        if (this.verbose) {
            cmdLine.add(CommandLine.toCommand("verbose"));
        }
        if (this.debug) {
            cmdLine.add(CommandLine.toCommand("debug"));
        }
        if (this.log != null) {
            cmdLine.add(CommandLine.toCommand("log", this.log));
        }
        if (this.noWarnCssUnknown) {
            cmdLine.add(CommandLine.toCommand("no-warn-css-unknown"));
        }
        if (this.noWarnCssUnsupported) {
            cmdLine.add(CommandLine.toCommand("no-warn-css-unsupported"));
        }
        if (this.noNetwork) {
            cmdLine.add(CommandLine.toCommand("no-network"));
        }
        if (this.noRedirects) {
            cmdLine.add(CommandLine.toCommand("no-redirects"));
        }
        if (this.authUser != null) {
            cmdLine.add(CommandLine.toCommand("auth-user", this.authUser));
        }
        if (this.authPassword != null) {
            cmdLine.add(CommandLine.toCommand("auth-password", this.authPassword));
        }
        if (this.authServer != null) {
            cmdLine.add(CommandLine.toCommand("auth-server", this.authServer));
        }
        if (this.authScheme != null) {
            cmdLine.add(CommandLine.toCommand("auth-scheme", this.authScheme));
        }
        if (!this.authMethods.isEmpty()) {
            cmdLine.add(CommandLine.toCommand("auth-method", this.authMethods));
        }
        if (this.noAuthPreemptive) {
            cmdLine.add(CommandLine.toCommand("no-auth-preemptive"));
        }
        if (this.httpProxy != null) {
            cmdLine.add(CommandLine.toCommand("http-proxy", this.httpProxy));
        }
        if (this.httpTimeout > 0) {
            cmdLine.add(CommandLine.toCommand("http-timeout", this.httpTimeout));
        }
        if (!this.cookies.isEmpty()) {
            cmdLine.addAll(CommandLine.toCommands("cookie", this.cookies));
        }
        if (this.cookieJar != null) {
            cmdLine.add(CommandLine.toCommand("cookiejar", this.cookieJar));
        }
        if (this.sslCaCert != null) {
            cmdLine.add(CommandLine.toCommand("ssl-cacert", this.sslCaCert));
        }
        if (this.sslCaPath != null) {
            cmdLine.add(CommandLine.toCommand("ssl-capath", this.sslCaPath));
        }
        if (this.sslCert != null) {
            cmdLine.add(CommandLine.toCommand("ssl-cert", this.sslCert));
        }
        if (this.sslCertType != null) {
            cmdLine.add(CommandLine.toCommand("ssl-cert-type", this.sslCertType));
        }
        if (this.sslKey != null) {
            cmdLine.add(CommandLine.toCommand("ssl-key", this.sslKey));
        }
        if (this.sslKeyType != null) {
            cmdLine.add(CommandLine.toCommand("ssl-key-type", this.sslKeyType));
        }
        if (this.sslKeyPassword != null) {
            cmdLine.add(CommandLine.toCommand("ssl-key-password", this.sslKeyPassword));
        }
        if (this.sslVersion != null) {
            cmdLine.add(CommandLine.toCommand("ssl-version", this.sslVersion));
        }
        if (this.insecure) {
            cmdLine.add(CommandLine.toCommand("insecure"));
        }
        if (this.noParallelDownloads) {
            cmdLine.add(CommandLine.toCommand("no-parallel-downloads"));
        }
        if (this.licenseFile != null) {
            cmdLine.add(CommandLine.toCommand("license-file", this.licenseFile));
        }
        if (this.licenseKey != null) {
            cmdLine.add(CommandLine.toCommand("license-key", this.licenseKey));
        }
        if (this.failDroppedContent) {
            cmdLine.add(CommandLine.toCommand("fail-dropped-content"));
        }
        if (this.failMissingResources) {
            cmdLine.add(CommandLine.toCommand("fail-missing-resources"));
        }
        if (this.failStrippedTransparency) {
            cmdLine.add(CommandLine.toCommand("fail-stripped-transparency"));
        }
        if (this.failMissingGlyphs) {
            cmdLine.add(CommandLine.toCommand("fail-missing-glyphs"));
        }
        if (this.failPdfProfileError) {
            cmdLine.add(CommandLine.toCommand("fail-pdf-profile-error"));
        }
        if (this.failPdfTagError) {
            cmdLine.add(CommandLine.toCommand("fail-pdf-tag-error"));
        }
        if (this.failInvalidLicense) {
            cmdLine.add(CommandLine.toCommand("fail-invalid-license"));
        }
        return cmdLine;
    }

    protected boolean readMessages(BufferedReader reader) throws IOException {
        String result = "";
        String line = reader.readLine();
        while (line != null) {
            String[] tokens = line.split("\\|", 2);
            if (tokens.length == 2) {
                String msgTag = tokens[0];
                String msgBody = tokens[1];
                switch (msgTag) {
                    case "msg": {
                        if (this.events == null) break;
                        this.handleMessage(msgBody);
                        break;
                    }
                    case "dat": {
                        if (this.events == null) break;
                        this.handleDataMessage(msgBody);
                        break;
                    }
                    case "fin": {
                        result = msgBody;
                    }
                }
            } else {
                this.handleNonStructuredMessage(line);
            }
            line = reader.readLine();
        }
        return result.equals("success");
    }

    private void handleMessage(String msgBody) {
        if (this.events == null) {
            return;
        }
        String[] tokens = msgBody.split("\\|", 3);
        if (tokens.length == 3) {
            MessageType msgType = MessageType.valueOf(tokens[0].toUpperCase());
            String msgLocation = tokens[1];
            String msgText = tokens[2];
            this.events.onMessage(msgType, msgLocation, msgText);
        }
    }

    private void handleDataMessage(String msgBody) {
        if (this.events == null) {
            return;
        }
        String[] tokens = msgBody.split("\\|", 2);
        if (tokens.length == 2) {
            String name = tokens[0];
            String value = tokens[1];
            this.events.onDataMessage(name, value);
        }
    }

    private void handleNonStructuredMessage(String msg) {
        if (this.events == null) {
            return;
        }
        String princeWrn = "prince: warning: ";
        String princeErr = "prince: error: ";
        if (msg.startsWith(princeWrn)) {
            String msgText = msg.substring(princeWrn.length());
            this.events.onMessage(MessageType.WRN, "", msgText);
        } else if (msg.startsWith(princeErr)) {
            String msgText = msg.substring(princeErr.length());
            this.events.onMessage(MessageType.ERR, "", msgText);
        } else {
            this.events.onMessage(MessageType.DBG, "", msg);
        }
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setLog(String log) {
        this.log = log;
    }

    public void setNoWarnCssUnknown(boolean noWarnCssUnknown) {
        this.noWarnCssUnknown = noWarnCssUnknown;
    }

    public void setNoWarnCssUnsupported(boolean noWarnCssUnsupported) {
        this.noWarnCssUnsupported = noWarnCssUnsupported;
    }

    public void setInputType(InputType inputType) {
        this.inputType = inputType;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public void setIframes(boolean iframes) {
        this.iframes = iframes;
    }

    public void setXInclude(boolean xInclude) {
        this.xInclude = xInclude;
    }

    public void setXmlExternalEntities(boolean xmlExternalEntities) {
        this.xmlExternalEntities = xmlExternalEntities;
    }

    public void setNoNetwork(boolean noNetwork) {
        this.noNetwork = noNetwork;
    }

    public void setNoRedirects(boolean noRedirects) {
        this.noRedirects = noRedirects;
    }

    public void setAuthUser(String authUser) {
        this.authUser = authUser;
    }

    public void setAuthPassword(String authPassword) {
        this.authPassword = authPassword;
    }

    public void setAuthServer(String authServer) {
        this.authServer = authServer;
    }

    public void setAuthScheme(AuthScheme authScheme) {
        this.authScheme = authScheme;
    }

    public void addAuthMethod(AuthMethod authMethod) {
        this.authMethods.add(authMethod);
    }

    public void clearAuthMethods() {
        this.authMethods.clear();
    }

    public void setNoAuthPreemptive(boolean noAuthPreemptive) {
        this.noAuthPreemptive = noAuthPreemptive;
    }

    public void setHttpProxy(String httpProxy) {
        this.httpProxy = httpProxy;
    }

    public void setHttpTimeout(int httpTimeout) {
        if (httpTimeout < 1) {
            throw new IllegalArgumentException("invalid httpTimeout value (must be > 0)");
        }
        this.httpTimeout = httpTimeout;
    }

    public void addCookie(String cookie) {
        this.cookies.add(cookie);
    }

    public void clearCookies() {
        this.cookies.clear();
    }

    public void setCookieJar(String cookieJar) {
        this.cookieJar = cookieJar;
    }

    public void setSslCaCert(String sslCaCert) {
        this.sslCaCert = sslCaCert;
    }

    public void setSslCaPath(String sslCaPath) {
        this.sslCaPath = sslCaPath;
    }

    public void setSslCert(String sslCert) {
        this.sslCert = sslCert;
    }

    public void setSslCertType(SslType sslCertType) {
        this.sslCertType = sslCertType;
    }

    public void setSslKey(String sslKey) {
        this.sslKey = sslKey;
    }

    public void setSslKeyType(SslType sslKeyType) {
        this.sslKeyType = sslKeyType;
    }

    public void setSslKeyPassword(String sslKeyPassword) {
        this.sslKeyPassword = sslKeyPassword;
    }

    public void setSslVersion(SslVersion sslVersion) {
        this.sslVersion = sslVersion;
    }

    public void setInsecure(boolean insecure) {
        this.insecure = insecure;
    }

    public void setNoParallelDownloads(boolean noParallelDownloads) {
        this.noParallelDownloads = noParallelDownloads;
    }

    public void setJavaScript(boolean javaScript) {
        this.javaScript = javaScript;
    }

    public void addScript(String script) {
        this.scripts.add(script);
    }

    public void clearScripts() {
        this.scripts.clear();
    }

    public void setMaxPasses(int maxPasses) {
        if (maxPasses < 1) {
            throw new IllegalArgumentException("invalid maxPasses value (must be > 0)");
        }
        this.maxPasses = maxPasses;
    }

    public void addStyleSheet(String styleSheet) {
        this.styleSheets.add(styleSheet);
    }

    public void clearStyleSheets() {
        this.styleSheets.clear();
    }

    public void setMedia(String media) {
        this.media = media;
    }

    public void setNoAuthorStyle(boolean noAuthorStyle) {
        this.noAuthorStyle = noAuthorStyle;
    }

    public void setNoDefaultStyle(boolean noDefaultStyle) {
        this.noDefaultStyle = noDefaultStyle;
    }

    public void setPdfId(String pdfId) {
        this.pdfId = pdfId;
    }

    public void setPdfLang(String pdfLang) {
        this.pdfLang = pdfLang;
    }

    public void setPdfProfile(PdfProfile pdfProfile) {
        this.pdfProfile = pdfProfile;
    }

    public void setPdfOutputIntent(String pdfOutputIntent) {
        this.pdfOutputIntent = pdfOutputIntent;
    }

    public void setPdfScript(String pdfScript) {
        this.pdfScript = pdfScript;
    }

    public void addPdfEventScript(PdfEvent pdfEvent, String pdfScript) {
        this.pdfEventScripts.put(pdfEvent, pdfScript);
    }

    public void clearPdfEventScripts() {
        this.pdfEventScripts.clear();
    }

    public void addFileAttachment(String fileAttachment) {
        this.fileAttachments.add(new FileAttachment(fileAttachment));
    }

    public void clearFileAttachments() {
        this.fileAttachments.clear();
    }

    public void setNoArtificialFonts(boolean noArtificialFonts) {
        this.noArtificialFonts = noArtificialFonts;
    }

    public void setNoEmbedFonts(boolean noEmbedFonts) {
        this.noEmbedFonts = noEmbedFonts;
    }

    public void setNoSubsetFonts(boolean noSubsetFonts) {
        this.noSubsetFonts = noSubsetFonts;
    }

    public void setForceIdentityEncoding(boolean forceIdentityEncoding) {
        this.forceIdentityEncoding = forceIdentityEncoding;
    }

    public void setNoCompress(boolean noCompress) {
        this.noCompress = noCompress;
    }

    public void setNoObjectStreams(boolean noObjectStreams) {
        this.noObjectStreams = noObjectStreams;
    }

    public void setConvertColors(boolean convertColors) {
        this.convertColors = convertColors;
    }

    public void setFallbackCmykProfile(String fallbackCmykProfile) {
        this.fallbackCmykProfile = fallbackCmykProfile;
    }

    public void setTaggedPdf(boolean taggedPdf) {
        this.taggedPdf = taggedPdf;
    }

    public void setPdfForms(boolean pdfForms) {
        this.pdfForms = pdfForms;
    }

    public void setPdfTitle(String pdfTitle) {
        this.pdfTitle = pdfTitle;
    }

    public void setPdfSubject(String pdfSubject) {
        this.pdfSubject = pdfSubject;
    }

    public void setPdfAuthor(String pdfAuthor) {
        this.pdfAuthor = pdfAuthor;
    }

    public void setPdfKeywords(String pdfKeywords) {
        this.pdfKeywords = pdfKeywords;
    }

    public void setPdfCreator(String pdfCreator) {
        this.pdfCreator = pdfCreator;
    }

    public void setXmp(String xmp) {
        this.xmp = xmp;
    }

    public void setEncrypt(boolean encrypt) {
        this.encrypt = encrypt;
    }

    public void setKeyBits(KeyBits keyBits) {
        this.keyBits = keyBits;
    }

    public void setUserPassword(String userPassword) {
        this.userPassword = userPassword;
    }

    public void setOwnerPassword(String ownerPassword) {
        this.ownerPassword = ownerPassword;
    }

    public void setDisallowPrint(boolean disallowPrint) {
        this.disallowPrint = disallowPrint;
    }

    public void setDisallowCopy(boolean disallowCopy) {
        this.disallowCopy = disallowCopy;
    }

    public void setAllowCopyForAccessibility(boolean allowCopyForAccessibility) {
        this.allowCopyForAccessibility = allowCopyForAccessibility;
    }

    public void setDisallowAnnotate(boolean disallowAnnotate) {
        this.disallowAnnotate = disallowAnnotate;
    }

    public void setDisallowModify(boolean disallowModify) {
        this.disallowModify = disallowModify;
    }

    public void setAllowAssembly(boolean allowAssembly) {
        this.allowAssembly = allowAssembly;
    }

    public void setLicenseFile(String licenseFile) {
        this.licenseFile = licenseFile;
    }

    public void setLicenseKey(String licenseKey) {
        this.licenseKey = licenseKey;
    }

    public void setFailDroppedContent(boolean failDroppedContent) {
        this.failDroppedContent = failDroppedContent;
    }

    public void setFailMissingResources(boolean failMissingResources) {
        this.failMissingResources = failMissingResources;
    }

    public void setFailStrippedTransparency(boolean failStrippedTransparency) {
        this.failStrippedTransparency = failStrippedTransparency;
    }

    public void setFailMissingGlyphs(boolean failMissingGlyphs) {
        this.failMissingGlyphs = failMissingGlyphs;
    }

    public void setFailPdfProfileError(boolean failPdfProfileError) {
        this.failPdfProfileError = failPdfProfileError;
    }

    public void setFailPdfTagError(boolean failPdfTagError) {
        this.failPdfTagError = failPdfTagError;
    }

    public void setFailInvalidLicense(boolean failInvalidLicense) {
        this.failInvalidLicense = failInvalidLicense;
    }

    public void setFailSafe(boolean failSafe) {
        this.failDroppedContent = failSafe;
        this.failMissingResources = failSafe;
        this.failStrippedTransparency = failSafe;
        this.failMissingGlyphs = failSafe;
        this.failPdfProfileError = failSafe;
        this.failPdfTagError = failSafe;
        this.failInvalidLicense = failSafe;
    }
}

