/*
 * Decompiled with CFR 0.152.
 */
package com.princexml.wrapper;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;

final class Chunk {
    private final String tag;
    private final byte[] bytes;

    Chunk(String tag, byte[] bytes) {
        this.tag = tag;
        this.bytes = bytes;
    }

    String getTag() {
        return this.tag;
    }

    byte[] getBytes() {
        return this.bytes;
    }

    String getString() {
        return new String(this.bytes, StandardCharsets.UTF_8);
    }

    static Chunk readChunk(InputStream in) throws IOException {
        int b;
        int num_length;
        byte[] tagBytes = new byte[3];
        if (!Chunk.readBytes(in, tagBytes)) {
            throw new IOException("failed to read chunk tag");
        }
        String tag = new String(tagBytes, StandardCharsets.US_ASCII);
        if (in.read() != 32) {
            throw new IOException("expected space after chunk tag");
        }
        int length = 0;
        int max_num_length = 9;
        for (num_length = 0; num_length < max_num_length + 1 && (b = in.read()) != 10; ++num_length) {
            if (b < 48 || b > 57) {
                throw new IOException("unexpected character in chunk length");
            }
            length *= 10;
            length += b - 48;
        }
        if (num_length < 1 || num_length > max_num_length) {
            throw new IOException("invalid chunk length");
        }
        byte[] dataBytes = new byte[length];
        if (!Chunk.readBytes(in, dataBytes)) {
            throw new IOException("failed to read chunk data");
        }
        if (in.read() != 10) {
            throw new IOException("expected newline after chunk data");
        }
        return new Chunk(tag, dataBytes);
    }

    static boolean readBytes(InputStream in, byte[] buf) throws IOException {
        int length = buf.length;
        int offset = 0;
        while (length > 0) {
            int count = in.read(buf, offset, length);
            if (count < 0) {
                return false;
            }
            if (count > length) {
                throw new IOException("unexpected read overrun");
            }
            length -= count;
            offset += count;
        }
        return true;
    }

    static void writeChunk(OutputStream out, String tag, String data) throws IOException {
        Chunk.writeChunk(out, tag, data.getBytes(StandardCharsets.UTF_8));
    }

    static void writeChunk(OutputStream out, String tag, byte[] data) throws IOException {
        String s = tag + " " + data.length + "\n";
        out.write(s.getBytes(StandardCharsets.UTF_8));
        out.write(data);
        out.write(10);
    }
}

