/*
 * Decompiled with CFR 0.152.
 */
package com.princexml.wrapper;

final class Json {
    private final StringBuilder builder = new StringBuilder();
    private boolean comma;

    Json() {
    }

    Json beginObj() {
        return this.beginObj(null);
    }

    Json beginObj(String name) {
        this.maybeAppendComma();
        if (name != null) {
            this.builder.append(this.quoteAndEscape(name));
            this.builder.append(':');
        }
        this.builder.append('{');
        this.comma = false;
        return this;
    }

    Json endObj() {
        this.builder.append('}');
        this.comma = true;
        return this;
    }

    Json beginList(String name) {
        this.maybeAppendComma();
        this.builder.append(this.quoteAndEscape(name));
        this.builder.append(':');
        this.builder.append('[');
        this.comma = false;
        return this;
    }

    Json endList() {
        this.builder.append(']');
        this.comma = true;
        return this;
    }

    Json field(String name) {
        this.maybeAppendComma();
        this.builder.append(this.quoteAndEscape(name));
        this.builder.append(':');
        this.comma = false;
        return this;
    }

    Json field(String name, String value) {
        return this.field(name).value(value);
    }

    Json field(String name, int value) {
        return this.field(name).value(value);
    }

    Json field(String name, boolean value) {
        return this.field(name).value(value);
    }

    Json value(String value) {
        return this.valueInternal(this.quoteAndEscape(value));
    }

    Json value(int value) {
        return this.valueInternal(value);
    }

    Json value(boolean value) {
        return this.valueInternal(value);
    }

    private <T> Json valueInternal(T value) {
        this.maybeAppendComma();
        this.builder.append(value);
        this.comma = true;
        return this;
    }

    public String toString() {
        return this.builder.toString();
    }

    private String quoteAndEscape(String s) {
        String escaped = s.replace("\\", "\\\\").replace("\"", "\\\"");
        return '\"' + escaped + '\"';
    }

    private void maybeAppendComma() {
        if (this.comma) {
            this.builder.append(',');
        }
    }
}

