/*
 * Decompiled with CFR 0.152.
 */
package com.princexml.wrapper;

import com.princexml.wrapper.AbstractPrince;
import com.princexml.wrapper.CommandLine;
import com.princexml.wrapper.Pair;
import com.princexml.wrapper.Util;
import com.princexml.wrapper.enums.InputType;
import com.princexml.wrapper.enums.RasterBackground;
import com.princexml.wrapper.enums.RasterFormat;
import com.princexml.wrapper.events.PrinceEvents;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class Prince
extends AbstractPrince {
    private final List<String> remaps = new ArrayList<String>();
    private boolean noLocalFiles;
    private String pageSize;
    private String pageMargin;
    private boolean noSystemFonts;
    private int cssDpi;
    private RasterFormat rasterFormat;
    private int rasterJpegQuality = -1;
    private int rasterPage;
    private int rasterDpi;
    private int rasterThreads = -1;
    private RasterBackground rasterBackground;
    private final List<Pair> options = new ArrayList<Pair>();

    public Prince(String princePath) {
        super(princePath);
    }

    public Prince(String princePath, PrinceEvents events) {
        super(princePath, events);
    }

    public boolean convert(String inputPath) throws IOException {
        return this.convertInternal(Collections.singletonList(inputPath), null);
    }

    public boolean convert(String inputPath, String outputPath) throws IOException {
        return this.convertInternal(Collections.singletonList(inputPath), outputPath);
    }

    public boolean convert(List<String> inputPaths, String outputPath) throws IOException {
        return this.convertInternal(inputPaths, outputPath);
    }

    private boolean convertInternal(List<String> inputPaths, String outputPath) throws IOException {
        List<String> cmdLine = this.getJobCommandLine("normal");
        cmdLine.addAll(inputPaths);
        if (outputPath != null) {
            cmdLine.add(CommandLine.toCommand("output", outputPath));
        }
        Process process = Util.invokeProcess(cmdLine);
        return this.readMessagesFromStderr(process);
    }

    @Override
    public boolean convert(String inputPath, OutputStream output) throws IOException {
        return this.convert(Collections.singletonList(inputPath), output);
    }

    @Override
    public boolean convert(List<String> inputPaths, OutputStream output) throws IOException {
        List<String> cmdLine = this.getJobCommandLine("buffered");
        cmdLine.addAll(inputPaths);
        cmdLine.add(CommandLine.toCommand("output", "-"));
        Process process = Util.invokeProcess(cmdLine);
        try (InputStream fromPrince = process.getInputStream();){
            Util.copyInputToOutput(fromPrince, output);
        }
        return this.readMessagesFromStderr(process);
    }

    @Override
    public boolean convert(InputStream input, OutputStream output) throws IOException {
        if (this.inputType == null || this.inputType == InputType.AUTO) {
            throw new RuntimeException("inputType has to be set to XML or HTML");
        }
        List<String> cmdLine = this.getJobCommandLine("buffered");
        cmdLine.add("-");
        Process process = Util.invokeProcess(cmdLine);
        try (OutputStream toPrince = process.getOutputStream();){
            Util.copyInputToOutput(input, toPrince);
        }
        var6_6 = null;
        try (InputStream fromPrince = process.getInputStream();){
            Util.copyInputToOutput(fromPrince, output);
        }
        catch (Throwable throwable) {
            var6_6 = throwable;
            throw throwable;
        }
        return this.readMessagesFromStderr(process);
    }

    public boolean convertString(String input, String outputPath) throws IOException {
        if (this.inputType == null || this.inputType == InputType.AUTO) {
            throw new RuntimeException("inputType has to be set to XML or HTML");
        }
        List<String> cmdLine = this.getJobCommandLine("buffered");
        cmdLine.add(CommandLine.toCommand("output", outputPath));
        cmdLine.add("-");
        Process process = Util.invokeProcess(cmdLine);
        try (OutputStream toPrince = process.getOutputStream();){
            toPrince.write(input.getBytes(StandardCharsets.UTF_8));
        }
        return this.readMessagesFromStderr(process);
    }

    @Override
    public boolean convertString(String input, OutputStream output) throws IOException {
        try (ByteArrayInputStream in = new ByteArrayInputStream(input.getBytes(StandardCharsets.UTF_8));){
            boolean bl = this.convert(in, output);
            return bl;
        }
    }

    public boolean rasterize(String inputPath, String outputPath) throws IOException {
        return this.rasterizeInternal(Collections.singletonList(inputPath), outputPath);
    }

    public boolean rasterize(List<String> inputPaths, String outputPath) throws IOException {
        return this.rasterizeInternal(inputPaths, outputPath);
    }

    private boolean rasterizeInternal(List<String> inputPaths, String outputPath) throws IOException {
        List<String> cmdLine = this.getJobCommandLine("normal");
        cmdLine.addAll(inputPaths);
        cmdLine.add(CommandLine.toCommand("raster-output", outputPath));
        Process process = Util.invokeProcess(cmdLine);
        return this.readMessagesFromStderr(process);
    }

    public boolean rasterize(String inputPath, OutputStream output) throws IOException {
        return this.rasterize(Collections.singletonList(inputPath), output);
    }

    public boolean rasterize(List<String> inputPaths, OutputStream output) throws IOException {
        if (this.rasterPage < 1) {
            throw new RuntimeException("rasterPage has to be set to a value > 0");
        }
        if (this.rasterFormat == null || this.rasterFormat == RasterFormat.AUTO) {
            throw new RuntimeException("rasterFormat has to be set to JPEG or PNG");
        }
        List<String> cmdLine = this.getJobCommandLine("buffered");
        cmdLine.addAll(inputPaths);
        cmdLine.add(CommandLine.toCommand("raster-output", "-"));
        Process process = Util.invokeProcess(cmdLine);
        try (InputStream fromPrince = process.getInputStream();){
            Util.copyInputToOutput(fromPrince, output);
        }
        return this.readMessagesFromStderr(process);
    }

    public boolean rasterize(InputStream input, OutputStream output) throws IOException {
        if (this.inputType == null || this.inputType == InputType.AUTO) {
            throw new RuntimeException("inputType has to be set to XML or HTML");
        }
        if (this.rasterPage < 1) {
            throw new RuntimeException("rasterPage has to be set to a value > 0");
        }
        if (this.rasterFormat == null || this.rasterFormat == RasterFormat.AUTO) {
            throw new RuntimeException("rasterFormat has to be set to JPEG or PNG");
        }
        List<String> cmdLine = this.getJobCommandLine("buffered");
        cmdLine.add(CommandLine.toCommand("raster-output", "-"));
        cmdLine.add("-");
        Process process = Util.invokeProcess(cmdLine);
        try (OutputStream toPrince = process.getOutputStream();){
            Util.copyInputToOutput(input, toPrince);
        }
        var6_6 = null;
        try (InputStream fromPrince = process.getInputStream();){
            Util.copyInputToOutput(fromPrince, output);
        }
        catch (Throwable throwable) {
            var6_6 = throwable;
            throw throwable;
        }
        return this.readMessagesFromStderr(process);
    }

    public boolean rasterizeString(String input, String outputPath) throws IOException {
        if (this.inputType == null || this.inputType == InputType.AUTO) {
            throw new RuntimeException("inputType has to be set to XML or HTML");
        }
        List<String> cmdLine = this.getJobCommandLine("buffered");
        cmdLine.add(CommandLine.toCommand("raster-output", outputPath));
        cmdLine.add("-");
        Process process = Util.invokeProcess(cmdLine);
        try (OutputStream toPrince = process.getOutputStream();){
            toPrince.write(input.getBytes(StandardCharsets.UTF_8));
        }
        return this.readMessagesFromStderr(process);
    }

    public boolean rasterizeString(String input, OutputStream output) throws IOException {
        try (ByteArrayInputStream in = new ByteArrayInputStream(input.getBytes(StandardCharsets.UTF_8));){
            boolean bl = this.rasterize(in, output);
            return bl;
        }
    }

    private List<String> getJobCommandLine(String logType) {
        List<String> cmdLine = this.getBaseCommandLine();
        cmdLine.add(CommandLine.toCommand("structured-log", logType));
        if (this.inputType != null) {
            cmdLine.add(CommandLine.toCommand("input", this.inputType));
        }
        if (this.baseUrl != null) {
            cmdLine.add(CommandLine.toCommand("baseurl", this.baseUrl));
        }
        if (!this.remaps.isEmpty()) {
            cmdLine.addAll(CommandLine.toCommands("remap", this.remaps));
        }
        if (this.iframes) {
            cmdLine.add(CommandLine.toCommand("iframes"));
        }
        if (this.xInclude) {
            cmdLine.add(CommandLine.toCommand("xinclude"));
        }
        if (this.xmlExternalEntities) {
            cmdLine.add(CommandLine.toCommand("xml-external-entities"));
        }
        if (this.noLocalFiles) {
            cmdLine.add(CommandLine.toCommand("no-local-files"));
        }
        if (this.javaScript) {
            cmdLine.add(CommandLine.toCommand("javascript"));
        }
        if (!this.scripts.isEmpty()) {
            cmdLine.addAll(CommandLine.toCommands("script", this.scripts));
        }
        if (this.maxPasses > 0) {
            cmdLine.add(CommandLine.toCommand("max-passes", this.maxPasses));
        }
        if (!this.styleSheets.isEmpty()) {
            cmdLine.addAll(CommandLine.toCommands("style", this.styleSheets));
        }
        if (this.media != null) {
            cmdLine.add(CommandLine.toCommand("media", this.media));
        }
        if (this.pageSize != null) {
            cmdLine.add(CommandLine.toCommand("page-size", this.pageSize));
        }
        if (this.pageMargin != null) {
            cmdLine.add(CommandLine.toCommand("page-margin", this.pageMargin));
        }
        if (this.noAuthorStyle) {
            cmdLine.add(CommandLine.toCommand("no-author-style"));
        }
        if (this.noDefaultStyle) {
            cmdLine.add(CommandLine.toCommand("no-default-style"));
        }
        if (this.pdfId != null) {
            cmdLine.add(CommandLine.toCommand("pdf-id", this.pdfId));
        }
        if (this.pdfLang != null) {
            cmdLine.add(CommandLine.toCommand("pdf-lang", this.pdfLang));
        }
        if (this.pdfProfile != null) {
            cmdLine.add(CommandLine.toCommand("pdf-profile", this.pdfProfile));
        }
        if (this.pdfOutputIntent != null) {
            cmdLine.add(CommandLine.toCommand("pdf-output-intent", this.pdfOutputIntent));
        }
        if (this.pdfScript != null) {
            cmdLine.add(CommandLine.toCommand("pdf-script", this.pdfScript));
        }
        this.pdfEventScripts.forEach((k, v) -> cmdLine.add(CommandLine.toCommand("pdf-event-script", (Object)k + ":" + v)));
        if (!this.fileAttachments.isEmpty()) {
            cmdLine.addAll(CommandLine.toCommands("attach", this.fileAttachments.stream().map(a -> a.url).collect(Collectors.toList())));
        }
        if (this.noArtificialFonts) {
            cmdLine.add(CommandLine.toCommand("no-artificial-fonts"));
        }
        if (this.noEmbedFonts) {
            cmdLine.add(CommandLine.toCommand("no-embed-fonts"));
        }
        if (this.noSubsetFonts) {
            cmdLine.add(CommandLine.toCommand("no-subset-fonts"));
        }
        if (this.noSystemFonts) {
            cmdLine.add(CommandLine.toCommand("no-system-fonts"));
        }
        if (this.forceIdentityEncoding) {
            cmdLine.add(CommandLine.toCommand("force-identity-encoding"));
        }
        if (this.noCompress) {
            cmdLine.add(CommandLine.toCommand("no-compress"));
        }
        if (this.noObjectStreams) {
            cmdLine.add(CommandLine.toCommand("no-object-streams"));
        }
        if (this.convertColors) {
            cmdLine.add(CommandLine.toCommand("convert-colors"));
        }
        if (this.fallbackCmykProfile != null) {
            cmdLine.add(CommandLine.toCommand("fallback-cmyk-profile", this.fallbackCmykProfile));
        }
        if (this.taggedPdf) {
            cmdLine.add(CommandLine.toCommand("tagged-pdf"));
        }
        if (this.pdfForms) {
            cmdLine.add(CommandLine.toCommand("pdf-forms"));
        }
        if (this.cssDpi > 0) {
            cmdLine.add(CommandLine.toCommand("css-dpi", this.cssDpi));
        }
        if (this.pdfTitle != null) {
            cmdLine.add(CommandLine.toCommand("pdf-title", this.pdfTitle));
        }
        if (this.pdfSubject != null) {
            cmdLine.add(CommandLine.toCommand("pdf-subject", this.pdfSubject));
        }
        if (this.pdfAuthor != null) {
            cmdLine.add(CommandLine.toCommand("pdf-author", this.pdfAuthor));
        }
        if (this.pdfKeywords != null) {
            cmdLine.add(CommandLine.toCommand("pdf-keywords", this.pdfKeywords));
        }
        if (this.pdfCreator != null) {
            cmdLine.add(CommandLine.toCommand("pdf-creator", this.pdfCreator));
        }
        if (this.xmp != null) {
            cmdLine.add(CommandLine.toCommand("pdf-xmp", this.xmp));
        }
        if (this.encrypt) {
            cmdLine.add(CommandLine.toCommand("encrypt"));
        }
        if (this.keyBits != null) {
            cmdLine.add(CommandLine.toCommand("key-bits", this.keyBits));
        }
        if (this.userPassword != null) {
            cmdLine.add(CommandLine.toCommand("user-password", this.userPassword));
        }
        if (this.ownerPassword != null) {
            cmdLine.add(CommandLine.toCommand("owner-password", this.ownerPassword));
        }
        if (this.disallowPrint) {
            cmdLine.add(CommandLine.toCommand("disallow-print"));
        }
        if (this.disallowCopy) {
            cmdLine.add(CommandLine.toCommand("disallow-copy"));
        }
        if (this.allowCopyForAccessibility) {
            cmdLine.add(CommandLine.toCommand("allow-copy-for-accessibility"));
        }
        if (this.disallowAnnotate) {
            cmdLine.add(CommandLine.toCommand("disallow-annotate"));
        }
        if (this.disallowModify) {
            cmdLine.add(CommandLine.toCommand("disallow-modify"));
        }
        if (this.allowAssembly) {
            cmdLine.add(CommandLine.toCommand("allow-assembly"));
        }
        if (this.rasterFormat != null) {
            cmdLine.add(CommandLine.toCommand("raster-format", this.rasterFormat));
        }
        if (this.rasterJpegQuality > -1) {
            cmdLine.add(CommandLine.toCommand("raster-jpeg-quality", this.rasterJpegQuality));
        }
        if (this.rasterPage > 0) {
            cmdLine.add(CommandLine.toCommand("raster-pages", this.rasterPage));
        }
        if (this.rasterDpi > 0) {
            cmdLine.add(CommandLine.toCommand("raster-dpi", this.rasterDpi));
        }
        if (this.rasterThreads > -1) {
            cmdLine.add(CommandLine.toCommand("raster-threads", this.rasterThreads));
        }
        if (this.rasterBackground != null) {
            cmdLine.add(CommandLine.toCommand("raster-background", this.rasterBackground));
        }
        this.options.forEach(o -> cmdLine.add(o.snd == null ? CommandLine.toCommand(o.fst) : CommandLine.toCommand(o.fst, o.snd)));
        return cmdLine;
    }

    private boolean readMessagesFromStderr(Process process) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getErrorStream()));){
            boolean bl = this.readMessages(reader);
            return bl;
        }
    }

    public void addRemap(String url, String directory) {
        this.remaps.add(url + "=" + directory);
    }

    public void clearRemaps() {
        this.remaps.clear();
    }

    public void setNoLocalFiles(boolean noLocalFiles) {
        this.noLocalFiles = noLocalFiles;
    }

    public void setPageSize(String pageSize) {
        this.pageSize = pageSize;
    }

    public void setPageMargin(String pageMargin) {
        this.pageMargin = pageMargin;
    }

    public void setNoSystemFonts(boolean noSystemFonts) {
        this.noSystemFonts = noSystemFonts;
    }

    public void setCssDpi(int cssDpi) {
        if (cssDpi < 1) {
            throw new IllegalArgumentException("invalid cssDpi value (must be > 0)");
        }
        this.cssDpi = cssDpi;
    }

    public void setRasterFormat(RasterFormat rasterFormat) {
        this.rasterFormat = rasterFormat;
    }

    public void setRasterJpegQuality(int rasterJpegQuality) {
        if (rasterJpegQuality < 0 || rasterJpegQuality > 100) {
            throw new IllegalArgumentException("invalid rasterJpegQuality value (must be [0, 100])");
        }
        this.rasterJpegQuality = rasterJpegQuality;
    }

    public void setRasterPage(int rasterPage) {
        if (rasterPage < 1) {
            throw new IllegalArgumentException("invalid rasterPage value (must be > 0)");
        }
        this.rasterPage = rasterPage;
    }

    public void setRasterDpi(int rasterDpi) {
        if (rasterDpi < 1) {
            throw new IllegalArgumentException("invalid rasterDpi value (must be > 0)");
        }
        this.rasterDpi = rasterDpi;
    }

    public void setRasterThreads(int rasterThreads) {
        this.rasterThreads = rasterThreads;
    }

    public void setRasterBackground(RasterBackground rasterBackground) {
        this.rasterBackground = rasterBackground;
    }

    public void addOption(String key) {
        this.options.add(new Pair(key));
    }

    public void addOption(String key, String value) {
        this.options.add(new Pair(key, value));
    }

    public void clearOptions() {
        this.options.clear();
    }
}

