/*
 * Decompiled with CFR 0.152.
 */
package com.princexml.wrapper;

import com.princexml.wrapper.AbstractPrince;
import com.princexml.wrapper.Chunk;
import com.princexml.wrapper.CommandLine;
import com.princexml.wrapper.FileAttachment;
import com.princexml.wrapper.Json;
import com.princexml.wrapper.Util;
import com.princexml.wrapper.enums.InputType;
import com.princexml.wrapper.enums.PdfEvent;
import com.princexml.wrapper.events.PrinceEvents;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;

public class PrinceControl
extends AbstractPrince {
    private Process process;
    private String version;
    private final List<String> inputPaths = new ArrayList<String>();
    private final List<byte[]> resources = new ArrayList<byte[]>();

    public PrinceControl(String princePath) {
        this(princePath, null);
    }

    public PrinceControl(String princePath, PrinceEvents events) {
        super(princePath, events);
    }

    @Override
    public boolean convert(String inputPath, OutputStream output) throws IOException {
        this.inputPaths.add(inputPath);
        return this.convert(output);
    }

    @Override
    public boolean convert(List<String> inputPaths, OutputStream output) throws IOException {
        this.inputPaths.addAll(inputPaths);
        return this.convert(output);
    }

    @Override
    public boolean convert(InputStream input, OutputStream output) throws IOException {
        if (this.inputType == null || this.inputType == InputType.AUTO) {
            throw new RuntimeException("inputType has to be set to XML or HTML");
        }
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            Util.copyInputToOutput(input, baos);
            this.addResource(baos.toByteArray());
        }
        return this.convert(output);
    }

    @Override
    public boolean convertString(String input, OutputStream output) throws IOException {
        if (this.inputType == null || this.inputType == InputType.AUTO) {
            throw new RuntimeException("inputType has to be set to XML or HTML");
        }
        this.addResource(input.getBytes(StandardCharsets.UTF_8));
        return this.convert(output);
    }

    private boolean convert(OutputStream output) throws IOException {
        if (this.process == null) {
            throw new RuntimeException("control process has not been started");
        }
        OutputStream toPrince = this.process.getOutputStream();
        InputStream fromPrince = this.process.getInputStream();
        Chunk.writeChunk(toPrince, "job", this.getJobJson());
        for (byte[] r : this.resources) {
            Chunk.writeChunk(toPrince, "dat", r);
        }
        toPrince.flush();
        Chunk chunk = Chunk.readChunk(fromPrince);
        if (chunk.getTag().equals("pdf")) {
            output.write(chunk.getBytes());
            chunk = Chunk.readChunk(fromPrince);
        }
        if (chunk.getTag().equals("log")) {
            try (BufferedReader br = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(chunk.getBytes())));){
                boolean bl = this.readMessages(br);
                return bl;
            }
        }
        if (chunk.getTag().equals("err")) {
            throw new IOException("error: " + chunk.getString());
        }
        throw new IOException("unknown chunk: " + chunk.getTag());
    }

    public void start() throws IOException {
        if (this.process != null) {
            throw new RuntimeException("control process has already been started");
        }
        List<String> cmdLine = this.getBaseCommandLine();
        cmdLine.add(CommandLine.toCommand("control"));
        this.process = Util.invokeProcess(cmdLine);
        InputStream fromPrince = this.process.getInputStream();
        Chunk chunk = Chunk.readChunk(fromPrince);
        if (!chunk.getTag().equals("ver")) {
            if (chunk.getTag().equals("err")) {
                throw new IOException("error: " + chunk.getString());
            }
            throw new IOException("unknown chunk: " + chunk.getTag());
        }
        this.version = chunk.getString();
    }

    public void stop() throws IOException {
        if (this.process == null) {
            throw new RuntimeException("control process has not been started");
        }
        try (OutputStream toPrince = this.process.getOutputStream();){
            Chunk.writeChunk(toPrince, "end", "");
        }
        this.process.getInputStream().close();
        this.process.destroy();
    }

    private String getJobJson() {
        Json json = new Json();
        json.beginObj();
        json.beginObj("input");
        json.beginList("src");
        this.inputPaths.forEach(json::value);
        json.endList();
        if (this.inputType != null) {
            json.field("type", this.inputType.toString());
        }
        if (this.baseUrl != null) {
            json.field("base", this.baseUrl);
        }
        if (this.media != null) {
            json.field("media", this.media);
        }
        json.beginList("styles");
        this.styleSheets.forEach(json::value);
        json.endList();
        json.beginList("scripts");
        this.scripts.forEach(json::value);
        json.endList();
        json.field("default-style", !this.noDefaultStyle);
        json.field("author-style", !this.noAuthorStyle);
        json.field("javascript", this.javaScript);
        if (this.maxPasses > 0) {
            json.field("max-passes", this.maxPasses);
        }
        json.field("iframes", this.iframes);
        json.field("xinclude", this.xInclude);
        json.field("xml-external-entities", this.xmlExternalEntities);
        json.endObj();
        json.beginObj("pdf");
        json.field("embed-fonts", !this.noEmbedFonts);
        json.field("subset-fonts", !this.noSubsetFonts);
        json.field("artificial-fonts", !this.noArtificialFonts);
        json.field("force-identity-encoding", this.forceIdentityEncoding);
        json.field("compress", !this.noCompress);
        json.field("object-streams", !this.noObjectStreams);
        json.beginObj("encrypt");
        if (this.keyBits != null) {
            json.field("key-bits", this.keyBits.getValue());
        }
        if (this.userPassword != null) {
            json.field("user-password", this.userPassword);
        }
        if (this.ownerPassword != null) {
            json.field("owner-password", this.ownerPassword);
        }
        json.field("disallow-print", this.disallowPrint);
        json.field("disallow-modify", this.disallowModify);
        json.field("disallow-copy", this.disallowCopy);
        json.field("disallow-annotate", this.disallowAnnotate);
        json.field("allow-copy-for-accessibility", this.allowCopyForAccessibility);
        json.field("allow-assembly", this.allowAssembly);
        json.endObj();
        if (this.pdfProfile != null) {
            json.field("pdf-profile", this.pdfProfile.toString());
        }
        if (this.pdfOutputIntent != null) {
            json.field("pdf-output-intent", this.pdfOutputIntent);
        }
        if (this.pdfScript != null) {
            json.beginObj("pdf-script");
            json.field("url", this.pdfScript);
            json.endObj();
        }
        if (!this.pdfEventScripts.isEmpty()) {
            json.beginObj("pdf-event-scripts");
            this.pdfEventScripts.forEach((k, v) -> {
                json.beginObj(k.toString());
                json.field("url", (String)v);
                json.endObj();
            });
            json.endObj();
        }
        if (this.fallbackCmykProfile != null) {
            json.field("fallback-cmyk-profile", this.fallbackCmykProfile);
        }
        json.field("color-conversion", this.convertColors ? "output-intent" : "none");
        if (this.pdfId != null) {
            json.field("pdf-id", this.pdfId);
        }
        if (this.pdfLang != null) {
            json.field("pdf-lang", this.pdfLang);
        }
        if (this.xmp != null) {
            json.field("pdf-xmp", this.xmp);
        }
        json.field("tagged-pdf", this.taggedPdf);
        json.field("pdf-forms", this.pdfForms);
        json.beginList("attach");
        for (FileAttachment fa : this.fileAttachments) {
            json.beginObj();
            json.field("url", fa.url);
            if (fa.filename != null) {
                json.field("filename", fa.filename);
            }
            if (fa.description != null) {
                json.field("description", fa.description);
            }
            json.endObj();
        }
        json.endList();
        json.endObj();
        json.beginObj("metadata");
        if (this.pdfTitle != null) {
            json.field("title", this.pdfTitle);
        }
        if (this.pdfSubject != null) {
            json.field("subject", this.pdfSubject);
        }
        if (this.pdfAuthor != null) {
            json.field("author", this.pdfAuthor);
        }
        if (this.pdfKeywords != null) {
            json.field("keywords", this.pdfKeywords);
        }
        if (this.pdfCreator != null) {
            json.field("creator", this.pdfCreator);
        }
        json.endObj();
        json.field("job-resource-count", this.resources.size());
        json.endObj();
        return json.toString();
    }

    public String getVersion() {
        return this.version;
    }

    public void addScript(byte[] script) {
        this.resources.add(script);
        super.addScript("job-resource:" + (this.resources.size() - 1));
    }

    public void addStyleSheet(byte[] styleSheet) {
        this.resources.add(styleSheet);
        super.addStyleSheet("job-resource:" + (this.resources.size() - 1));
    }

    public void setPdfScript(byte[] pdfScript) {
        this.resources.add(pdfScript);
        super.setPdfScript("job-resource:" + (this.resources.size() - 1));
    }

    public void addPdfEventScript(PdfEvent pdfEvent, byte[] pdfScript) {
        this.resources.add(pdfScript);
        super.addPdfEventScript(pdfEvent, "job-resource:" + (this.resources.size() - 1));
    }

    public void addFileAttachment(byte[] attachment, String filename, String description) {
        this.resources.add(attachment);
        this.fileAttachments.add(new FileAttachment("job-resource:" + (this.resources.size() - 1), filename, description));
    }

    private void addResource(byte[] resource) {
        this.resources.add(resource);
        this.inputPaths.add("job-resource:" + (this.resources.size() - 1));
    }
}

