/*
 * Decompiled with CFR 0.152.
 */
package com.pro_crafting.tools.jasperreport;

import com.pro_crafting.tools.jasperreport.CompileTask;
import com.pro_crafting.tools.jasperreport.JasperMojoConfiguration;
import com.pro_crafting.tools.jasperreport.JasperReporterThreadFactory;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.jdt.JRJdtCompiler;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.plexus.compiler.util.scan.InclusionScanException;
import org.codehaus.plexus.compiler.util.scan.SimpleSourceInclusionScanner;
import org.codehaus.plexus.compiler.util.scan.SourceInclusionScanner;
import org.codehaus.plexus.compiler.util.scan.StaleSourceScanner;
import org.codehaus.plexus.compiler.util.scan.mapping.SourceMapping;
import org.codehaus.plexus.compiler.util.scan.mapping.SuffixMapping;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JasperReportCompiler {
    private static final Logger LOGGER = LoggerFactory.getLogger(JasperReportCompiler.class);
    static final String ERROR_JRE_COMPILE_ERROR = "Some Jasper reports could not be compiled. See log above for details.";
    private JasperMojoConfiguration configuration;

    public JasperReportCompiler(JasperMojoConfiguration configuration) {
        this.configuration = configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void compileReports() throws MojoExecutionException {
        if (this.configuration.skip) {
            LOGGER.info("Compiling Jasper reports is skipped.");
            return;
        }
        this.checkOutDirWritable();
        SuffixMapping mapping = new SuffixMapping(this.configuration.sourceFileExt, this.configuration.outputFileExt);
        Set<File> sources = this.jrxmlFilesToCompile((SourceMapping)mapping);
        if (sources.isEmpty()) {
            LOGGER.info("Nothing to compile - all Jasper reports are up to date");
            return;
        }
        LOGGER.info("Compiling {} Jasper reports design files.", (Object)sources.size());
        List<CompileTask> tasks = this.generateTasks(sources, (SourceMapping)mapping);
        if (tasks.isEmpty()) {
            LOGGER.info("Nothing to compile");
            return;
        }
        ClassLoader originalTCCL = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClassLoader(originalTCCL));
        try {
            this.configureJasper();
            this.executeTasks(tasks);
        }
        finally {
            if (originalTCCL != null) {
                Thread.currentThread().setContextClassLoader(originalTCCL);
            }
        }
    }

    private Set<File> jrxmlFilesToCompile(SourceMapping mapping) throws MojoExecutionException {
        if (!this.configuration.sourceDirectory.isDirectory()) {
            if (this.configuration.failOnMissingSourceDirectory) {
                throw new IllegalArgumentException("Configured source directory " + this.configuration.sourceDirectory + " is not a directory");
            }
            LOGGER.warn("Configured source directory {} is not a directory, skipping JasperReports reports compilation.", (Object)this.configuration.sourceDirectory);
            return Collections.emptySet();
        }
        try {
            SourceInclusionScanner scanner = this.createSourceInclusionScanner();
            scanner.addSourceMapping(mapping);
            return scanner.getIncludedSources(this.configuration.sourceDirectory, this.configuration.outputDirectory);
        }
        catch (InclusionScanException e) {
            throw new MojoExecutionException("Error scanning source root: '" + this.configuration.sourceDirectory + "'.", (Exception)((Object)e));
        }
    }

    private void checkOutDirWritable() throws MojoExecutionException {
        if (!this.configuration.outputDirectory.exists()) {
            this.checkIfOutputCanBeCreated();
            this.checkIfOutputDirIsWritable();
            if (this.configuration.verbose) {
                LOGGER.info("Output dir check OK");
            }
        } else if (!this.configuration.outputDirectory.canWrite()) {
            throw new MojoExecutionException("The output dir exists but was not writable. Try running maven with the 'clean' goal.");
        }
    }

    private void configureJasper() {
        DefaultJasperReportsContext jrContext = DefaultJasperReportsContext.getInstance();
        jrContext.setProperty("net.sf.jasperreports.compiler.java", this.configuration.compiler == null ? JRJdtCompiler.class.getName() : this.configuration.compiler);
        if (this.configuration.additionalProperties != null) {
            JRPropertiesUtil properties = JRPropertiesUtil.getInstance((JasperReportsContext)jrContext);
            for (Map.Entry<String, String> additionalProperty : this.configuration.additionalProperties.entrySet()) {
                properties.setProperty(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
    }

    private ClassLoader getClassLoader(ClassLoader classLoader) throws MojoExecutionException {
        ArrayList<URL> classpath = new ArrayList<URL>();
        if (this.configuration.classpathElements != null) {
            for (String element : this.configuration.classpathElements) {
                try {
                    File f = new File(element);
                    classpath.add(f.toURI().toURL());
                    LOGGER.debug("Added to classpath {}", (Object)element);
                }
                catch (Exception e) {
                    throw new MojoExecutionException("Error setting classpath " + element + " " + e.getMessage());
                }
            }
        }
        if (this.configuration.additionalClasspath != null) {
            for (String element : this.configuration.additionalClasspath.split("[;]")) {
                try {
                    File f = new File(element);
                    classpath.add(f.toURI().toURL());
                    LOGGER.debug("Added additionalClasspath to classpath {}", (Object)element);
                }
                catch (Exception e) {
                    throw new MojoExecutionException("Error setting classpath " + element + " " + e.getMessage());
                }
            }
        }
        if (classpath.isEmpty()) {
            return classLoader;
        }
        URL[] urls = classpath.toArray(new URL[0]);
        return new URLClassLoader(urls, classLoader);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<CompileTask> generateTasks(Set<File> sources, SourceMapping mapping) throws MojoExecutionException {
        LinkedList<CompileTask> tasks = new LinkedList<CompileTask>();
        try {
            String root = this.configuration.sourceDirectory.getCanonicalPath();
            for (File src : sources) {
                String srcName = this.getRelativePath(root, src);
                try {
                    File destination = (File)mapping.getTargetFiles(this.configuration.outputDirectory, srcName).iterator().next();
                    this.createDestination(destination.getParentFile());
                    tasks.add(new CompileTask(src, destination, this.configuration.verbose));
                }
                catch (InclusionScanException e) {
                    throw new MojoExecutionException("Error compiling report design : " + src, (Exception)((Object)e));
                    return tasks;
                }
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not getCanonicalPath from source directory " + this.configuration.sourceDirectory, (Exception)e);
        }
    }

    private void createDestination(File destinationDirectory) throws MojoExecutionException {
        if (!destinationDirectory.exists()) {
            if (destinationDirectory.mkdirs()) {
                LOGGER.debug("Created directory {}", (Object)destinationDirectory.getName());
            } else {
                throw new MojoExecutionException("Could not create directory " + destinationDirectory.getName());
            }
        }
    }

    private void executeTasks(List<CompileTask> tasks) throws MojoExecutionException {
        ExecutorService threadPool = this.newThreadPool();
        try {
            long t1 = System.currentTimeMillis();
            List<Future<Void>> output = threadPool.invokeAll(tasks);
            long time = System.currentTimeMillis() - t1;
            LOGGER.info("Generated {} jasper reports in {} seconds", (Object)output.size(), (Object)((double)time / 1000.0));
            this.checkForExceptions(output);
        }
        catch (InterruptedException e) {
            LOGGER.error("Failed to compile Japser reports: Interrupted!", (Throwable)e);
            throw new MojoExecutionException("Error while compiling Jasper reports", (Exception)e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof JRException) {
                throw new MojoExecutionException(ERROR_JRE_COMPILE_ERROR, (Exception)e);
            }
            throw new MojoExecutionException("Error while compiling Jasper reports", (Exception)e);
        }
        finally {
            threadPool.shutdown();
        }
    }

    private ExecutorService newThreadPool() {
        return Executors.newFixedThreadPool(this.configuration.numberOfThreads, new JasperReporterThreadFactory());
    }

    private void checkForExceptions(List<Future<Void>> output) throws InterruptedException, ExecutionException {
        for (Future<Void> future : output) {
            future.get();
        }
    }

    private SourceInclusionScanner createSourceInclusionScanner() throws MojoExecutionException {
        if (this.configuration.sourceScanner.equals(StaleSourceScanner.class.getName())) {
            return new StaleSourceScanner();
        }
        if (this.configuration.sourceScanner.equals(SimpleSourceInclusionScanner.class.getName())) {
            return new SimpleSourceInclusionScanner(Collections.singleton("**/*" + this.configuration.sourceFileExt), Collections.emptySet());
        }
        throw new MojoExecutionException("sourceScanner not supported: '" + this.configuration.sourceScanner + "'.");
    }

    private void checkIfOutputCanBeCreated() throws MojoExecutionException {
        if (!this.configuration.outputDirectory.mkdirs()) {
            throw new MojoExecutionException((Object)this, "Output folder could not be created", "Outputfolder " + this.configuration.outputDirectory.getAbsolutePath() + " is not a folder");
        }
    }

    private void checkIfOutputDirIsWritable() throws MojoExecutionException {
        if (!this.configuration.outputDirectory.canWrite()) {
            throw new MojoExecutionException((Object)this, "Could not write to output folder", "Could not write to output folder: " + this.configuration.outputDirectory.getAbsolutePath());
        }
    }

    private String getRelativePath(String root, File file) throws MojoExecutionException {
        try {
            return file.getCanonicalPath().substring(root.length() + 1);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not getCanonicalPath from file " + file, (Exception)e);
        }
    }
}

