/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.concurrent;

import com.proofpoint.concurrent.WrappingExecutorService;
import com.proofpoint.tracetoken.TraceToken;
import com.proofpoint.tracetoken.TraceTokenManager;
import com.proofpoint.tracetoken.TraceTokenScope;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;

public class TraceTokenCopyingExecutor
extends WrappingExecutorService {
    private TraceTokenCopyingExecutor(ExecutorService executor) {
        super(executor);
    }

    public static ExecutorService traceTokenCopyingExecutor(ExecutorService executor) {
        return new TraceTokenCopyingExecutor(executor);
    }

    @Override
    protected <T> Callable<T> wrapTask(Callable<T> callable) {
        TraceToken token = TraceTokenManager.getCurrentTraceToken();
        return () -> {
            try (TraceTokenScope ignored = TraceTokenManager.registerTraceToken((TraceToken)token);){
                Object v = callable.call();
                return v;
            }
        };
    }

    @Override
    protected Runnable wrapTask(Runnable command) {
        TraceToken token = TraceTokenManager.getCurrentTraceToken();
        return () -> {
            try (TraceTokenScope ignored = TraceTokenManager.registerTraceToken((TraceToken)token);){
                command.run();
            }
        };
    }
}

