/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.configuration;

import com.google.common.annotations.Beta;
import com.google.common.base.CaseFormat;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.UncheckedExecutionException;
import com.google.inject.Binding;
import com.google.inject.ConfigurationException;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.spi.DefaultElementVisitor;
import com.google.inject.spi.Element;
import com.google.inject.spi.ElementVisitor;
import com.google.inject.spi.Message;
import com.google.inject.spi.ProviderInstanceBinding;
import com.proofpoint.configuration.ConfigurationMetadata;
import com.proofpoint.configuration.ConfigurationProvider;
import com.proofpoint.configuration.DefunctConfig;
import com.proofpoint.configuration.ElementsIterator;
import com.proofpoint.configuration.InvalidConfigurationException;
import com.proofpoint.configuration.MapClasses;
import com.proofpoint.configuration.Problems;
import com.proofpoint.configuration.WarningsMonitor;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import org.apache.bval.jsr303.ApacheValidationProvider;
import org.apache.bval.jsr303.ApacheValidatorConfiguration;

public final class ConfigurationFactory {
    private static final Validator VALIDATOR = ((ApacheValidatorConfiguration)Validation.byProvider(ApacheValidationProvider.class).configure()).buildValidatorFactory().getValidator();
    private final Map<String, String> properties;
    private final Map<String, String> applicationDefaults;
    private final Problems.Monitor monitor;
    private final Set<String> unusedProperties = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Collection<String> initialErrors;
    private final ConcurrentMap<ConfigurationProvider<?>, Object> instanceCache = new ConcurrentHashMap();
    private final Set<ConfigurationProvider<?>> registeredProviders = Sets.newConcurrentHashSet();
    private final LoadingCache<Class<?>, ConfigurationMetadata<?>> metadataCache = CacheBuilder.newBuilder().build(new CacheLoader<Class<?>, ConfigurationMetadata<?>>(){

        public ConfigurationMetadata<?> load(Class<?> configClass) {
            return ConfigurationMetadata.getConfigurationMetadata(configClass, ConfigurationFactory.this.monitor);
        }
    });

    public ConfigurationFactory(Map<String, String> properties) {
        this(properties, (Map<String, String>)ImmutableMap.of(), properties.keySet(), (Collection<String>)ImmutableList.of(), Problems.NULL_MONITOR);
    }

    ConfigurationFactory(Map<String, String> properties, Map<String, String> applicationDefaults, Set<String> expectToUse, Collection<String> errors, Problems.Monitor monitor) {
        this.monitor = monitor;
        this.properties = ImmutableMap.copyOf(properties);
        this.applicationDefaults = ImmutableMap.copyOf(applicationDefaults);
        this.unusedProperties.addAll(expectToUse);
        this.initialErrors = ImmutableList.copyOf(errors);
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    @Beta
    public void consumeProperty(String property) {
        Preconditions.checkNotNull((Object)property, (Object)"property is null");
        this.unusedProperties.remove(property);
    }

    Set<String> getUnusedProperties() {
        return ImmutableSortedSet.copyOf(this.unusedProperties);
    }

    Problems.Monitor getMonitor() {
        return this.monitor;
    }

    Collection<String> getInitialErrors() {
        return this.initialErrors;
    }

    @Beta
    public void registerConfigurationClasses(Module module) {
        this.registeredProviders.addAll(ConfigurationFactory.getAllProviders(module));
    }

    Iterable<ConfigurationProvider<?>> getConfigurationProviders() {
        return ImmutableList.copyOf(this.registeredProviders);
    }

    public <T> T build(Class<T> configClass) {
        return (T)((ConfigurationHolder)this.build(configClass, null)).instance;
    }

    <T> T build(ConfigurationProvider<T> configurationProvider, WarningsMonitor warningsMonitor) {
        T existingValue;
        Preconditions.checkNotNull(configurationProvider, (Object)"configurationProvider");
        this.registeredProviders.add(configurationProvider);
        Object instance = this.getCachedInstance(configurationProvider);
        if (instance != null) {
            return instance;
        }
        ConfigurationHolder<T> holder = this.build(configurationProvider.getConfigClass(), configurationProvider.getPrefix());
        instance = ((ConfigurationHolder)holder).instance;
        if (warningsMonitor != null) {
            for (Message message : ((ConfigurationHolder)holder).problems.getWarnings()) {
                warningsMonitor.onWarning(message.toString());
            }
        }
        if ((existingValue = this.putCachedInstance(configurationProvider, instance)) != null) {
            return existingValue;
        }
        return instance;
    }

    <T> T buildDefaults(ConfigurationProvider<T> configurationProvider) {
        return this.build(configurationProvider.getConfigClass(), configurationProvider.getPrefix(), true, new Problems());
    }

    private <T> T getCachedInstance(ConfigurationProvider<T> configurationProvider) {
        return (T)this.instanceCache.get(configurationProvider);
    }

    private <T> T putCachedInstance(ConfigurationProvider<T> configurationProvider, T instance) {
        return (T)this.instanceCache.putIfAbsent(configurationProvider, instance);
    }

    private <T> ConfigurationHolder<T> build(Class<T> configClass, String prefix) {
        Problems problems = new Problems(this.monitor);
        T instance = this.build(configClass, prefix, false, problems);
        problems.throwIfHasErrors();
        return new ConfigurationHolder(instance, problems);
    }

    private <T> T build(Class<T> configClass, String prefix, boolean isDefault, Problems problems) {
        if (configClass == null) {
            throw new NullPointerException("configClass is null");
        }
        if (prefix == null) {
            prefix = "";
        } else if (!prefix.isEmpty()) {
            prefix = prefix + ".";
        }
        ConfigurationMetadata<T> configurationMetadata = this.getMetadata(configClass);
        configurationMetadata.getProblems().throwIfHasErrors();
        T instance = ConfigurationFactory.newInstance(configurationMetadata);
        for (ConfigurationMetadata.AttributeMetadata attribute : configurationMetadata.getAttributes().values()) {
            try {
                this.setConfigProperty(instance, attribute, prefix, isDefault, problems);
            }
            catch (InvalidConfigurationException e) {
                problems.addError(e.getCause(), e.getMessage(), new Object[0]);
            }
        }
        if (isDefault) {
            return instance;
        }
        if (configClass.isAnnotationPresent(DefunctConfig.class)) {
            for (String value : configClass.getAnnotation(DefunctConfig.class).value()) {
                String key = prefix + value;
                if (!value.isEmpty() && this.properties.get(key) != null) {
                    problems.addError("Defunct property '%s' (class [%s]) cannot be configured.", key, configClass.toString());
                }
                if (value.isEmpty() || this.applicationDefaults.get(key) == null) continue;
                problems.addError("Defunct property '%s' (class [%s]) cannot have an application default.", key, configClass.toString());
            }
        }
        for (ConstraintViolation violation : VALIDATOR.validate(instance, new Class[0])) {
            ConfigurationMetadata.AttributeMetadata attributeMetadata = configurationMetadata.getAttributes().get(CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, violation.getPropertyPath().toString()));
            if (attributeMetadata != null) {
                problems.addError("Constraint violation for property '%s': %s (for class %s)", prefix + attributeMetadata.getInjectionPoint().getProperty(), violation.getMessage(), configClass.getName());
                continue;
            }
            problems.addError("Constraint violation with property prefix '%s': %s %s (for class %s)", prefix, violation.getPropertyPath(), violation.getMessage(), configClass.getName());
        }
        return instance;
    }

    private <T> ConfigurationMetadata<T> getMetadata(Class<T> configClass) {
        try {
            return (ConfigurationMetadata)this.metadataCache.getUnchecked(configClass);
        }
        catch (UncheckedExecutionException e) {
            throw Throwables.propagate((Throwable)e.getCause());
        }
    }

    private static <T> T newInstance(ConfigurationMetadata<T> configurationMetadata) {
        try {
            return configurationMetadata.getConstructor().newInstance(new Object[0]);
        }
        catch (Throwable e) {
            if (e instanceof InvocationTargetException && e.getCause() != null) {
                e = e.getCause();
            }
            throw Problems.exceptionFor(e, "Error creating instance of configuration class [%s]", configurationMetadata.getConfigClass().getName());
        }
    }

    private <T> void setConfigProperty(T instance, ConfigurationMetadata.AttributeMetadata attribute, String prefix, boolean isDefault, Problems problems) throws InvalidConfigurationException {
        ConfigurationMetadata.InjectionPointMetaData injectionPoint = this.findOperativeInjectionPoint(attribute, prefix, isDefault, problems);
        if (injectionPoint == null) {
            return;
        }
        Object value = this.getInjectedValue(attribute, injectionPoint, prefix, isDefault, problems);
        try {
            injectionPoint.getSetter().invoke(instance, value);
        }
        catch (Throwable e) {
            if (e instanceof InvocationTargetException && e.getCause() != null) {
                e = e.getCause();
            }
            throw new InvalidConfigurationException(e, "Error invoking configuration method [%s]", injectionPoint.getSetter().toGenericString());
        }
    }

    private ConfigurationMetadata.InjectionPointMetaData findOperativeInjectionPoint(ConfigurationMetadata.AttributeMetadata attribute, String prefix, boolean isDefault, Problems problems) throws ConfigurationException {
        OperativeInjectionData operativeInjectionData = new OperativeInjectionData(attribute, prefix, problems);
        operativeInjectionData.consider(attribute.getInjectionPoint(), false);
        for (ConfigurationMetadata.InjectionPointMetaData injectionPoint : attribute.getLegacyInjectionPoints()) {
            operativeInjectionData.consider(injectionPoint, true);
        }
        if (!isDefault) {
            problems.throwIfHasErrors();
            ConfigurationMetadata.InjectionPointMetaData injectionPoint = operativeInjectionData.operativeInjectionPoint;
            if (injectionPoint != null) {
                if (injectionPoint.getSetter().isAnnotationPresent(Deprecated.class)) {
                    problems.addWarning("Configuration property '%s' is deprecated and should not be used", prefix + injectionPoint.getProperty());
                }
                return injectionPoint;
            }
        }
        return operativeInjectionData.defaultInjectionPoint;
    }

    private Object getInjectedValue(ConfigurationMetadata.AttributeMetadata attribute, ConfigurationMetadata.InjectionPointMetaData injectionPoint, String prefix, boolean isDefault, Problems problems) throws InvalidConfigurationException {
        String name = prefix + injectionPoint.getProperty();
        MapClasses mapClasses = injectionPoint.getMapClasses();
        if (mapClasses != null) {
            return this.getInjectedMap(attribute, injectionPoint, name + ".", problems, mapClasses.getKey(), mapClasses.getValue());
        }
        String value = this.properties.get(name);
        if (isDefault || value == null) {
            value = this.applicationDefaults.get(name);
        }
        if (value == null) {
            return null;
        }
        Class<?> propertyType = injectionPoint.getSetter().getParameterTypes()[0];
        Object finalValue = ConfigurationFactory.coerce(propertyType, value);
        String valueDescription = attribute.isSecuritySensitive() ? "" : " '" + value + "'";
        if (finalValue == null) {
            throw new InvalidConfigurationException(String.format("Could not coerce value%s to %s (property '%s') in order to call [%s]", valueDescription, propertyType.getName(), name, injectionPoint.getSetter().toGenericString()), new Object[0]);
        }
        this.unusedProperties.remove(name);
        return finalValue;
    }

    private <K, V> Map<K, V> getInjectedMap(ConfigurationMetadata.AttributeMetadata attribute, ConfigurationMetadata.InjectionPointMetaData injectionPoint, String name, Problems problems, Class<K> keyClass, Class<V> valueClass) {
        boolean valueIsConfigClass = ConfigurationMetadata.isConfigClass(valueClass);
        HashSet<String> keySet = new HashSet<String>();
        for (String key : this.properties.keySet()) {
            if (!key.startsWith(name)) continue;
            String keySuffix = key.substring(name.length());
            if (valueIsConfigClass) {
                keySet.add(keySuffix.split("\\.", 2)[0]);
                continue;
            }
            if (keySuffix.contains(".")) {
                problems.addError("Configuration map has non-configuration value class %s, so key '%s' cannot be followed by '.' (property '%s') for call [%s]", valueClass.getName(), keySuffix.split("\\.", 2)[0], key, injectionPoint.getSetter().toGenericString());
                continue;
            }
            keySet.add(keySuffix);
        }
        HashMap<Object, String> coercedKeyMap = new HashMap<Object, String>();
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (String keyString : keySet) {
            Object value;
            Object key;
            block10: {
                key = ConfigurationFactory.coerce(keyClass, keyString);
                if (key == null) {
                    problems.addError("Could not coerce map key '%s' to %s (property%s '%s') in order to call [%s]", keyString, keyClass.getName(), valueIsConfigClass ? " prefix" : "", name + keyString, injectionPoint.getSetter().toGenericString());
                    continue;
                }
                String oldkeyString = coercedKeyMap.put(key, keyString);
                if (oldkeyString != null) {
                    problems.addError("Configuration property prefixes ('%s' and '%s') convert to the same map key, preventing creation of map for call [%s]", name + oldkeyString, name + keyString, injectionPoint.getSetter().toGenericString());
                    continue;
                }
                if (valueIsConfigClass) {
                    try {
                        value = this.build(valueClass, name + keyString, false, problems);
                        break block10;
                    }
                    catch (ConfigurationException ignored) {
                        continue;
                    }
                }
                value = ConfigurationFactory.coerce(valueClass, this.properties.get(name + keyString));
                if (value == null) {
                    String valueDescription = attribute.isSecuritySensitive() ? "" : " '" + this.properties.get(name + keyString) + "'";
                    problems.addError("Could not coerce value%s to %s (property '%s') in order to call [%s]", valueDescription, valueClass.getName(), name + keyString, injectionPoint.getSetter().toGenericString());
                    continue;
                }
                this.unusedProperties.remove(name + keyString);
            }
            builder.put(key, value);
        }
        return builder.build();
    }

    private static Object coerce(Class<?> type, String value) {
        if (type.isPrimitive() && value == null) {
            return null;
        }
        try {
            if (String.class.isAssignableFrom(type)) {
                return value;
            }
            if (Boolean.class.isAssignableFrom(type) || Boolean.TYPE.isAssignableFrom(type)) {
                return Boolean.valueOf(value);
            }
            if (Byte.class.isAssignableFrom(type) || Byte.TYPE.isAssignableFrom(type)) {
                return Byte.valueOf(value);
            }
            if (Short.class.isAssignableFrom(type) || Short.TYPE.isAssignableFrom(type)) {
                return Short.valueOf(value);
            }
            if (Integer.class.isAssignableFrom(type) || Integer.TYPE.isAssignableFrom(type)) {
                return Integer.valueOf(value);
            }
            if (Long.class.isAssignableFrom(type) || Long.TYPE.isAssignableFrom(type)) {
                return Long.valueOf(value);
            }
            if (Float.class.isAssignableFrom(type) || Float.TYPE.isAssignableFrom(type)) {
                return Float.valueOf(value);
            }
            if (Double.class.isAssignableFrom(type) || Double.TYPE.isAssignableFrom(type)) {
                return Double.valueOf(value);
            }
        }
        catch (Exception ignored) {
            return null;
        }
        try {
            Method fromString = type.getMethod("fromString", String.class);
            if (fromString.getReturnType().isAssignableFrom(type)) {
                return fromString.invoke(null, value);
            }
        }
        catch (Throwable ignored) {
            // empty catch block
        }
        try {
            Method valueOf = type.getMethod("valueOf", String.class);
            if (valueOf.getReturnType().isAssignableFrom(type)) {
                return valueOf.invoke(null, value);
            }
        }
        catch (Throwable ignored) {
            // empty catch block
        }
        try {
            Constructor<?> constructor = type.getConstructor(String.class);
            return constructor.newInstance(value);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private static List<ConfigurationProvider<?>> getAllProviders(Module ... modules) {
        final ArrayList providers = Lists.newArrayList();
        ElementsIterator elementsIterator = new ElementsIterator(modules);
        for (Element element : elementsIterator) {
            element.acceptVisitor((ElementVisitor)new DefaultElementVisitor<Void>(){

                public <T> Void visit(Binding<T> binding) {
                    ProviderInstanceBinding providerInstanceBinding;
                    Provider provider;
                    if (binding instanceof ProviderInstanceBinding && (provider = (providerInstanceBinding = (ProviderInstanceBinding)binding).getProviderInstance()) instanceof ConfigurationProvider) {
                        ConfigurationProvider configurationProvider = (ConfigurationProvider)provider;
                        providers.add(configurationProvider);
                    }
                    return null;
                }
            });
        }
        return providers;
    }

    private static class ConfigurationHolder<T> {
        private final T instance;
        private final Problems problems;

        private ConfigurationHolder(T instance, Problems problems) {
            this.instance = instance;
            this.problems = problems;
        }
    }

    private class OperativeInjectionData {
        private ConfigurationMetadata.AttributeMetadata attribute;
        private String prefix;
        private Problems problems;
        private String operativeDescription = null;
        ConfigurationMetadata.InjectionPointMetaData operativeInjectionPoint = null;
        ConfigurationMetadata.InjectionPointMetaData defaultInjectionPoint = null;

        public OperativeInjectionData(ConfigurationMetadata.AttributeMetadata attribute, String prefix, Problems problems) {
            this.attribute = attribute;
            this.prefix = prefix;
            this.problems = problems;
        }

        public void consider(ConfigurationMetadata.InjectionPointMetaData injectionPoint, boolean isLegacy) {
            if (injectionPoint == null) {
                return;
            }
            String fullName = this.prefix + injectionPoint.getProperty();
            if (injectionPoint.isConfigMap()) {
                String mapPrefix = fullName + ".";
                for (String key : ConfigurationFactory.this.properties.keySet()) {
                    if (!key.startsWith(mapPrefix)) continue;
                    if (isLegacy) {
                        this.warnLegacy(fullName);
                    }
                    if (this.operativeDescription == null) {
                        this.operativeInjectionPoint = injectionPoint;
                        this.operativeDescription = String.format("map property prefix '%s'", fullName);
                        break;
                    }
                    this.problems.addError("Map property prefix '%s' conflicts with %s", fullName, this.operativeDescription);
                    break;
                }
                for (String key : ConfigurationFactory.this.applicationDefaults.keySet()) {
                    if (!key.startsWith(mapPrefix)) continue;
                    this.problems.addError("Cannot have application default property '%s' for a configuration map '%s'", key, fullName);
                }
            } else {
                String value;
                if (ConfigurationFactory.this.applicationDefaults.get(fullName) != null) {
                    if (isLegacy) {
                        this.defaultLegacy(fullName);
                    } else {
                        this.defaultInjectionPoint = injectionPoint;
                    }
                }
                if ((value = (String)ConfigurationFactory.this.properties.get(fullName)) != null) {
                    if (isLegacy) {
                        this.warnLegacy(fullName);
                    }
                    if (this.operativeDescription == null) {
                        this.operativeInjectionPoint = injectionPoint;
                        StringBuilder stringBuilder = new StringBuilder("property '").append(fullName).append("'");
                        if (!this.attribute.isSecuritySensitive()) {
                            stringBuilder.append(" (=").append(value).append(")");
                        }
                        this.operativeDescription = stringBuilder.toString();
                    } else {
                        StringBuilder stringBuilder = new StringBuilder("Configuration property '").append(fullName).append("'");
                        if (!this.attribute.isSecuritySensitive()) {
                            stringBuilder.append(" (=").append(value).append(")");
                        }
                        stringBuilder.append(" conflicts with ").append(this.operativeDescription);
                        this.problems.addError(stringBuilder.toString(), new Object[0]);
                    }
                }
            }
        }

        private void warnLegacy(String fullName) {
            this.problems.addWarning("Configuration %s", this.getLegacyDescription(fullName));
        }

        private void defaultLegacy(String fullName) {
            this.problems.addError("Application default %s", this.getLegacyDescription(fullName));
        }

        private String getLegacyDescription(String fullName) {
            String replacement = "deprecated.";
            if (this.attribute.getInjectionPoint() != null) {
                replacement = String.format("replaced. Use '%s' instead.", this.prefix + this.attribute.getInjectionPoint().getProperty());
            }
            return String.format("property '%s' has been %s", fullName, replacement);
        }
    }
}

