/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.configuration;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.ImmutableSortedSet;
import com.google.inject.Key;
import com.proofpoint.configuration.ConfigurationFactory;
import com.proofpoint.configuration.ConfigurationMetadata;
import com.proofpoint.configuration.ConfigurationProvider;
import com.proofpoint.configuration.MapClasses;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.SortedSet;

public class ConfigurationInspector {
    public SortedSet<ConfigRecord<?>> inspect(ConfigurationFactory configurationFactory) {
        ImmutableSortedSet.Builder builder = ImmutableSortedSet.naturalOrder();
        for (ConfigurationProvider<?> configurationProvider : configurationFactory.getConfigurationProviders()) {
            builder.add(ConfigRecord.createConfigRecord(configurationProvider));
        }
        return builder.build();
    }

    private static <T> T newDefaultInstance(ConfigurationMetadata<T> configurationMetadata) {
        try {
            return configurationMetadata.getConstructor().newInstance(new Object[0]);
        }
        catch (Throwable ignored) {
            return null;
        }
    }

    private static String getValue(Method getter, Object instance, String defaultValue) {
        if (getter == null || instance == null) {
            return defaultValue;
        }
        try {
            Object value = getter.invoke(instance, new Object[0]);
            if (value == null) {
                return "null";
            }
            return value.toString();
        }
        catch (Throwable e) {
            return "-- ERROR --";
        }
    }

    public static class ConfigAttribute
    implements Comparable<ConfigAttribute> {
        private final String attributeName;
        private final String propertyName;
        private final String defaultValue;
        private final String currentValue;
        private final String description;

        private ConfigAttribute(String attributeName, String propertyName, String defaultValue, String currentValue, String description, boolean securitySensitive) {
            Preconditions.checkNotNull((Object)attributeName, (Object)"attributeName");
            Preconditions.checkNotNull((Object)propertyName, (Object)"propertyName");
            Preconditions.checkNotNull((Object)defaultValue, (Object)"defaultValue");
            Preconditions.checkNotNull((Object)currentValue, (Object)"currentValue");
            Preconditions.checkNotNull((Object)description, (Object)"description");
            this.attributeName = attributeName;
            this.propertyName = propertyName;
            this.defaultValue = securitySensitive && defaultValue != null ? "[REDACTED]" : defaultValue;
            this.currentValue = securitySensitive && currentValue != null ? "[REDACTED]" : currentValue;
            this.description = description;
        }

        public String getAttributeName() {
            return this.attributeName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public String getCurrentValue() {
            return this.currentValue;
        }

        public String getDescription() {
            return this.description;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConfigAttribute that = (ConfigAttribute)o;
            return this.attributeName.equals(that.attributeName);
        }

        public int hashCode() {
            return this.attributeName.hashCode();
        }

        @Override
        public int compareTo(ConfigAttribute that) {
            return this.attributeName.compareTo(that.attributeName);
        }

        public String toString() {
            return Objects.toStringHelper((Object)this).add("attributeName", (Object)this.attributeName).add("propertyName", (Object)this.propertyName).add("defaultValue", (Object)this.defaultValue).add("currentValue", (Object)this.currentValue).add("description", (Object)this.description).toString();
        }
    }

    public static class ConfigRecord<T>
    implements Comparable<ConfigRecord<?>> {
        private final Key<T> key;
        private final Class<T> configClass;
        private final String prefix;
        private final SortedSet<ConfigAttribute> attributes;

        public static <T> ConfigRecord<T> createConfigRecord(ConfigurationProvider<T> configurationProvider) {
            return new ConfigRecord<T>(configurationProvider);
        }

        private ConfigRecord(ConfigurationProvider<T> configurationProvider) {
            Preconditions.checkNotNull(configurationProvider, (Object)"configurationProvider");
            this.key = configurationProvider.getKey();
            this.configClass = configurationProvider.getConfigClass();
            this.prefix = configurationProvider.getPrefix();
            ConfigurationMetadata<T> metadata = configurationProvider.getConfigurationMetadata();
            T instance = null;
            try {
                instance = configurationProvider.get();
            }
            catch (Throwable ignored) {
                // empty catch block
            }
            T defaults = null;
            try {
                defaults = configurationProvider.getDefaults();
            }
            catch (Throwable ignored) {
                // empty catch block
            }
            String prefix = configurationProvider.getPrefix();
            prefix = prefix == null ? "" : prefix + ".";
            ImmutableSortedSet.Builder builder = ImmutableSortedSet.naturalOrder();
            ConfigRecord.enumerateConfig(metadata, instance, defaults, prefix, (ImmutableSortedSet.Builder<ConfigAttribute>)builder, "");
            this.attributes = builder.build();
        }

        private static <T> void enumerateConfig(ConfigurationMetadata<T> metadata, T instance, T defaults, String prefix, ImmutableSortedSet.Builder<ConfigAttribute> builder, String attributePrefix) {
            for (ConfigurationMetadata.AttributeMetadata attribute : metadata.getAttributes().values()) {
                String propertyName = prefix + attribute.getInjectionPoint().getProperty();
                Method getter = attribute.getGetter();
                String description = (String)Objects.firstNonNull((Object)attribute.getDescription(), (Object)"");
                MapClasses mapClasses = attribute.getMapClasses();
                if (getter != null && instance != null && !attribute.isSecuritySensitive() && mapClasses != null) {
                    Class<?> valueClass = mapClasses.getValue();
                    Class<?> valueConfigClass = null;
                    if (ConfigurationMetadata.isConfigClass(valueClass)) {
                        valueConfigClass = valueClass;
                    }
                    ConfigRecord.enumerateMap(instance, attributePrefix + attribute.getName(), propertyName, description, getter, valueConfigClass, builder);
                    continue;
                }
                String defaultValue = ConfigurationInspector.getValue(getter, defaults, "-- none --");
                String currentValue = ConfigurationInspector.getValue(getter, instance, "-- n/a --");
                builder.add((Object)new ConfigAttribute(attributePrefix + attribute.getName(), propertyName, defaultValue, currentValue, description, attribute.isSecuritySensitive()));
            }
        }

        private static <T, K, V> void enumerateMap(T instance, String attributeName, String propertyName, String description, Method getter, Class<V> valueConfigClass, ImmutableSortedSet.Builder<ConfigAttribute> builder) {
            Map map;
            try {
                map = (Map)getter.invoke(instance, new Object[0]);
            }
            catch (Throwable e) {
                builder.add((Object)new ConfigAttribute(attributeName, propertyName, "-- n/a --", "-- ERROR --", description, false));
                return;
            }
            if (map == null) {
                builder.add((Object)new ConfigAttribute(attributeName, propertyName, "-- n/a --", "null", description, false));
                return;
            }
            if (map.isEmpty()) {
                builder.add((Object)new ConfigAttribute(attributeName, propertyName, "-- n/a --", "-- empty --", description, false));
                return;
            }
            for (Map.Entry entry : map.entrySet()) {
                if (valueConfigClass != null) {
                    ConfigRecord.enumerateConfig(ConfigurationMetadata.getConfigurationMetadata(valueConfigClass), entry.getValue(), ConfigurationInspector.newDefaultInstance(ConfigurationMetadata.getConfigurationMetadata(valueConfigClass)), propertyName + "." + entry.getKey().toString() + ".", builder, attributeName + "[" + entry.getKey().toString() + "]");
                    continue;
                }
                builder.add((Object)new ConfigAttribute(attributeName + "[" + entry.getKey().toString() + "]", propertyName + "." + entry.getKey().toString(), "-- n/a --", entry.getValue().toString(), description, false));
            }
        }

        public String getComponentName() {
            Key<T> key = this.getKey();
            String componentName = "";
            if (key.getAnnotationType() != null) {
                componentName = "@" + key.getAnnotationType().getSimpleName() + " ";
            }
            componentName = componentName + key.getTypeLiteral();
            return componentName;
        }

        public Key<T> getKey() {
            return this.key;
        }

        public Class<T> getConfigClass() {
            return this.configClass;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public SortedSet<ConfigAttribute> getAttributes() {
            return this.attributes;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.configClass, this.prefix});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            ConfigRecord other = (ConfigRecord)obj;
            return Objects.equal(this.configClass, other.configClass) && Objects.equal((Object)this.prefix, (Object)other.prefix);
        }

        @Override
        public int compareTo(ConfigRecord<?> that) {
            return ComparisonChain.start().compare((Comparable)((Object)this.configClass.getCanonicalName()), (Comparable)((Object)that.configClass.getCanonicalName())).compare((Comparable)((Object)this.prefix), (Comparable)((Object)that.prefix)).result();
        }
    }
}

