/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.configuration;

import com.google.common.annotations.Beta;
import com.google.common.base.CaseFormat;
import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.UncheckedExecutionException;
import com.google.inject.ConfigurationException;
import com.google.inject.Key;
import com.proofpoint.configuration.ConfigurationDefaultingModule;
import com.proofpoint.configuration.ConfigurationIdentity;
import com.proofpoint.configuration.ConfigurationMetadata;
import com.proofpoint.configuration.DefunctConfig;
import com.proofpoint.configuration.InvalidConfigurationException;
import com.proofpoint.configuration.MapClasses;
import com.proofpoint.configuration.Problems;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.constraints.NotNull;
import org.apache.bval.jsr.ApacheValidationProvider;
import org.apache.bval.jsr.ApacheValidatorConfiguration;

public final class ConfigurationFactory {
    private static final Validator VALIDATOR = ((ApacheValidatorConfiguration)Validation.byProvider(ApacheValidationProvider.class).configure()).buildValidatorFactory().getValidator();
    private final Map<String, String> properties;
    private final Map<String, String> applicationDefaults;
    private final Map<String, String> moduleDefaults;
    private final ImmutableMap<String, ConfigurationDefaultingModule> moduleDefaultSource;
    private final Problems.Monitor monitor;
    private final Set<String> unusedProperties = Sets.newConcurrentHashSet();
    private final Collection<String> initialErrors;
    private final Set<ConfigurationIdentity<?>> registeredConfigs = Sets.newConcurrentHashSet();
    private final LoadingCache<Class<?>, ConfigurationMetadata<?>> metadataCache = CacheBuilder.newBuilder().build(new CacheLoader<Class<?>, ConfigurationMetadata<?>>(){

        public ConfigurationMetadata<?> load(Class<?> configClass) {
            return ConfigurationMetadata.getConfigurationMetadata(configClass, ConfigurationFactory.this.monitor);
        }
    });

    public ConfigurationFactory(Map<String, String> properties) {
        this(properties, (Map<String, String>)ImmutableMap.of(), (Map<String, String>)ImmutableMap.of(), (Map<String, ConfigurationDefaultingModule>)ImmutableMap.of(), properties.keySet(), (Collection<String>)ImmutableList.of(), Problems.NULL_MONITOR);
    }

    ConfigurationFactory(Map<String, String> properties, Map<String, String> applicationDefaults, Map<String, String> moduleDefaults, Map<String, ConfigurationDefaultingModule> moduleDefaultSource, Set<String> expectToUse, Collection<String> errors, Problems.Monitor monitor) {
        this.monitor = monitor;
        this.properties = ImmutableMap.copyOf(properties);
        this.applicationDefaults = ImmutableMap.copyOf(applicationDefaults);
        this.moduleDefaults = ImmutableMap.copyOf(moduleDefaults);
        this.moduleDefaultSource = ImmutableMap.copyOf(moduleDefaultSource);
        this.unusedProperties.addAll(expectToUse);
        this.initialErrors = ImmutableList.copyOf(errors);
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    @Beta
    public void consumeProperty(String property) {
        Objects.requireNonNull(property, "property is null");
        this.unusedProperties.remove(property);
    }

    Set<String> getUnusedProperties() {
        return ImmutableSortedSet.copyOf(this.unusedProperties);
    }

    Problems.Monitor getMonitor() {
        return this.monitor;
    }

    Collection<String> getInitialErrors() {
        return this.initialErrors;
    }

    Iterable<ConfigurationIdentity<?>> getRegisteredConfigs() {
        return ImmutableList.copyOf(this.registeredConfigs);
    }

    public <T> T build(Class<T> configClass) {
        return this.build(configClass, null, null);
    }

    public <T> T build(Class<T> configClass, @Nullable String prefix) {
        return this.build(configClass, prefix, null);
    }

    <T> T build(Class<T> configClass, @Nullable String prefix, Key<T> key) {
        Problems problems = this.registeredConfigs.add(ConfigurationIdentity.configurationIdentity(configClass, prefix, key)) ? new Problems(this.monitor) : new Problems();
        T instance = this.build(configClass, prefix, false, problems);
        problems.throwIfHasErrors();
        return instance;
    }

    <T> T buildDefaults(Class<T> configClass, @Nullable String prefix) {
        return this.build(configClass, prefix, true, new Problems());
    }

    private <T> T build(Class<T> configClass, String prefix, boolean isDefault, Problems problems) {
        Objects.requireNonNull(configClass, "configClass is null");
        if (prefix == null) {
            prefix = "";
        } else if (!prefix.isEmpty()) {
            prefix = prefix + ".";
        }
        ConfigurationMetadata<T> configurationMetadata = this.getMetadata(configClass);
        configurationMetadata.getProblems().throwIfHasErrors();
        T instance = ConfigurationFactory.newInstance(configurationMetadata);
        for (ConfigurationMetadata.AttributeMetadata attribute : configurationMetadata.getAttributes().values()) {
            try {
                this.setConfigProperty(instance, attribute, prefix, isDefault, problems);
            }
            catch (InvalidConfigurationException e) {
                problems.addError(e.getCause(), e.getMessage(), new Object[0]);
            }
        }
        if (isDefault) {
            return instance;
        }
        if (configClass.isAnnotationPresent(DefunctConfig.class)) {
            for (String value : configClass.getAnnotation(DefunctConfig.class).value()) {
                String key = prefix + (String)value;
                if (!value.isEmpty() && this.properties.get(key) != null) {
                    problems.addError("Defunct property '%s' (class [%s]) cannot be configured.", key, configClass.toString());
                }
                if (!value.isEmpty() && this.applicationDefaults.get(key) != null) {
                    problems.addError("Defunct property '%s' (class [%s]) cannot have an application default.", key, configClass.toString());
                }
                if (value.isEmpty() || this.moduleDefaults.get(key) == null) continue;
                problems.addError("Defunct property '%s' (class [%s]) cannot have a module default (from %s).", key, configClass.toString(), this.moduleDefaultSource.get((Object)key));
            }
        }
        for (ConstraintViolation violation : VALIDATOR.validate(instance, new Class[0])) {
            ConfigurationMetadata.AttributeMetadata attributeMetadata = configurationMetadata.getAttributes().get(CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, violation.getPropertyPath().toString()));
            if (attributeMetadata == null || attributeMetadata.getInjectionPoint() == null) {
                problems.addError("Invalid configuration property with prefix '%s': %s (for class %s.%s)", prefix, violation.getMessage(), configClass.getName(), violation.getPropertyPath());
                continue;
            }
            if (violation.getConstraintDescriptor().getAnnotation() instanceof NotNull) {
                problems.addError("Missing required configuration property '%s' (for class %s.%s)", prefix + attributeMetadata.getInjectionPoint().getProperty(), configClass.getName(), violation.getPropertyPath());
                continue;
            }
            problems.addError("Invalid configuration property '%s': %s (for class %s.%s)", prefix + attributeMetadata.getInjectionPoint().getProperty(), violation.getMessage(), configClass.getName(), violation.getPropertyPath());
        }
        return instance;
    }

    private <T> ConfigurationMetadata<T> getMetadata(Class<T> configClass) {
        try {
            return (ConfigurationMetadata)this.metadataCache.getUnchecked(configClass);
        }
        catch (UncheckedExecutionException e) {
            throw Throwables.propagate((Throwable)e.getCause());
        }
    }

    private static <T> T newInstance(ConfigurationMetadata<T> configurationMetadata) {
        try {
            return configurationMetadata.getConstructor().newInstance(new Object[0]);
        }
        catch (Throwable e) {
            if (e instanceof InvocationTargetException && e.getCause() != null) {
                e = e.getCause();
            }
            throw Problems.exceptionFor(e, "Error creating instance of configuration class [%s]", configurationMetadata.getConfigClass().getName());
        }
    }

    private <T> void setConfigProperty(T instance, ConfigurationMetadata.AttributeMetadata attribute, String prefix, boolean isDefault, Problems problems) throws InvalidConfigurationException {
        ConfigurationMetadata.InjectionPointMetaData injectionPoint = this.findOperativeInjectionPoint(attribute, prefix, isDefault, problems);
        if (injectionPoint == null) {
            return;
        }
        Object value = this.getInjectedValue(attribute, injectionPoint, prefix, isDefault, problems);
        try {
            injectionPoint.getSetter().invoke(instance, value);
        }
        catch (Throwable e) {
            if (e instanceof InvocationTargetException && e.getCause() != null) {
                e = e.getCause();
            }
            throw new InvalidConfigurationException(e, "Error invoking configuration method [%s]", injectionPoint.getSetter().toGenericString());
        }
    }

    private ConfigurationMetadata.InjectionPointMetaData findOperativeInjectionPoint(ConfigurationMetadata.AttributeMetadata attribute, String prefix, boolean isDefault, Problems problems) throws ConfigurationException {
        OperativeInjectionData operativeInjectionData = new OperativeInjectionData(attribute, prefix, problems);
        operativeInjectionData.consider(attribute.getInjectionPoint(), false);
        for (ConfigurationMetadata.InjectionPointMetaData injectionPoint : attribute.getLegacyInjectionPoints()) {
            operativeInjectionData.consider(injectionPoint, true);
        }
        if (!isDefault) {
            problems.throwIfHasErrors();
            ConfigurationMetadata.InjectionPointMetaData injectionPoint = operativeInjectionData.operativeInjectionPoint;
            if (injectionPoint != null) {
                if (injectionPoint.getSetter().isAnnotationPresent(Deprecated.class)) {
                    problems.addWarning("Configuration property '%s' is deprecated and should not be used", prefix + injectionPoint.getProperty());
                }
                return injectionPoint;
            }
        }
        return operativeInjectionData.defaultInjectionPoint;
    }

    private Object getInjectedValue(ConfigurationMetadata.AttributeMetadata attribute, ConfigurationMetadata.InjectionPointMetaData injectionPoint, String prefix, boolean isDefault, Problems problems) throws InvalidConfigurationException {
        String name = prefix + injectionPoint.getProperty();
        MapClasses mapClasses = injectionPoint.getMapClasses();
        if (mapClasses != null) {
            return this.getInjectedMap(attribute, injectionPoint, name + ".", problems, mapClasses.getKey(), mapClasses.getValue());
        }
        String value = this.properties.get(name);
        if (isDefault || value == null) {
            value = this.applicationDefaults.get(name);
        }
        if (value == null) {
            value = this.moduleDefaults.get(name);
        }
        if (value == null) {
            return null;
        }
        Class<?> propertyType = injectionPoint.getSetter().getParameterTypes()[0];
        Object finalValue = ConfigurationFactory.coerce(propertyType, value);
        String valueDescription = attribute.isSecuritySensitive() ? "" : " '" + value + "'";
        if (finalValue == null) {
            throw new InvalidConfigurationException(String.format("Could not coerce value%s to %s (property '%s') in order to call [%s]", valueDescription, propertyType.getName(), name, injectionPoint.getSetter().toGenericString()), new Object[0]);
        }
        this.unusedProperties.remove(name);
        return finalValue;
    }

    private <K, V> Map<K, V> getInjectedMap(ConfigurationMetadata.AttributeMetadata attribute, ConfigurationMetadata.InjectionPointMetaData injectionPoint, String name, Problems problems, Class<K> keyClass, Class<V> valueClass) {
        boolean valueIsConfigClass = ConfigurationMetadata.isConfigClass(valueClass);
        HashSet<String> keySet = new HashSet<String>();
        for (String key : this.properties.keySet()) {
            if (!key.startsWith(name)) continue;
            String keySuffix = key.substring(name.length());
            if (valueIsConfigClass) {
                keySet.add(keySuffix.split("\\.", 2)[0]);
                continue;
            }
            if (keySuffix.contains(".")) {
                problems.addError("Configuration map has non-configuration value class %s, so key '%s' cannot be followed by '.' (property '%s') for call [%s]", valueClass.getName(), keySuffix.split("\\.", 2)[0], key, injectionPoint.getSetter().toGenericString());
                continue;
            }
            keySet.add(keySuffix);
        }
        HashMap<Object, String> coercedKeyMap = new HashMap<Object, String>();
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (String keyString : keySet) {
            Object value;
            Object key;
            block10: {
                key = ConfigurationFactory.coerce(keyClass, keyString);
                if (key == null) {
                    problems.addError("Could not coerce map key '%s' to %s (property%s '%s') in order to call [%s]", keyString, keyClass.getName(), valueIsConfigClass ? " prefix" : "", name + keyString, injectionPoint.getSetter().toGenericString());
                    continue;
                }
                String oldkeyString = coercedKeyMap.put(key, keyString);
                if (oldkeyString != null) {
                    problems.addError("Configuration property prefixes ('%s' and '%s') convert to the same map key, preventing creation of map for call [%s]", name + oldkeyString, name + keyString, injectionPoint.getSetter().toGenericString());
                    continue;
                }
                if (valueIsConfigClass) {
                    try {
                        value = this.build(valueClass, name + keyString, false, problems);
                        break block10;
                    }
                    catch (ConfigurationException ignored) {
                        continue;
                    }
                }
                value = ConfigurationFactory.coerce(valueClass, this.properties.get(name + keyString));
                if (value == null) {
                    String valueDescription = attribute.isSecuritySensitive() ? "" : " '" + this.properties.get(name + keyString) + "'";
                    problems.addError("Could not coerce value%s to %s (property '%s') in order to call [%s]", valueDescription, valueClass.getName(), name + keyString, injectionPoint.getSetter().toGenericString());
                    continue;
                }
                this.unusedProperties.remove(name + keyString);
            }
            builder.put(key, value);
        }
        return builder.build();
    }

    private static Object coerce(Class<?> type, String value) {
        if (type.isPrimitive() && value == null) {
            return null;
        }
        try {
            if (String.class.isAssignableFrom(type)) {
                return value;
            }
            if (Boolean.class.isAssignableFrom(type) || Boolean.TYPE.isAssignableFrom(type)) {
                if ("true".equalsIgnoreCase(value)) {
                    return true;
                }
                if ("false".equalsIgnoreCase(value)) {
                    return false;
                }
                return null;
            }
            if (Byte.class.isAssignableFrom(type) || Byte.TYPE.isAssignableFrom(type)) {
                return Byte.valueOf(value);
            }
            if (Short.class.isAssignableFrom(type) || Short.TYPE.isAssignableFrom(type)) {
                return Short.valueOf(value);
            }
            if (Integer.class.isAssignableFrom(type) || Integer.TYPE.isAssignableFrom(type)) {
                return Integer.valueOf(value);
            }
            if (Long.class.isAssignableFrom(type) || Long.TYPE.isAssignableFrom(type)) {
                return Long.valueOf(value);
            }
            if (Float.class.isAssignableFrom(type) || Float.TYPE.isAssignableFrom(type)) {
                return Float.valueOf(value);
            }
            if (Double.class.isAssignableFrom(type) || Double.TYPE.isAssignableFrom(type)) {
                return Double.valueOf(value);
            }
        }
        catch (Exception ignored) {
            return null;
        }
        try {
            Method fromString = type.getMethod("fromString", String.class);
            if (fromString.getReturnType().isAssignableFrom(type)) {
                return fromString.invoke(null, value);
            }
        }
        catch (Throwable fromString) {
            // empty catch block
        }
        try {
            Method valueOf = type.getMethod("valueOf", String.class);
            if (valueOf.getReturnType().isAssignableFrom(type)) {
                return valueOf.invoke(null, value);
            }
        }
        catch (Throwable valueOf) {
            // empty catch block
        }
        try {
            Constructor<?> constructor = type.getConstructor(String.class);
            return constructor.newInstance(value);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private class OperativeInjectionData {
        private final ConfigurationMetadata.AttributeMetadata attribute;
        private final String prefix;
        private final Problems problems;
        private String operativeDescription = null;
        ConfigurationMetadata.InjectionPointMetaData operativeInjectionPoint = null;
        ConfigurationMetadata.InjectionPointMetaData defaultInjectionPoint = null;

        OperativeInjectionData(ConfigurationMetadata.AttributeMetadata attribute, String prefix, Problems problems) {
            this.attribute = attribute;
            this.prefix = prefix;
            this.problems = problems;
        }

        public void consider(ConfigurationMetadata.InjectionPointMetaData injectionPoint, boolean isLegacy) {
            if (injectionPoint == null) {
                return;
            }
            String fullName = this.prefix + injectionPoint.getProperty();
            if (injectionPoint.isConfigMap()) {
                String mapPrefix = fullName + ".";
                for (String key : ConfigurationFactory.this.properties.keySet()) {
                    if (!key.startsWith(mapPrefix)) continue;
                    if (isLegacy) {
                        this.warnLegacy(fullName);
                    }
                    if (this.operativeDescription == null) {
                        this.operativeInjectionPoint = injectionPoint;
                        this.operativeDescription = String.format("map property prefix '%s'", fullName);
                        break;
                    }
                    this.problems.addError("Map property prefix '%s' conflicts with %s", fullName, this.operativeDescription);
                    break;
                }
                for (String key : ConfigurationFactory.this.applicationDefaults.keySet()) {
                    if (!key.startsWith(mapPrefix)) continue;
                    this.problems.addError("Cannot have application default property '%s' for a configuration map '%s'", key, fullName);
                }
                for (String key : ConfigurationFactory.this.moduleDefaults.keySet()) {
                    if (!key.startsWith(mapPrefix)) continue;
                    this.problems.addError("Cannot have module default property '%s' (from %s) for a configuration map '%s'", key, ConfigurationFactory.this.moduleDefaultSource.get((Object)key), fullName);
                }
            } else {
                String value;
                if (ConfigurationFactory.this.moduleDefaults.get(fullName) != null) {
                    if (isLegacy) {
                        this.problems.addError("Module default %s", this.getLegacyDescription(fullName, (ConfigurationDefaultingModule)ConfigurationFactory.this.moduleDefaultSource.get((Object)fullName)));
                    } else {
                        this.defaultInjectionPoint = injectionPoint;
                    }
                }
                if (ConfigurationFactory.this.applicationDefaults.get(fullName) != null) {
                    if (isLegacy) {
                        this.problems.addError("Application default %s", this.getLegacyDescription(fullName, null));
                    } else {
                        this.defaultInjectionPoint = injectionPoint;
                    }
                }
                if ((value = (String)ConfigurationFactory.this.properties.get(fullName)) != null) {
                    if (isLegacy) {
                        this.warnLegacy(fullName);
                    }
                    if (this.operativeDescription == null) {
                        this.operativeInjectionPoint = injectionPoint;
                        StringBuilder stringBuilder = new StringBuilder("property '").append(fullName).append("'");
                        if (!this.attribute.isSecuritySensitive()) {
                            stringBuilder.append(" (=").append(value).append(")");
                        }
                        this.operativeDescription = stringBuilder.toString();
                    } else {
                        StringBuilder stringBuilder = new StringBuilder("Configuration property '").append(fullName).append("'");
                        if (!this.attribute.isSecuritySensitive()) {
                            stringBuilder.append(" (=").append(value).append(")");
                        }
                        stringBuilder.append(" conflicts with ").append(this.operativeDescription);
                        this.problems.addError(stringBuilder.toString(), new Object[0]);
                    }
                }
            }
        }

        private void warnLegacy(String fullName) {
            this.problems.addWarning("Configuration %s", this.getLegacyDescription(fullName, null));
        }

        private String getLegacyDescription(String fullName, ConfigurationDefaultingModule configurationDefaultingModule) {
            String source = "";
            if (configurationDefaultingModule != null) {
                source = String.format(" (from %s)", configurationDefaultingModule);
            }
            String replacement = "deprecated.";
            if (this.attribute.getInjectionPoint() != null) {
                replacement = String.format("replaced. Use '%s' instead.", this.prefix + this.attribute.getInjectionPoint().getProperty());
            }
            return String.format("property '%s'%s has been %s", fullName, source, replacement);
        }
    }
}

