/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.discovery.client;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.proofpoint.discovery.client.ServiceDescriptor;
import com.proofpoint.discovery.client.ServiceDescriptorsListener;
import com.proofpoint.discovery.client.ServiceSelector;
import com.proofpoint.discovery.client.ServiceSelectorConfig;
import com.proofpoint.node.NodeInfo;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

public class CachingServiceSelector
implements ServiceSelector,
ServiceDescriptorsListener {
    private final String type;
    private final String pool;
    private final AtomicReference<List<ServiceDescriptor>> serviceDescriptors = new AtomicReference<ImmutableList>(ImmutableList.of());

    public CachingServiceSelector(String type, ServiceSelectorConfig selectorConfig, NodeInfo nodeInfo) {
        Preconditions.checkNotNull((Object)type, (Object)"type is null");
        Preconditions.checkNotNull((Object)selectorConfig, (Object)"selectorConfig is null");
        Preconditions.checkNotNull((Object)nodeInfo, (Object)"nodeInfo is null");
        this.type = type;
        this.pool = (String)Objects.firstNonNull((Object)selectorConfig.getPool(), (Object)nodeInfo.getPool());
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getPool() {
        return this.pool;
    }

    @Override
    public List<ServiceDescriptor> selectAllServices() {
        return this.serviceDescriptors.get();
    }

    @Override
    public void updateServiceDescriptors(Iterable<ServiceDescriptor> newDescriptors) {
        this.serviceDescriptors.set((List<ServiceDescriptor>)ImmutableList.copyOf((Iterable)((Iterable)Preconditions.checkNotNull(newDescriptors))));
    }
}

