/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.discovery.client;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import com.proofpoint.discovery.client.CachingServiceSelector;
import com.proofpoint.discovery.client.DiscoveryLookupClient;
import com.proofpoint.discovery.client.ForDiscoveryClient;
import com.proofpoint.discovery.client.ServiceDescriptorsUpdater;
import com.proofpoint.discovery.client.ServiceSelector;
import com.proofpoint.discovery.client.ServiceSelectorConfig;
import com.proofpoint.discovery.client.ServiceSelectorFactory;
import com.proofpoint.node.NodeInfo;
import java.util.concurrent.ScheduledExecutorService;

public class CachingServiceSelectorFactory
implements ServiceSelectorFactory {
    private final DiscoveryLookupClient lookupClient;
    private final ScheduledExecutorService executor;
    private final NodeInfo nodeInfo;

    @Inject
    public CachingServiceSelectorFactory(DiscoveryLookupClient lookupClient, @ForDiscoveryClient ScheduledExecutorService executor, NodeInfo nodeInfo) {
        Preconditions.checkNotNull((Object)lookupClient, (Object)"client is null");
        Preconditions.checkNotNull((Object)executor, (Object)"executor is null");
        Preconditions.checkNotNull((Object)nodeInfo, (Object)"nodeInfo is null");
        this.lookupClient = lookupClient;
        this.executor = executor;
        this.nodeInfo = nodeInfo;
    }

    @Override
    public ServiceSelector createServiceSelector(String type, ServiceSelectorConfig selectorConfig) {
        Preconditions.checkNotNull((Object)type, (Object)"type is null");
        Preconditions.checkNotNull((Object)selectorConfig, (Object)"selectorConfig is null");
        CachingServiceSelector serviceSelector = new CachingServiceSelector(type, selectorConfig, this.nodeInfo);
        ServiceDescriptorsUpdater updater = new ServiceDescriptorsUpdater(serviceSelector, type, selectorConfig, this.nodeInfo, this.lookupClient, this.executor);
        updater.start();
        return serviceSelector;
    }
}

