/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.discovery.client;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Key;
import com.google.inject.PrivateBinder;
import com.google.inject.Provider;
import com.google.inject.Scopes;
import com.google.inject.binder.LinkedBindingBuilder;
import com.google.inject.multibindings.Multibinder;
import com.proofpoint.configuration.ConfigurationModule;
import com.proofpoint.discovery.client.HttpServiceSelector;
import com.proofpoint.discovery.client.HttpServiceSelectorProvider;
import com.proofpoint.discovery.client.ServiceSelector;
import com.proofpoint.discovery.client.ServiceSelectorConfig;
import com.proofpoint.discovery.client.ServiceSelectorProvider;
import com.proofpoint.discovery.client.ServiceType;
import com.proofpoint.discovery.client.ServiceTypes;
import com.proofpoint.discovery.client.announce.AnnouncementHttpServerInfo;
import com.proofpoint.discovery.client.announce.ServiceAnnouncement;
import com.proofpoint.discovery.client.balancing.HttpServiceBalancerProvider;
import com.proofpoint.http.client.AsyncHttpClient;
import com.proofpoint.http.client.HttpClient;
import com.proofpoint.http.client.HttpClientBinder;
import com.proofpoint.http.client.HttpRequestFilter;
import com.proofpoint.http.client.balancing.BalancingAsyncHttpClient;
import com.proofpoint.http.client.balancing.BalancingHttpClient;
import com.proofpoint.http.client.balancing.BalancingHttpClientConfig;
import com.proofpoint.http.client.balancing.ForBalancingHttpClient;
import com.proofpoint.http.client.balancing.HttpServiceBalancer;
import com.proofpoint.reporting.ReportBinder;
import java.lang.annotation.Annotation;

public class DiscoveryBinder {
    private final Multibinder<ServiceAnnouncement> serviceAnnouncementBinder;
    private final Binder binder;

    public static DiscoveryBinder discoveryBinder(Binder binder) {
        Preconditions.checkNotNull((Object)binder, (Object)"binder is null");
        return new DiscoveryBinder(binder);
    }

    protected DiscoveryBinder(Binder binder) {
        Preconditions.checkNotNull((Object)binder, (Object)"binder is null");
        this.binder = binder;
        this.serviceAnnouncementBinder = Multibinder.newSetBinder((Binder)binder, ServiceAnnouncement.class);
    }

    public void bindSelector(String type) {
        Preconditions.checkNotNull((Object)type, (Object)"type is null");
        this.bindSelector(ServiceTypes.serviceType(type));
    }

    public void bindSelector(ServiceType serviceType) {
        Preconditions.checkNotNull((Object)serviceType, (Object)"serviceType is null");
        ConfigurationModule.bindConfig((Binder)this.binder).annotatedWith((Annotation)serviceType).prefixedWith("discovery." + serviceType.value()).to(ServiceSelectorConfig.class);
        this.binder.bind(ServiceSelector.class).annotatedWith((Annotation)serviceType).toProvider((Provider)new ServiceSelectorProvider(serviceType.value())).in(Scopes.SINGLETON);
    }

    public void bindHttpBalancer(String type) {
        Preconditions.checkNotNull((Object)type, (Object)"type is null");
        this.bindHttpBalancer(ServiceTypes.serviceType(type));
    }

    public void bindHttpBalancer(ServiceType serviceType) {
        Preconditions.checkNotNull((Object)serviceType, (Object)"serviceType is null");
        ConfigurationModule.bindConfig((Binder)this.binder).annotatedWith((Annotation)serviceType).prefixedWith("discovery." + serviceType.value()).to(ServiceSelectorConfig.class);
        this.binder.bind(HttpServiceBalancer.class).annotatedWith((Annotation)serviceType).toProvider((Provider)new HttpServiceBalancerProvider(serviceType.value())).in(Scopes.SINGLETON);
    }

    public void bindServiceAnnouncement(ServiceAnnouncement announcement) {
        Preconditions.checkNotNull((Object)announcement, (Object)"announcement is null");
        this.serviceAnnouncementBinder.addBinding().toInstance((Object)announcement);
    }

    public void bindServiceAnnouncement(Provider<ServiceAnnouncement> announcementProvider) {
        Preconditions.checkNotNull(announcementProvider, (Object)"announcementProvider is null");
        this.serviceAnnouncementBinder.addBinding().toProvider(announcementProvider);
    }

    public <T extends ServiceAnnouncement> void bindServiceAnnouncement(Class<? extends Provider<T>> announcementProviderClass) {
        Preconditions.checkNotNull(announcementProviderClass, (Object)"announcementProviderClass is null");
        this.serviceAnnouncementBinder.addBinding().toProvider(announcementProviderClass);
    }

    public ServiceAnnouncement.ServiceAnnouncementBuilder bindHttpAnnouncement(String type) {
        ServiceAnnouncement.ServiceAnnouncementBuilder serviceAnnouncementBuilder = ServiceAnnouncement.serviceAnnouncement(type);
        this.bindServiceAnnouncement(new HttpAnnouncementProvider(serviceAnnouncementBuilder));
        return serviceAnnouncementBuilder;
    }

    @Deprecated
    public void bindHttpSelector(String type) {
        Preconditions.checkNotNull((Object)type, (Object)"type is null");
        this.bindHttpSelector(ServiceTypes.serviceType(type));
    }

    @Deprecated
    public void bindHttpSelector(ServiceType serviceType) {
        Preconditions.checkNotNull((Object)serviceType, (Object)"serviceType is null");
        this.bindSelector(serviceType);
        this.binder.bind(HttpServiceSelector.class).annotatedWith((Annotation)serviceType).toProvider((Provider)new HttpServiceSelectorProvider(serviceType.value())).in(Scopes.SINGLETON);
    }

    public BalancingHttpClientBindingBuilder bindDiscoveredHttpClient(String type) {
        return this.bindDiscoveredHttpClient((String)Preconditions.checkNotNull((Object)type, (Object)"type is null"), ServiceTypes.serviceType(type));
    }

    public BalancingHttpClientBindingBuilder bindDiscoveredHttpClient(String name, ServiceType serviceType) {
        Preconditions.checkNotNull((Object)name, (Object)"name is null");
        Preconditions.checkNotNull((Object)serviceType, (Object)"serviceType is null");
        this.bindHttpBalancer(serviceType);
        PrivateBinder privateBinder = this.binder.newPrivateBinder();
        privateBinder.bind(HttpServiceBalancer.class).annotatedWith(ForBalancingHttpClient.class).to(Key.get(HttpServiceBalancer.class, (Annotation)serviceType));
        HttpClientBinder.HttpClientBindingBuilder delegateBindingBuilder = HttpClientBinder.httpClientPrivateBinder((Binder)privateBinder, (Binder)this.binder).bindHttpClient(name, ForBalancingHttpClient.class);
        ConfigurationModule.bindConfig((Binder)privateBinder).prefixedWith(name).to(BalancingHttpClientConfig.class);
        privateBinder.bind(HttpClient.class).annotatedWith((Annotation)serviceType).to(BalancingHttpClient.class).in(Scopes.SINGLETON);
        privateBinder.expose(HttpClient.class).annotatedWith((Annotation)serviceType);
        ReportBinder.reportBinder((Binder)this.binder).export(HttpClient.class).annotatedWith((Annotation)serviceType).withGeneratedName();
        return new BalancingHttpClientBindingBuilder(this.binder, serviceType, delegateBindingBuilder);
    }

    public BalancingHttpClientBindingBuilder bindDiscoveredHttpClient(String type, Class<? extends Annotation> annotation) {
        return this.bindDiscoveredHttpClient(ServiceTypes.serviceType((String)Preconditions.checkNotNull((Object)type, (Object)"type is null")), annotation);
    }

    public BalancingHttpClientBindingBuilder bindDiscoveredHttpClient(ServiceType serviceType, Class<? extends Annotation> annotation) {
        return this.bindDiscoveredHttpClient(serviceType.value(), serviceType, annotation);
    }

    public BalancingHttpClientBindingBuilder bindDiscoveredHttpClient(String name, ServiceType serviceType, Class<? extends Annotation> annotation) {
        this.bindHttpBalancer(serviceType);
        return this.bindDiscoveredHttpClientWithBalancer(name, serviceType, annotation);
    }

    BalancingHttpClientBindingBuilder bindDiscoveredHttpClientWithBalancer(String name, ServiceType serviceType, Class<? extends Annotation> annotation) {
        Preconditions.checkNotNull((Object)name, (Object)"name is null");
        Preconditions.checkNotNull((Object)serviceType, (Object)"serviceType is null");
        Preconditions.checkNotNull(annotation, (Object)"annotation is null");
        PrivateBinder privateBinder = this.binder.newPrivateBinder();
        privateBinder.bind(HttpServiceBalancer.class).annotatedWith(ForBalancingHttpClient.class).to(Key.get(HttpServiceBalancer.class, (Annotation)serviceType));
        HttpClientBinder.HttpClientBindingBuilder delegateBindingBuilder = HttpClientBinder.httpClientPrivateBinder((Binder)privateBinder, (Binder)this.binder).bindHttpClient(name, ForBalancingHttpClient.class);
        ConfigurationModule.bindConfig((Binder)privateBinder).prefixedWith(name).to(BalancingHttpClientConfig.class);
        privateBinder.bind(HttpClient.class).annotatedWith(annotation).to(BalancingHttpClient.class).in(Scopes.SINGLETON);
        privateBinder.expose(HttpClient.class).annotatedWith(annotation);
        ReportBinder.reportBinder((Binder)this.binder).export(HttpClient.class).annotatedWith(annotation).withGeneratedName();
        return new BalancingHttpClientBindingBuilder(this.binder, annotation, delegateBindingBuilder);
    }

    @Deprecated
    public BalancingHttpClientAsyncBindingBuilder bindDiscoveredAsyncHttpClient(String type, Class<? extends Annotation> annotation) {
        return this.bindDiscoveredAsyncHttpClient(ServiceTypes.serviceType((String)Preconditions.checkNotNull((Object)type, (Object)"type is null")), annotation);
    }

    @Deprecated
    public BalancingHttpClientAsyncBindingBuilder bindDiscoveredAsyncHttpClient(ServiceType serviceType, Class<? extends Annotation> annotation) {
        Preconditions.checkNotNull((Object)serviceType, (Object)"serviceType is null");
        Preconditions.checkNotNull(annotation, (Object)"annotation is null");
        this.bindHttpBalancer(serviceType);
        PrivateBinder privateBinder = this.binder.newPrivateBinder();
        privateBinder.bind(HttpServiceBalancer.class).annotatedWith(ForBalancingHttpClient.class).to(Key.get(HttpServiceBalancer.class, (Annotation)serviceType));
        HttpClientBinder.HttpClientAsyncBindingBuilder delegateBindingBuilder = HttpClientBinder.httpClientPrivateBinder((Binder)privateBinder, (Binder)this.binder).bindAsyncHttpClient(serviceType.value(), ForBalancingHttpClient.class);
        ConfigurationModule.bindConfig((Binder)privateBinder).prefixedWith(serviceType.value()).to(BalancingHttpClientConfig.class);
        privateBinder.bind(AsyncHttpClient.class).annotatedWith(annotation).to(BalancingAsyncHttpClient.class).in(Scopes.SINGLETON);
        privateBinder.expose(AsyncHttpClient.class).annotatedWith(annotation);
        ReportBinder.reportBinder((Binder)this.binder).export(AsyncHttpClient.class).annotatedWith(annotation).withGeneratedName();
        return new BalancingHttpClientAsyncBindingBuilder(this.binder, annotation, delegateBindingBuilder);
    }

    protected static abstract class AbstractBalancingHttpClientBindingBuilder<T, B extends AbstractBalancingHttpClientBindingBuilder<T, B, D>, D extends HttpClientBinder.HttpClientAsyncBindingBuilder> {
        private final Binder binder;
        private final Class<T> aClass;
        private final Key<T> key;
        protected final D delegateBindingBuilder;

        protected AbstractBalancingHttpClientBindingBuilder(Binder binder, Class<T> aClass, Key<T> key, D delegateBindingBuilder) {
            this.binder = binder;
            this.aClass = aClass;
            this.key = key;
            this.delegateBindingBuilder = delegateBindingBuilder;
        }

        public B withAlias(Class<? extends Annotation> alias) {
            this.binder.bind(this.aClass).annotatedWith(alias).to(this.key);
            return (B)this;
        }

        public B withAliases(ImmutableList<Class<? extends Annotation>> aliases) {
            for (Class alias : aliases) {
                this.binder.bind(this.aClass).annotatedWith(alias).to(this.key);
            }
            return (B)this;
        }

        public LinkedBindingBuilder<HttpRequestFilter> addFilterBinding() {
            return this.delegateBindingBuilder.addFilterBinding();
        }

        public B withFilter(Class<? extends HttpRequestFilter> filterClass) {
            this.delegateBindingBuilder.withFilter(filterClass);
            return (B)this;
        }

        public B withTracing() {
            this.delegateBindingBuilder.withTracing();
            return (B)this;
        }

        public B withPrivateIoThreadPool() {
            this.delegateBindingBuilder.withPrivateIoThreadPool();
            return (B)this;
        }
    }

    public static class BalancingHttpClientAsyncBindingBuilder
    extends AbstractBalancingHttpClientBindingBuilder<AsyncHttpClient, BalancingHttpClientAsyncBindingBuilder, HttpClientBinder.HttpClientAsyncBindingBuilder> {
        public BalancingHttpClientAsyncBindingBuilder(Binder binder, Class<? extends Annotation> annotationType, HttpClientBinder.HttpClientAsyncBindingBuilder delegateBindingBuilder) {
            super(binder, AsyncHttpClient.class, Key.get(AsyncHttpClient.class, annotationType), delegateBindingBuilder);
        }
    }

    public static class BalancingHttpClientBindingBuilder
    extends AbstractBalancingHttpClientBindingBuilder<HttpClient, BalancingHttpClientBindingBuilder, HttpClientBinder.HttpClientAsyncBindingBuilder> {
        public BalancingHttpClientBindingBuilder(Binder binder, Class<? extends Annotation> annotationType, HttpClientBinder.HttpClientBindingBuilder delegateBindingBuilder) {
            super(binder, HttpClient.class, Key.get(HttpClient.class, annotationType), delegateBindingBuilder);
        }

        public BalancingHttpClientBindingBuilder(Binder binder, Annotation annotation, HttpClientBinder.HttpClientBindingBuilder delegateBindingBuilder) {
            super(binder, HttpClient.class, Key.get(HttpClient.class, (Annotation)annotation), delegateBindingBuilder);
        }
    }

    static class HttpAnnouncementProvider
    implements Provider<ServiceAnnouncement> {
        private final ServiceAnnouncement.ServiceAnnouncementBuilder builder;
        private AnnouncementHttpServerInfo httpServerInfo;

        HttpAnnouncementProvider(ServiceAnnouncement.ServiceAnnouncementBuilder serviceAnnouncementBuilder) {
            this.builder = serviceAnnouncementBuilder;
        }

        @Inject
        public void setAnnouncementHttpServerInfo(AnnouncementHttpServerInfo httpServerInfo) {
            this.httpServerInfo = httpServerInfo;
        }

        public ServiceAnnouncement get() {
            if (this.httpServerInfo.getHttpUri() != null) {
                this.builder.addProperty("http", this.httpServerInfo.getHttpUri().toString());
                this.builder.addProperty("http-external", this.httpServerInfo.getHttpExternalUri().toString());
            }
            if (this.httpServerInfo.getHttpsUri() != null) {
                this.builder.addProperty("https", this.httpServerInfo.getHttpsUri().toString());
            }
            return this.builder.build();
        }
    }
}

