/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.discovery.client;

import com.google.common.base.Preconditions;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.multibindings.Multibinder;
import com.proofpoint.concurrent.Threads;
import com.proofpoint.configuration.ConfigurationModule;
import com.proofpoint.discovery.client.CachingServiceSelectorFactory;
import com.proofpoint.discovery.client.DiscoveryBinder;
import com.proofpoint.discovery.client.DiscoveryClientConfig;
import com.proofpoint.discovery.client.DiscoveryLookupClient;
import com.proofpoint.discovery.client.ForDiscoveryClient;
import com.proofpoint.discovery.client.HttpDiscoveryLookupClient;
import com.proofpoint.discovery.client.ServiceDescriptorsRepresentation;
import com.proofpoint.discovery.client.ServiceInventory;
import com.proofpoint.discovery.client.ServiceInventoryConfig;
import com.proofpoint.discovery.client.ServiceSelectorFactory;
import com.proofpoint.discovery.client.ServiceType;
import com.proofpoint.discovery.client.ServiceTypes;
import com.proofpoint.discovery.client.announce.Announcement;
import com.proofpoint.discovery.client.announce.Announcer;
import com.proofpoint.discovery.client.announce.DiscoveryAnnouncementClient;
import com.proofpoint.discovery.client.announce.HttpDiscoveryAnnouncementClient;
import com.proofpoint.discovery.client.announce.ServiceAnnouncement;
import com.proofpoint.discovery.client.balancing.HttpServiceBalancerFactory;
import com.proofpoint.http.client.balancing.HttpServiceBalancer;
import com.proofpoint.http.client.balancing.HttpServiceBalancerImpl;
import com.proofpoint.http.client.balancing.HttpServiceBalancerStats;
import com.proofpoint.json.JsonCodecBinder;
import com.proofpoint.reporting.ReportCollectionFactory;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import javax.annotation.PreDestroy;
import org.weakref.jmx.ObjectNameBuilder;
import org.weakref.jmx.guice.ExportBinder;

public class DiscoveryModule
implements Module {
    private HttpServiceBalancerImpl discoveryBalancer = null;

    public void configure(Binder binder) {
        binder.bind(ServiceInventory.class).asEagerSingleton();
        ConfigurationModule.bindConfig((Binder)binder).to(ServiceInventoryConfig.class);
        ConfigurationModule.bindConfig((Binder)binder).to(DiscoveryClientConfig.class);
        binder.bind(DiscoveryLookupClient.class).to(HttpDiscoveryLookupClient.class).in(Scopes.SINGLETON);
        binder.bind(DiscoveryAnnouncementClient.class).to(HttpDiscoveryAnnouncementClient.class).in(Scopes.SINGLETON);
        JsonCodecBinder.jsonCodecBinder((Binder)binder).bindJsonCodec(ServiceDescriptorsRepresentation.class);
        JsonCodecBinder.jsonCodecBinder((Binder)binder).bindJsonCodec(Announcement.class);
        DiscoveryBinder.discoveryBinder(binder).bindDiscoveredHttpClientWithBalancer("discovery", ServiceTypes.serviceType("discovery"), ForDiscoveryClient.class);
        binder.bind(Announcer.class).in(Scopes.SINGLETON);
        Multibinder.newSetBinder((Binder)binder, ServiceAnnouncement.class);
        binder.bind(ServiceSelectorFactory.class).to(CachingServiceSelectorFactory.class).in(Scopes.SINGLETON);
        binder.bind(HttpServiceBalancerFactory.class).in(Scopes.SINGLETON);
        binder.bind(ScheduledExecutorService.class).annotatedWith(ForDiscoveryClient.class).toProvider(DiscoveryExecutorProvider.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(ServiceInventory.class).withGeneratedName();
    }

    @Provides
    @ServiceType(value="discovery")
    public HttpServiceBalancer createHttpServiceBalancer(ReportCollectionFactory reportCollectionFactory) {
        return this.getHttpServiceBalancerImpl(reportCollectionFactory);
    }

    @Provides
    @ServiceType(value="discovery")
    public synchronized HttpServiceBalancerImpl getHttpServiceBalancerImpl(ReportCollectionFactory reportCollectionFactory) {
        if (this.discoveryBalancer == null) {
            String name = new ObjectNameBuilder(HttpServiceBalancerStats.class.getPackage().getName()).withProperty("type", "ServiceClient").withProperty("serviceType", "discovery").build();
            this.discoveryBalancer = new HttpServiceBalancerImpl("discovery", (HttpServiceBalancerStats)reportCollectionFactory.createReportCollection(HttpServiceBalancerStats.class, name));
        }
        return this.discoveryBalancer;
    }

    private static class DiscoveryExecutorProvider
    implements Provider<ScheduledExecutorService> {
        private ScheduledExecutorService executor;

        private DiscoveryExecutorProvider() {
        }

        public ScheduledExecutorService get() {
            Preconditions.checkState((this.executor == null ? 1 : 0) != 0, (Object)"provider already used");
            this.executor = new ScheduledThreadPoolExecutor(5, Threads.daemonThreadsNamed((String)"Discovery-%s"));
            return this.executor;
        }

        @PreDestroy
        public void destroy() {
            if (this.executor != null) {
                this.executor.shutdownNow();
            }
        }
    }
}

