/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.discovery.client;

import com.google.common.base.Preconditions;
import com.google.common.io.ByteStreams;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.inject.Inject;
import com.proofpoint.discovery.client.DiscoveryException;
import com.proofpoint.discovery.client.DiscoveryLookupClient;
import com.proofpoint.discovery.client.ForDiscoveryClient;
import com.proofpoint.discovery.client.ServiceDescriptors;
import com.proofpoint.discovery.client.ServiceDescriptorsRepresentation;
import com.proofpoint.discovery.client.ServiceInventory;
import com.proofpoint.discovery.client.announce.DiscoveryAnnouncementClient;
import com.proofpoint.http.client.CacheControl;
import com.proofpoint.http.client.HttpClient;
import com.proofpoint.http.client.HttpStatus;
import com.proofpoint.http.client.Request;
import com.proofpoint.http.client.RequestStats;
import com.proofpoint.http.client.Response;
import com.proofpoint.http.client.ResponseHandler;
import com.proofpoint.json.JsonCodec;
import com.proofpoint.node.NodeInfo;
import com.proofpoint.units.Duration;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.concurrent.CancellationException;
import java.util.concurrent.TimeUnit;
import org.weakref.jmx.Flatten;

public class HttpDiscoveryLookupClient
implements DiscoveryLookupClient {
    private final String environment;
    private final NodeInfo nodeInfo;
    private final JsonCodec<ServiceDescriptorsRepresentation> serviceDescriptorsCodec;
    private final HttpClient httpClient;

    @Inject
    public HttpDiscoveryLookupClient(NodeInfo nodeInfo, JsonCodec<ServiceDescriptorsRepresentation> serviceDescriptorsCodec, @ForDiscoveryClient HttpClient httpClient, ServiceInventory serviceInventory) {
        Preconditions.checkNotNull((Object)nodeInfo, (Object)"nodeInfo is null");
        Preconditions.checkNotNull(serviceDescriptorsCodec, (Object)"serviceDescriptorsCodec is null");
        Preconditions.checkNotNull((Object)httpClient, (Object)"httpClient is null");
        this.nodeInfo = nodeInfo;
        this.environment = nodeInfo.getEnvironment();
        this.serviceDescriptorsCodec = serviceDescriptorsCodec;
        this.httpClient = httpClient;
    }

    @Flatten
    public RequestStats getStats() {
        return this.httpClient.getStats();
    }

    @Override
    public ListenableFuture<ServiceDescriptors> getServices(String type) {
        Preconditions.checkNotNull((Object)type, (Object)"type is null");
        return this.lookup(type, null, null);
    }

    @Override
    public ListenableFuture<ServiceDescriptors> getServices(String type, String pool) {
        Preconditions.checkNotNull((Object)type, (Object)"type is null");
        Preconditions.checkNotNull((Object)pool, (Object)"pool is null");
        return this.lookup(type, pool, null);
    }

    @Override
    public ListenableFuture<ServiceDescriptors> refreshServices(ServiceDescriptors serviceDescriptors) {
        Preconditions.checkNotNull((Object)serviceDescriptors, (Object)"serviceDescriptors is null");
        return this.lookup(serviceDescriptors.getType(), serviceDescriptors.getPool(), serviceDescriptors);
    }

    private ListenableFuture<ServiceDescriptors> lookup(final String type, final String pool, final ServiceDescriptors serviceDescriptors) {
        Preconditions.checkNotNull((Object)type, (Object)"type is null");
        URI uri = URI.create("v1/service/" + type + "/");
        if (pool != null) {
            uri = uri.resolve(pool);
        }
        Request.Builder requestBuilder = Request.Builder.prepareGet().setUri(uri).setHeader("User-Agent", this.nodeInfo.getNodeId());
        if (serviceDescriptors != null && serviceDescriptors.getETag() != null) {
            requestBuilder.setHeader("ETag", serviceDescriptors.getETag());
        }
        return this.httpClient.executeAsync(requestBuilder.build(), (ResponseHandler)new DiscoveryResponseHandler<ServiceDescriptors>(String.format("Lookup of %s", type)){

            @Override
            public ServiceDescriptors handle(Request request, Response response) {
                byte[] json;
                Duration maxAge = HttpDiscoveryLookupClient.this.extractMaxAge(response);
                String eTag = response.getHeader("ETag");
                if (HttpStatus.NOT_MODIFIED.code() == response.getStatusCode() && serviceDescriptors != null) {
                    return new ServiceDescriptors(serviceDescriptors, maxAge, eTag);
                }
                if (HttpStatus.OK.code() != response.getStatusCode()) {
                    throw new DiscoveryException(String.format("Lookup of %s failed with status code %s", type, response.getStatusCode()));
                }
                try {
                    json = ByteStreams.toByteArray((InputStream)response.getInputStream());
                }
                catch (IOException e) {
                    throw new DiscoveryException(String.format("Lookup of %s failed", type), e);
                }
                ServiceDescriptorsRepresentation serviceDescriptorsRepresentation = (ServiceDescriptorsRepresentation)HttpDiscoveryLookupClient.this.serviceDescriptorsCodec.fromJson(json);
                if (!HttpDiscoveryLookupClient.this.environment.equals(serviceDescriptorsRepresentation.getEnvironment())) {
                    throw new DiscoveryException(String.format("Expected environment to be %s, but was %s", HttpDiscoveryLookupClient.this.environment, serviceDescriptorsRepresentation.getEnvironment()));
                }
                return new ServiceDescriptors(type, pool, serviceDescriptorsRepresentation.getServiceDescriptors(), maxAge, eTag);
            }
        });
    }

    private Duration extractMaxAge(Response response) {
        CacheControl cacheControl;
        String header = response.getHeader("Cache-Control");
        if (header != null && (cacheControl = CacheControl.valueOf((String)header)).getMaxAge() > 0) {
            return new Duration((double)cacheControl.getMaxAge(), TimeUnit.SECONDS);
        }
        return DiscoveryAnnouncementClient.DEFAULT_DELAY;
    }

    private class DiscoveryResponseHandler<T>
    implements ResponseHandler<T, DiscoveryException> {
        private final String name;

        DiscoveryResponseHandler(String name) {
            this.name = name;
        }

        public T handle(Request request, Response response) {
            return null;
        }

        public final T handleException(Request request, Exception exception) {
            if (exception instanceof InterruptedException) {
                throw new DiscoveryException(this.name + " was interrupted");
            }
            if (exception instanceof CancellationException) {
                throw new DiscoveryException(this.name + " was canceled");
            }
            if (exception instanceof DiscoveryException) {
                throw (DiscoveryException)exception;
            }
            throw new DiscoveryException(this.name + " failed", exception);
        }
    }
}

