/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.discovery.client;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Provider;
import com.proofpoint.discovery.client.HttpServiceSelector;
import com.proofpoint.discovery.client.HttpServiceSelectorImpl;
import com.proofpoint.discovery.client.ServiceSelector;
import com.proofpoint.discovery.client.ServiceTypes;
import java.lang.annotation.Annotation;

class HttpServiceSelectorProvider
implements Provider<HttpServiceSelector> {
    private final String type;
    private Injector injector;

    public HttpServiceSelectorProvider(String type) {
        Preconditions.checkNotNull((Object)type);
        this.type = type;
    }

    @Inject
    public void setInjector(Injector injector) {
        this.injector = injector;
    }

    public HttpServiceSelector get() {
        Preconditions.checkNotNull((Object)this.injector, (Object)"injector is null");
        ServiceSelector serviceSelector = (ServiceSelector)this.injector.getInstance(Key.get(ServiceSelector.class, (Annotation)ServiceTypes.serviceType(this.type)));
        HttpServiceSelectorImpl httpServiceSelector = new HttpServiceSelectorImpl(serviceSelector);
        return httpServiceSelector;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpServiceSelectorProvider that = (HttpServiceSelectorProvider)o;
        return this.type.equals(that.type);
    }

    public int hashCode() {
        return this.type.hashCode();
    }
}

