/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.discovery.client;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.proofpoint.concurrent.Threads;
import com.proofpoint.discovery.client.DiscoveryClientConfig;
import com.proofpoint.discovery.client.ServiceDescriptor;
import com.proofpoint.discovery.client.ServiceDescriptorsListener;
import com.proofpoint.discovery.client.ServiceDescriptorsRepresentation;
import com.proofpoint.discovery.client.ServiceInventoryConfig;
import com.proofpoint.discovery.client.ServiceType;
import com.proofpoint.discovery.client.balancing.HttpServiceBalancerListenerAdapter;
import com.proofpoint.http.client.balancing.HttpServiceBalancerImpl;
import com.proofpoint.json.JsonCodec;
import com.proofpoint.log.Logger;
import com.proofpoint.node.NodeInfo;
import com.proofpoint.units.Duration;
import java.io.File;
import java.net.URI;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.weakref.jmx.Managed;

public class ServiceInventory {
    private static final Logger log = Logger.get(ServiceInventory.class);
    private final String environment;
    private final URI serviceInventoryUri;
    private final Duration updateInterval;
    private final JsonCodec<ServiceDescriptorsRepresentation> serviceDescriptorsCodec;
    private final ServiceDescriptorsListener discoveryListener;
    private final AtomicReference<List<ServiceDescriptor>> serviceDescriptors = new AtomicReference<ImmutableList>(ImmutableList.of());
    private final ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor(Threads.daemonThreadsNamed((String)"service-inventory-%s"));
    private final AtomicBoolean serverUp = new AtomicBoolean(true);
    private ScheduledFuture<?> scheduledFuture = null;

    @Inject
    public ServiceInventory(ServiceInventoryConfig serviceInventoryConfig, DiscoveryClientConfig discoveryClientConfig, NodeInfo nodeInfo, JsonCodec<ServiceDescriptorsRepresentation> serviceDescriptorsCodec, @ServiceType(value="discovery") HttpServiceBalancerImpl discoveryBalancer) {
        Preconditions.checkNotNull((Object)serviceInventoryConfig, (Object)"serviceInventoryConfig is null");
        Preconditions.checkNotNull((Object)discoveryClientConfig, (Object)"discoveryClientConfig is null");
        Preconditions.checkNotNull((Object)nodeInfo, (Object)"nodeInfo is null");
        Preconditions.checkNotNull(serviceDescriptorsCodec, (Object)"serviceDescriptorsCodec is null");
        Preconditions.checkNotNull((Object)discoveryBalancer, (Object)"discoveryBalancer is null");
        this.environment = nodeInfo.getEnvironment();
        this.serviceInventoryUri = serviceInventoryConfig.getServiceInventoryUri();
        this.updateInterval = serviceInventoryConfig.getUpdateInterval();
        this.serviceDescriptorsCodec = serviceDescriptorsCodec;
        this.discoveryListener = new HttpServiceBalancerListenerAdapter(discoveryBalancer);
        if (this.serviceInventoryUri != null) {
            String scheme = this.serviceInventoryUri.getScheme().toLowerCase();
            Preconditions.checkArgument((boolean)scheme.equals("file"), (Object)"Service inventory uri must have a file scheme");
            try {
                this.updateServiceInventory();
            }
            catch (Exception ignored) {}
        } else {
            URI uri = discoveryClientConfig.getDiscoveryServiceURI();
            if (uri != null) {
                discoveryBalancer.updateHttpUris((Set)ImmutableSet.of((Object)uri));
            }
        }
    }

    @PostConstruct
    public synchronized void start() {
        if (this.serviceInventoryUri == null || this.scheduledFuture != null) {
            return;
        }
        this.scheduledFuture = this.executorService.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    ServiceInventory.this.updateServiceInventory();
                }
                catch (Throwable e) {
                    log.error(e, "Unexpected exception from service inventory update", new Object[0]);
                }
            }
        }, this.updateInterval.toMillis(), this.updateInterval.toMillis(), TimeUnit.MILLISECONDS);
    }

    @PreDestroy
    public synchronized void stop() {
        if (this.scheduledFuture != null) {
            this.scheduledFuture.cancel(true);
            this.scheduledFuture = null;
        }
    }

    public Iterable<ServiceDescriptor> getServiceDescriptors() {
        return this.serviceDescriptors.get();
    }

    public Iterable<ServiceDescriptor> getServiceDescriptors(final String type) {
        return Iterables.filter(this.getServiceDescriptors(), (Predicate)new Predicate<ServiceDescriptor>(){

            public boolean apply(ServiceDescriptor serviceDescriptor) {
                return serviceDescriptor.getType().equals(type);
            }
        });
    }

    public Iterable<ServiceDescriptor> getServiceDescriptors(final String type, final String pool) {
        return Iterables.filter(this.getServiceDescriptors(), (Predicate)new Predicate<ServiceDescriptor>(){

            public boolean apply(ServiceDescriptor serviceDescriptor) {
                return serviceDescriptor.getType().equals(type) && serviceDescriptor.getPool().equals(pool);
            }
        });
    }

    @Managed
    public final void updateServiceInventory() {
        if (this.serviceInventoryUri == null) {
            return;
        }
        try {
            File file = new File(this.serviceInventoryUri);
            ServiceDescriptorsRepresentation serviceDescriptorsRepresentation = (ServiceDescriptorsRepresentation)this.serviceDescriptorsCodec.fromJson(Files.readAllBytes(file.toPath()));
            if (!this.environment.equals(serviceDescriptorsRepresentation.getEnvironment())) {
                this.logServerError("Expected environment to be %s, but was %s", this.environment, serviceDescriptorsRepresentation.getEnvironment());
            }
            ArrayList descriptors = Lists.newArrayList(serviceDescriptorsRepresentation.getServiceDescriptors());
            Collections.shuffle(descriptors);
            this.serviceDescriptors.set((List<ServiceDescriptor>)ImmutableList.copyOf((Collection)descriptors));
            this.discoveryListener.updateServiceDescriptors(Collections2.filter((Collection)descriptors, (Predicate)new Predicate<ServiceDescriptor>(){

                public boolean apply(ServiceDescriptor input) {
                    return "discovery".equals(input.getType());
                }
            }));
            if (this.serverUp.compareAndSet(false, true)) {
                log.info("ServiceInventory connect succeeded", new Object[0]);
            }
        }
        catch (Exception e) {
            this.logServerError(e, "Error loading service inventory from %s", this.serviceInventoryUri.toASCIIString());
        }
    }

    private void logServerError(String message, Object ... args) {
        if (this.serverUp.compareAndSet(true, false)) {
            log.error(message, args);
        }
    }

    private void logServerError(Exception e, String message, Object ... args) {
        if (this.serverUp.compareAndSet(true, false)) {
            log.error((Throwable)e, message, args);
        }
    }
}

