/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.discovery.client.announce;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.proofpoint.discovery.client.announce.ServiceAnnouncement;
import java.util.Set;

public class Announcement {
    private final String environment;
    private final String nodeId;
    private final String location;
    private final String pool;
    private final Set<ServiceAnnouncement> services;

    public Announcement(String environment, String nodeId, String pool, String location, Set<ServiceAnnouncement> services) {
        Preconditions.checkNotNull((Object)environment, (Object)"environment is null");
        Preconditions.checkNotNull((Object)nodeId, (Object)"nodeId is null");
        Preconditions.checkNotNull(services, (Object)"services is null");
        Preconditions.checkNotNull((Object)pool, (Object)"pool is null");
        Preconditions.checkArgument((!services.isEmpty() ? 1 : 0) != 0, (Object)"services is empty");
        this.environment = environment;
        this.nodeId = nodeId;
        this.location = location;
        this.pool = pool;
        this.services = ImmutableSet.copyOf(services);
    }

    @JsonProperty
    public String getEnvironment() {
        return this.environment;
    }

    @JsonProperty
    public String getNodeId() {
        return this.nodeId;
    }

    @JsonProperty
    public String getLocation() {
        return this.location;
    }

    @JsonProperty
    public String getPool() {
        return this.pool;
    }

    @JsonProperty
    public Set<ServiceAnnouncement> getServices() {
        return this.services;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Announcement that = (Announcement)o;
        return this.nodeId.equals(that.nodeId);
    }

    public int hashCode() {
        return this.nodeId.hashCode();
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("environment", (Object)this.environment).add("nodeId", (Object)this.nodeId).add("location", (Object)this.location).add("pool", (Object)this.pool).add("services", this.services).toString();
    }
}

