/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.discovery.client.announce;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.MapMaker;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.inject.Inject;
import com.proofpoint.concurrent.Threads;
import com.proofpoint.discovery.client.DiscoveryException;
import com.proofpoint.discovery.client.ExponentialBackOff;
import com.proofpoint.discovery.client.announce.DiscoveryAnnouncementClient;
import com.proofpoint.discovery.client.announce.ServiceAnnouncement;
import com.proofpoint.log.Logger;
import com.proofpoint.units.Duration;
import java.net.ConnectException;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.PreDestroy;

public class Announcer {
    private static final Logger log = Logger.get(Announcer.class);
    private final ConcurrentMap<UUID, ServiceAnnouncement> announcements = new MapMaker().makeMap();
    private final DiscoveryAnnouncementClient announcementClient;
    private final ScheduledExecutorService executor;
    private final AtomicBoolean started = new AtomicBoolean(false);
    private final ExponentialBackOff errorBackOff = new ExponentialBackOff(new Duration(1.0, TimeUnit.MILLISECONDS), new Duration(1.0, TimeUnit.SECONDS), "Discovery server connect succeeded for announce", "Cannot connect to discovery server for announce", log);

    @Inject
    public Announcer(DiscoveryAnnouncementClient announcementClient, Set<ServiceAnnouncement> serviceAnnouncements) {
        Preconditions.checkNotNull((Object)announcementClient, (Object)"client is null");
        Preconditions.checkNotNull(serviceAnnouncements, (Object)"serviceAnnouncements is null");
        this.announcementClient = announcementClient;
        for (ServiceAnnouncement serviceAnnouncement : serviceAnnouncements) {
            this.announcements.put(serviceAnnouncement.getId(), serviceAnnouncement);
        }
        this.executor = new ScheduledThreadPoolExecutor(5, Threads.daemonThreadsNamed((String)"Announcer-%s"));
    }

    public void start() {
        Preconditions.checkState((!this.executor.isShutdown() ? 1 : 0) != 0, (Object)"Announcer has been destroyed");
        if (this.started.compareAndSet(false, true)) {
            this.announce();
        }
    }

    @PreDestroy
    public void destroy() {
        this.executor.shutdownNow();
        try {
            this.executor.awaitTermination(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        if (!this.started.get()) {
            return;
        }
        try {
            Announcer.getFutureResult(this.announcementClient.unannounce(), DiscoveryException.class);
        }
        catch (DiscoveryException e) {
            if (e.getCause() instanceof ConnectException) {
                log.error("Cannot connect to discovery server for unannounce: %s", new Object[]{e.getCause().getMessage()});
            }
            log.error((Throwable)e);
        }
    }

    public void addServiceAnnouncement(ServiceAnnouncement serviceAnnouncement) {
        Preconditions.checkNotNull((Object)serviceAnnouncement, (Object)"serviceAnnouncement is null");
        this.announcements.put(serviceAnnouncement.getId(), serviceAnnouncement);
    }

    public void removeServiceAnnouncement(UUID serviceId) {
        this.announcements.remove(serviceId);
    }

    private ListenableFuture<Duration> announce() {
        ListenableFuture<Duration> future = this.announcementClient.announce((Set<ServiceAnnouncement>)ImmutableSet.copyOf(this.announcements.values()));
        Futures.addCallback(future, (FutureCallback)new FutureCallback<Duration>(){

            public void onSuccess(Duration duration) {
                Announcer.this.errorBackOff.success();
                duration = new Duration((double)duration.toMillis() * 0.8, TimeUnit.MILLISECONDS);
                Announcer.this.scheduleNextAnnouncement(duration);
            }

            public void onFailure(Throwable t) {
                Duration duration = Announcer.this.errorBackOff.failed(t);
                Announcer.this.scheduleNextAnnouncement(duration);
            }
        }, (Executor)this.executor);
        return future;
    }

    private void scheduleNextAnnouncement(Duration delay) {
        if (this.executor.isShutdown()) {
            return;
        }
        this.executor.schedule(new Runnable(){

            @Override
            public void run() {
                Announcer.this.announce();
            }
        }, delay.toMillis(), TimeUnit.MILLISECONDS);
    }

    private static <T, X extends Throwable> T getFutureResult(Future<T> future, Class<X> type) throws X {
        try {
            return future.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw Throwables.propagate((Throwable)e);
        }
        catch (ExecutionException e) {
            Throwables.propagateIfPossible((Throwable)e.getCause(), type);
            throw Throwables.propagate((Throwable)e.getCause());
        }
    }
}

