/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.discovery.client.balancing;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import com.proofpoint.discovery.client.DiscoveryLookupClient;
import com.proofpoint.discovery.client.ForDiscoveryClient;
import com.proofpoint.discovery.client.ServiceDescriptorsUpdater;
import com.proofpoint.discovery.client.ServiceSelectorConfig;
import com.proofpoint.discovery.client.balancing.HttpServiceBalancerListenerAdapter;
import com.proofpoint.http.client.balancing.HttpServiceBalancer;
import com.proofpoint.http.client.balancing.HttpServiceBalancerImpl;
import com.proofpoint.http.client.balancing.HttpServiceBalancerStats;
import com.proofpoint.node.NodeInfo;
import com.proofpoint.reporting.ReportCollectionFactory;
import java.util.concurrent.ScheduledExecutorService;
import org.weakref.jmx.ObjectNameBuilder;

public final class HttpServiceBalancerFactory {
    private final DiscoveryLookupClient lookupClient;
    private final ScheduledExecutorService executor;
    private final ReportCollectionFactory reportCollectionFactory;

    @Inject
    public HttpServiceBalancerFactory(DiscoveryLookupClient lookupClient, @ForDiscoveryClient ScheduledExecutorService executor, ReportCollectionFactory reportCollectionFactory) {
        Preconditions.checkNotNull((Object)lookupClient, (Object)"client is null");
        Preconditions.checkNotNull((Object)executor, (Object)"executor is null");
        Preconditions.checkNotNull((Object)reportCollectionFactory, (Object)"reportCollectionFactory is null");
        this.lookupClient = lookupClient;
        this.executor = executor;
        this.reportCollectionFactory = reportCollectionFactory;
    }

    public HttpServiceBalancer createHttpServiceBalancer(String type, ServiceSelectorConfig selectorConfig, NodeInfo nodeInfo) {
        Preconditions.checkNotNull((Object)type, (Object)"type is null");
        Preconditions.checkNotNull((Object)selectorConfig, (Object)"selectorConfig is null");
        String pool = (String)Objects.firstNonNull((Object)selectorConfig.getPool(), (Object)nodeInfo.getPool());
        String name = new ObjectNameBuilder(HttpServiceBalancerStats.class.getPackage().getName()).withProperty("type", "ServiceClient").withProperty("serviceType", type).build();
        HttpServiceBalancerStats httpServiceBalancerStats = (HttpServiceBalancerStats)this.reportCollectionFactory.createReportCollection(HttpServiceBalancerStats.class, name);
        HttpServiceBalancerImpl balancer = new HttpServiceBalancerImpl(String.format("type=[%s], pool=[%s]", type, pool), httpServiceBalancerStats);
        ServiceDescriptorsUpdater updater = new ServiceDescriptorsUpdater(new HttpServiceBalancerListenerAdapter(balancer), type, selectorConfig, nodeInfo, this.lookupClient, this.executor);
        updater.start();
        return balancer;
    }
}

