/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.discovery.client.balancing;

import com.google.common.collect.ImmutableSet;
import com.proofpoint.discovery.client.ServiceDescriptor;
import com.proofpoint.discovery.client.ServiceDescriptorsListener;
import com.proofpoint.http.client.balancing.HttpServiceBalancerImpl;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Set;

public class HttpServiceBalancerListenerAdapter
implements ServiceDescriptorsListener {
    private final HttpServiceBalancerImpl balancer;

    public HttpServiceBalancerListenerAdapter(HttpServiceBalancerImpl balancer) {
        this.balancer = balancer;
    }

    @Override
    public void updateServiceDescriptors(Iterable<ServiceDescriptor> newDescriptors) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (ServiceDescriptor serviceDescriptor : newDescriptors) {
            String http;
            String https = serviceDescriptor.getProperties().get("https");
            if (https != null) {
                try {
                    builder.add((Object)new URI(https));
                    continue;
                }
                catch (URISyntaxException ignored) {
                    // empty catch block
                }
            }
            if ((http = serviceDescriptor.getProperties().get("http")) == null) continue;
            try {
                builder.add((Object)new URI(http));
            }
            catch (URISyntaxException ignored) {}
        }
        this.balancer.updateHttpUris((Set)builder.build());
    }
}

