/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.discovery.client.balancing;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Provider;
import com.proofpoint.discovery.client.ServiceSelectorConfig;
import com.proofpoint.discovery.client.ServiceTypes;
import com.proofpoint.discovery.client.balancing.HttpServiceBalancerFactory;
import com.proofpoint.http.client.balancing.HttpServiceBalancer;
import com.proofpoint.node.NodeInfo;
import java.lang.annotation.Annotation;

public final class HttpServiceBalancerProvider
implements Provider<HttpServiceBalancer> {
    private final String type;
    private HttpServiceBalancerFactory serviceBalancerFactory;
    private Injector injector;
    private NodeInfo nodeInfo;

    public HttpServiceBalancerProvider(String type) {
        Preconditions.checkNotNull((Object)type, (Object)"type is null");
        this.type = type;
    }

    @Inject
    public void setInjector(Injector injector) {
        Preconditions.checkNotNull((Object)injector, (Object)"injector is null");
        this.injector = injector;
    }

    @Inject
    public void setServiceBalancerFactory(HttpServiceBalancerFactory serviceBalancerFactory) {
        Preconditions.checkNotNull((Object)serviceBalancerFactory, (Object)"serviceBalancerFactory is null");
        this.serviceBalancerFactory = serviceBalancerFactory;
    }

    @Inject
    public void setNodeInfo(NodeInfo nodeInfo) {
        Preconditions.checkNotNull((Object)nodeInfo, (Object)"nodeInfo is null");
        this.nodeInfo = nodeInfo;
    }

    public HttpServiceBalancer get() {
        Preconditions.checkNotNull((Object)this.serviceBalancerFactory, (Object)"serviceBalancerFactory is null");
        Preconditions.checkNotNull((Object)this.injector, (Object)"injector is null");
        Preconditions.checkNotNull((Object)this.nodeInfo, (Object)"nodeInfo is null");
        ServiceSelectorConfig selectorConfig = (ServiceSelectorConfig)this.injector.getInstance(Key.get(ServiceSelectorConfig.class, (Annotation)ServiceTypes.serviceType(this.type)));
        HttpServiceBalancer serviceBalancer = this.serviceBalancerFactory.createHttpServiceBalancer(this.type, selectorConfig, this.nodeInfo);
        return serviceBalancer;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.type, this.serviceBalancerFactory, this.injector});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        HttpServiceBalancerProvider other = (HttpServiceBalancerProvider)obj;
        return Objects.equal((Object)this.type, (Object)other.type) && Objects.equal((Object)this.serviceBalancerFactory, (Object)other.serviceBalancerFactory) && Objects.equal((Object)this.injector, (Object)other.injector);
    }
}

