/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.discovery.client.testing;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import com.proofpoint.discovery.client.DiscoveryException;
import com.proofpoint.discovery.client.DiscoveryLookupClient;
import com.proofpoint.discovery.client.ServiceDescriptor;
import com.proofpoint.discovery.client.ServiceDescriptors;
import com.proofpoint.discovery.client.ServiceSelector;
import com.proofpoint.discovery.client.ServiceSelectorConfig;
import com.proofpoint.log.Logger;
import com.proofpoint.node.NodeInfo;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class SimpleServiceSelector
implements ServiceSelector {
    private static final Logger log = Logger.get(SimpleServiceSelector.class);
    private final String type;
    private final String pool;
    private final DiscoveryLookupClient lookupClient;

    public SimpleServiceSelector(String type, ServiceSelectorConfig selectorConfig, NodeInfo nodeInfo, DiscoveryLookupClient lookupClient) {
        Preconditions.checkNotNull((Object)type, (Object)"type is null");
        Preconditions.checkNotNull((Object)selectorConfig, (Object)"selectorConfig is null");
        Preconditions.checkNotNull((Object)lookupClient, (Object)"client is null");
        this.type = type;
        this.pool = (String)Objects.firstNonNull((Object)selectorConfig.getPool(), (Object)nodeInfo.getPool());
        this.lookupClient = lookupClient;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getPool() {
        return this.pool;
    }

    @Override
    public List<ServiceDescriptor> selectAllServices() {
        try {
            ListenableFuture<ServiceDescriptors> future = this.lookupClient.getServices(this.type, this.pool);
            ServiceDescriptors serviceDescriptors = SimpleServiceSelector.getFutureResult(future, DiscoveryException.class);
            return serviceDescriptors.getServiceDescriptors();
        }
        catch (DiscoveryException e) {
            log.error((Throwable)e);
            return ImmutableList.of();
        }
    }

    private static <T, X extends Throwable> T getFutureResult(Future<T> future, Class<X> type) throws X {
        try {
            return future.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw Throwables.propagate((Throwable)e);
        }
        catch (ExecutionException e) {
            Throwables.propagateIfPossible((Throwable)e.getCause(), type);
            throw Throwables.propagate((Throwable)e.getCause());
        }
    }
}

