/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.discovery.client.testing;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import com.proofpoint.discovery.client.DiscoveryLookupClient;
import com.proofpoint.discovery.client.ServiceSelector;
import com.proofpoint.discovery.client.ServiceSelectorConfig;
import com.proofpoint.discovery.client.ServiceSelectorFactory;
import com.proofpoint.discovery.client.testing.SimpleServiceSelector;
import com.proofpoint.node.NodeInfo;

public class SimpleServiceSelectorFactory
implements ServiceSelectorFactory {
    private final DiscoveryLookupClient lookupClient;
    private final NodeInfo nodeInfo;

    @Inject
    public SimpleServiceSelectorFactory(DiscoveryLookupClient lookupClient, NodeInfo nodeInfo) {
        Preconditions.checkNotNull((Object)lookupClient, (Object)"client is null");
        Preconditions.checkNotNull((Object)nodeInfo, (Object)"nodeInfo is null");
        this.lookupClient = lookupClient;
        this.nodeInfo = nodeInfo;
    }

    @Override
    public ServiceSelector createServiceSelector(String type, ServiceSelectorConfig selectorConfig) {
        Preconditions.checkNotNull((Object)type, (Object)"type is null");
        Preconditions.checkNotNull((Object)selectorConfig, (Object)"selectorConfig is null");
        return new SimpleServiceSelector(type, selectorConfig, this.nodeInfo, this.lookupClient);
    }
}

