/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.event.client;

import com.google.common.collect.Lists;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;

class AnnotationUtils {
    AnnotationUtils() {
    }

    public static Collection<Method> findAnnotatedMethods(Class<?> clazz, Class<? extends Annotation> annotation) {
        ArrayList result = Lists.newArrayList();
        for (Method method : clazz.getMethods()) {
            Method managedMethod;
            if (method.isSynthetic() || method.isBridge() || Modifier.isStatic(method.getModifiers()) || (managedMethod = AnnotationUtils.findAnnotatedMethod(clazz, annotation, method.getName(), method.getParameterTypes())) == null) continue;
            result.add(managedMethod);
        }
        return result;
    }

    private static Method findAnnotatedMethod(Class<?> clazz, Class<? extends Annotation> annotation, String methodName, Class<?> ... paramTypes) {
        Method managedMethod;
        try {
            Method method = clazz.getDeclaredMethod(methodName, paramTypes);
            if (method.isAnnotationPresent(annotation)) {
                return method;
            }
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        if (clazz.getSuperclass() != null && (managedMethod = AnnotationUtils.findAnnotatedMethod(clazz.getSuperclass(), annotation, methodName, paramTypes)) != null) {
            return managedMethod;
        }
        for (Class<?> iface : clazz.getInterfaces()) {
            Method managedMethod2 = AnnotationUtils.findAnnotatedMethod(iface, annotation, methodName, paramTypes);
            if (managedMethod2 == null) continue;
            return managedMethod2;
        }
        return null;
    }
}

