/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.event.client;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.inject.Binder;
import com.google.inject.TypeLiteral;
import com.google.inject.multibindings.Multibinder;
import com.proofpoint.event.client.EventTypeMetadata;
import java.util.List;

@Beta
public class EventBinder {
    private final Binder binder;

    public static EventBinder eventBinder(Binder binder) {
        return new EventBinder(binder);
    }

    private EventBinder(Binder binder) {
        this.binder = binder;
    }

    public void bindEventClient(Class<?> ... types) {
        this.bindGenericEventClient(types);
    }

    public void bindGenericEventClient(Class<?> ... eventTypes) {
        Preconditions.checkNotNull(eventTypes, (Object)"eventTypes is null");
        this.bindGenericEventClient((List<Class<?>>)ImmutableList.copyOf((Object[])eventTypes));
    }

    public void bindGenericEventClient(List<Class<?>> eventTypes) {
        Preconditions.checkNotNull(eventTypes, (Object)"eventTypes is null");
        Preconditions.checkArgument((!eventTypes.isEmpty() ? 1 : 0) != 0, (Object)"eventTypes is empty");
        Binder sourcedBinder = this.binder.withSource((Object)EventBinder.getCaller());
        Multibinder metadataBinder = Multibinder.newSetBinder((Binder)this.binder, (TypeLiteral)new TypeLiteral<EventTypeMetadata<?>>(){});
        for (Class<?> eventType : eventTypes) {
            EventTypeMetadata<?> eventTypeMetadata = EventTypeMetadata.getEventTypeMetadata(eventType);
            metadataBinder.addBinding().toInstance(eventTypeMetadata);
            for (String error : eventTypeMetadata.getErrors()) {
                sourcedBinder.addError(error, new Object[0]);
            }
        }
    }

    private static StackTraceElement getCaller() {
        StackTraceElement[] stack = Thread.currentThread().getStackTrace();
        boolean foundThisClass = false;
        for (StackTraceElement element : stack) {
            if (!foundThisClass) {
                if (!element.getClassName().equals(EventBinder.class.getName())) continue;
                foundThisClass = true;
                continue;
            }
            if (element.getClassName().equals(EventBinder.class.getName())) continue;
            return element;
        }
        return null;
    }
}

