/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.event.client;

import com.fasterxml.jackson.core.JsonGenerator;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.proofpoint.event.client.EventDataType;
import com.proofpoint.event.client.EventTypeMetadata;
import com.proofpoint.event.client.InvalidEventException;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.Comparator;
import java.util.Deque;
import java.util.List;
import java.util.Map;

class EventFieldMetadata {
    public static final Comparator<EventFieldMetadata> NAME_COMPARATOR = new Comparator<EventFieldMetadata>(){

        @Override
        public int compare(EventFieldMetadata a, EventFieldMetadata b) {
            return a.name.compareTo(b.name);
        }
    };
    private final String name;
    private final Method method;
    private final EventDataType eventDataType;
    private final EventTypeMetadata<?> nestedType;
    private final ContainerType containerType;

    EventFieldMetadata(String name, Method method, EventDataType eventDataType, EventTypeMetadata<?> nestedType, ContainerType containerType) {
        Preconditions.checkArgument((eventDataType != null || nestedType != null ? 1 : 0) != 0, (Object)"both eventDataType and nestedType are null");
        Preconditions.checkArgument((eventDataType == null || nestedType == null ? 1 : 0) != 0, (Object)"both eventDataType and nestedType are set");
        this.name = name;
        this.method = method;
        this.eventDataType = eventDataType;
        this.nestedType = nestedType;
        this.containerType = containerType;
    }

    private Object getValue(Object event) throws InvalidEventException {
        try {
            return this.method.invoke(event, new Object[0]);
        }
        catch (Exception e) {
            throw new InvalidEventException((Throwable)Objects.firstNonNull((Object)e.getCause(), (Object)e), "Unable to get value of event field %s: Exception occurred while invoking [%s]", this.name, this.method.toGenericString());
        }
    }

    public void writeField(JsonGenerator jsonGenerator, Object event) throws IOException {
        this.writeField(jsonGenerator, event, new ArrayDeque<Object>());
    }

    private void writeField(JsonGenerator jsonGenerator, Object event, Deque<Object> objectStack) throws IOException {
        Object value = this.getValue(event);
        if (value != null) {
            jsonGenerator.writeFieldName(this.name);
            if (this.containerType == ContainerType.ITERABLE) {
                EventDataType.validateFieldValueType(value, Iterable.class);
                this.writeArray(jsonGenerator, (Iterable)value, objectStack);
            } else if (this.containerType == ContainerType.MAP) {
                EventDataType.validateFieldValueType(value, Map.class);
                this.writeMap(jsonGenerator, (Map)value, objectStack);
            } else if (this.containerType == ContainerType.MULTIMAP) {
                EventDataType.validateFieldValueType(value, Multimap.class);
                this.writeMultimap(jsonGenerator, (Multimap)value, objectStack);
            } else {
                this.writeFieldValue(jsonGenerator, value, objectStack);
            }
        }
    }

    private void writeFieldValue(JsonGenerator jsonGenerator, Object value, Deque<Object> objectStack) throws IOException {
        if (this.eventDataType != null) {
            this.eventDataType.writeFieldValue(jsonGenerator, value);
        } else {
            EventDataType.validateFieldValueType(value, this.nestedType.getEventClass());
            this.writeObject(jsonGenerator, value, objectStack);
        }
    }

    private void writeArray(JsonGenerator jsonGenerator, Iterable<?> value, Deque<Object> objectStack) throws IOException {
        jsonGenerator.writeStartArray();
        for (Object item : value) {
            this.writeFieldValue(jsonGenerator, item, objectStack);
        }
        jsonGenerator.writeEndArray();
    }

    private void writeMap(JsonGenerator jsonGenerator, Map<?, ?> value, Deque<Object> objectStack) throws IOException {
        jsonGenerator.writeStartObject();
        for (Map.Entry<?, ?> entry : value.entrySet()) {
            jsonGenerator.writeFieldName((String)entry.getKey());
            this.writeFieldValue(jsonGenerator, entry.getValue(), objectStack);
        }
        jsonGenerator.writeEndObject();
    }

    private void writeMultimap(JsonGenerator jsonGenerator, Multimap<?, ?> value, Deque<Object> objectStack) throws IOException {
        jsonGenerator.writeStartObject();
        for (Map.Entry entry : value.asMap().entrySet()) {
            jsonGenerator.writeFieldName((String)entry.getKey());
            this.writeArray(jsonGenerator, (Iterable)entry.getValue(), objectStack);
        }
        jsonGenerator.writeEndObject();
    }

    private void writeObject(JsonGenerator jsonGenerator, Object value, Deque<Object> objectStack) throws IOException {
        EventFieldMetadata.checkForCycles(value, objectStack);
        objectStack.push(value);
        jsonGenerator.writeStartObject();
        for (EventFieldMetadata field : this.nestedType.getFields()) {
            field.writeField(jsonGenerator, value, objectStack);
        }
        jsonGenerator.writeEndObject();
        objectStack.pop();
    }

    private static void checkForCycles(Object value, Deque<Object> objectStack) throws InvalidEventException {
        for (Object o : objectStack) {
            if (value != o) continue;
            List path = Lists.reverse((List)Lists.newArrayList(objectStack));
            throw new InvalidEventException("Cycle detected in event data: %s", path);
        }
    }

    public static enum ContainerType {
        ITERABLE,
        MAP,
        MULTIMAP;


        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

