/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.event.client;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.google.common.base.Preconditions;
import com.proofpoint.event.client.EventDataType;
import com.proofpoint.event.client.EventFieldMetadata;
import com.proofpoint.event.client.EventTypeMetadata;
import com.proofpoint.node.NodeInfo;
import java.io.IOException;
import java.util.UUID;
import javax.annotation.Nullable;
import org.joda.time.DateTime;

class EventJsonSerializer<T>
extends JsonSerializer<T> {
    private final String token;
    private final EventTypeMetadata<T> eventTypeMetadata;
    private final String hostName;

    public EventJsonSerializer(NodeInfo nodeInfo, @Nullable String token, EventTypeMetadata<T> eventTypeMetadata) {
        this.token = token;
        this.eventTypeMetadata = (EventTypeMetadata)Preconditions.checkNotNull(eventTypeMetadata, (Object)"eventTypeMetadata is null");
        this.hostName = eventTypeMetadata.getHostField() == null ? nodeInfo.getInternalHostname() : null;
    }

    public Class<T> handledType() {
        return this.eventTypeMetadata.getEventClass();
    }

    public void serialize(T event, JsonGenerator jsonGenerator, SerializerProvider provider) throws IOException {
        jsonGenerator.writeStartObject();
        jsonGenerator.writeStringField("type", this.eventTypeMetadata.getTypeName());
        if (this.eventTypeMetadata.getUuidField() != null) {
            this.eventTypeMetadata.getUuidField().writeField(jsonGenerator, event);
        } else {
            jsonGenerator.writeStringField("uuid", UUID.randomUUID().toString());
        }
        if (this.eventTypeMetadata.getHostField() != null) {
            this.eventTypeMetadata.getHostField().writeField(jsonGenerator, event);
        } else {
            jsonGenerator.writeStringField("host", this.hostName);
        }
        if (this.eventTypeMetadata.getTimestampField() != null) {
            this.eventTypeMetadata.getTimestampField().writeField(jsonGenerator, event);
        } else {
            jsonGenerator.writeFieldName("timestamp");
            EventDataType.DATETIME.writeFieldValue(jsonGenerator, new DateTime());
        }
        if (this.eventTypeMetadata.getTraceTokenField() != null) {
            this.eventTypeMetadata.getTraceTokenField().writeField(jsonGenerator, event);
        } else if (this.token != null) {
            jsonGenerator.writeFieldName("traceToken");
            EventDataType.STRING.writeFieldValue(jsonGenerator, this.token);
        }
        jsonGenerator.writeObjectFieldStart("data");
        for (EventFieldMetadata field : this.eventTypeMetadata.getFields()) {
            field.writeField(jsonGenerator, event);
        }
        jsonGenerator.writeEndObject();
        jsonGenerator.writeEndObject();
        jsonGenerator.flush();
    }
}

