/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.event.client;

import com.google.common.base.Preconditions;
import com.google.common.io.CharStreams;
import com.google.common.net.MediaType;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.inject.Inject;
import com.proofpoint.event.client.EventClient;
import com.proofpoint.event.client.ForEventClient;
import com.proofpoint.event.client.JsonEventWriter;
import com.proofpoint.http.client.BodyGenerator;
import com.proofpoint.http.client.HttpClient;
import com.proofpoint.http.client.Request;
import com.proofpoint.http.client.RequestStats;
import com.proofpoint.http.client.Response;
import com.proofpoint.http.client.ResponseHandler;
import com.proofpoint.http.client.UnexpectedResponseException;
import com.proofpoint.log.Logger;
import com.proofpoint.node.NodeInfo;
import com.proofpoint.tracetoken.TraceTokenManager;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URI;
import java.util.Arrays;
import javax.annotation.Nullable;
import org.weakref.jmx.Flatten;

public class HttpEventClient
implements EventClient {
    private static final Logger log = Logger.get(HttpEventClient.class);
    private static final MediaType MEDIA_TYPE_JSON = MediaType.create((String)"application", (String)"json");
    private static final EventResponseHandler EVENT_RESPONSE_HANDLER = new EventResponseHandler();
    private final JsonEventWriter eventWriter;
    private final HttpClient httpClient;
    private final NodeInfo nodeInfo;
    private final TraceTokenManager traceTokenManager;

    @Inject
    public HttpEventClient(JsonEventWriter eventWriter, NodeInfo nodeInfo, @ForEventClient HttpClient httpClient, TraceTokenManager traceTokenManager) {
        this.eventWriter = (JsonEventWriter)Preconditions.checkNotNull((Object)eventWriter, (Object)"eventWriter is null");
        this.nodeInfo = (NodeInfo)Preconditions.checkNotNull((Object)nodeInfo, (Object)"nodeInfo is null");
        this.httpClient = (HttpClient)Preconditions.checkNotNull((Object)httpClient, (Object)"httpClient is null");
        this.traceTokenManager = (TraceTokenManager)Preconditions.checkNotNull((Object)traceTokenManager, (Object)"traceTokenManager is null");
    }

    @Flatten
    public RequestStats getStats() {
        return this.httpClient.getStats();
    }

    @Override
    @SafeVarargs
    public final <T> ListenableFuture<Void> post(T ... event) throws IllegalArgumentException {
        Preconditions.checkNotNull(event, (Object)"event is null");
        return this.post((Iterable<T>)Arrays.asList(event));
    }

    @Override
    public <T> ListenableFuture<Void> post(final Iterable<T> events) throws IllegalArgumentException {
        Preconditions.checkNotNull(events, (Object)"eventsSupplier is null");
        return this.post(new EventClient.EventGenerator<T>(){

            @Override
            public void generate(EventClient.EventPoster<T> eventPoster) throws IOException {
                for (Object event : events) {
                    eventPoster.post(event);
                }
            }
        });
    }

    @Override
    public <T> ListenableFuture<Void> post(EventClient.EventGenerator<T> eventGenerator) {
        Preconditions.checkNotNull(eventGenerator, (Object)"eventGenerator is null");
        String token = this.traceTokenManager.getCurrentRequestToken();
        Request request = Request.Builder.preparePost().setUri(URI.create("v2/event")).setHeader("User-Agent", this.nodeInfo.getNodeId()).setHeader("Content-Type", MEDIA_TYPE_JSON.toString()).setBodyGenerator(new JsonEntityWriter<T>(this.eventWriter, eventGenerator, token)).build();
        return this.httpClient.executeAsync(request, (ResponseHandler)EVENT_RESPONSE_HANDLER);
    }

    private static class EventResponseHandler
    implements ResponseHandler<Void, Exception> {
        private EventResponseHandler() {
        }

        public Void handleException(Request request, Exception exception) throws Exception {
            log.debug((Throwable)exception, "Posting event to %s failed", new Object[]{request.getUri()});
            throw exception;
        }

        public Void handle(Request request, Response response) {
            int statusCode = response.getStatusCode();
            if (statusCode >= 200 && statusCode <= 299) {
                return null;
            }
            try {
                InputStream inputStream = response.getInputStream();
                String responseBody = CharStreams.toString((Readable)new InputStreamReader(inputStream));
                log.debug("Posting event to %s failed: status_code=%d status_line=%s body=%s", new Object[]{request.getUri(), statusCode, response.getStatusMessage(), responseBody});
            }
            catch (IOException bodyError) {
                log.debug("Posting event to %s failed: status_code=%d status_line=%s error=%s", new Object[]{request.getUri(), statusCode, response.getStatusMessage(), bodyError.getMessage()});
            }
            throw new UnexpectedResponseException(String.format("Posting event to %s failed", request.getUri()), request, response);
        }
    }

    private static class JsonEntityWriter<T>
    implements BodyGenerator {
        private final JsonEventWriter eventWriter;
        private final EventClient.EventGenerator<T> events;
        private final String token;

        public JsonEntityWriter(JsonEventWriter eventWriter, EventClient.EventGenerator<T> events, @Nullable String token) {
            this.eventWriter = (JsonEventWriter)Preconditions.checkNotNull((Object)eventWriter, (Object)"eventWriter is null");
            this.events = (EventClient.EventGenerator)Preconditions.checkNotNull(events, (Object)"events is null");
            this.token = token;
        }

        public void write(OutputStream out) throws Exception {
            this.eventWriter.writeEvents(this.events, this.token, out);
        }
    }
}

